/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.RunnableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.state.AbstractSnapshotStrategy;
import org.apache.flink.runtime.state.AsyncSnapshotCallable;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.CheckpointStreamWithResultProvider;
import org.apache.flink.runtime.state.CheckpointedStateScope;
import org.apache.flink.runtime.state.DoneFuture;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeOffsets;
import org.apache.flink.runtime.state.KeyedBackendSerializationProxy;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.LocalRecoveryConfig;
import org.apache.flink.runtime.state.RegisteredKeyValueStateBackendMetaInfo;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateSerializerProvider;
import org.apache.flink.runtime.state.StateSnapshot;
import org.apache.flink.runtime.state.StateSnapshotRestore;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.UncompressedStreamCompressionDecorator;
import org.apache.flink.runtime.state.heap.HeapPriorityQueueSnapshotRestoreWrapper;
import org.apache.flink.runtime.state.heap.InternalKeyContext;
import org.apache.flink.runtime.state.heap.SnapshotStrategySynchronicityBehavior;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.runtime.state.heap.StateUID;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

class HeapSnapshotStrategy<K>
extends AbstractSnapshotStrategy<KeyedStateHandle>
implements SnapshotStrategySynchronicityBehavior<K> {
    private final SnapshotStrategySynchronicityBehavior<K> snapshotStrategySynchronicityTrait;
    private final Map<String, StateTable<K, ?, ?>> registeredKVStates;
    private final Map<String, HeapPriorityQueueSnapshotRestoreWrapper> registeredPQStates;
    private final StreamCompressionDecorator keyGroupCompressionDecorator;
    private final LocalRecoveryConfig localRecoveryConfig;
    private final KeyGroupRange keyGroupRange;
    private final CloseableRegistry cancelStreamRegistry;
    private final StateSerializerProvider<K> keySerializerProvider;

    HeapSnapshotStrategy(SnapshotStrategySynchronicityBehavior<K> snapshotStrategySynchronicityTrait, Map<String, StateTable<K, ?, ?>> registeredKVStates, Map<String, HeapPriorityQueueSnapshotRestoreWrapper> registeredPQStates, StreamCompressionDecorator keyGroupCompressionDecorator, LocalRecoveryConfig localRecoveryConfig, KeyGroupRange keyGroupRange, CloseableRegistry cancelStreamRegistry, StateSerializerProvider<K> keySerializerProvider) {
        super("Heap backend snapshot");
        this.snapshotStrategySynchronicityTrait = snapshotStrategySynchronicityTrait;
        this.registeredKVStates = registeredKVStates;
        this.registeredPQStates = registeredPQStates;
        this.keyGroupCompressionDecorator = keyGroupCompressionDecorator;
        this.localRecoveryConfig = localRecoveryConfig;
        this.keyGroupRange = keyGroupRange;
        this.cancelStreamRegistry = cancelStreamRegistry;
        this.keySerializerProvider = keySerializerProvider;
    }

    @Override
    @Nonnull
    public RunnableFuture<SnapshotResult<KeyedStateHandle>> snapshot(long checkpointId, long timestamp, final @Nonnull CheckpointStreamFactory primaryStreamFactory, @Nonnull CheckpointOptions checkpointOptions) throws IOException {
        if (!this.hasRegisteredState()) {
            return DoneFuture.of(SnapshotResult.empty());
        }
        int numStates = this.registeredKVStates.size() + this.registeredPQStates.size();
        Preconditions.checkState((numStates <= Short.MAX_VALUE ? 1 : 0) != 0, (Object)("Too many states: " + numStates + ". Currently at most " + Short.MAX_VALUE + " states are supported"));
        ArrayList<StateMetaInfoSnapshot> metaInfoSnapshots = new ArrayList<StateMetaInfoSnapshot>(numStates);
        final HashMap<StateUID, Integer> stateNamesToId = new HashMap<StateUID, Integer>(numStates);
        final HashMap<StateUID, StateSnapshot> cowStateStableSnapshots = new HashMap<StateUID, StateSnapshot>(numStates);
        this.processSnapshotMetaInfoForAllStates(metaInfoSnapshots, cowStateStableSnapshots, stateNamesToId, this.registeredKVStates, StateMetaInfoSnapshot.BackendStateType.KEY_VALUE);
        this.processSnapshotMetaInfoForAllStates(metaInfoSnapshots, cowStateStableSnapshots, stateNamesToId, this.registeredPQStates, StateMetaInfoSnapshot.BackendStateType.PRIORITY_QUEUE);
        final KeyedBackendSerializationProxy<K> serializationProxy = new KeyedBackendSerializationProxy<K>(this.getKeySerializer(), metaInfoSnapshots, !Objects.equals(UncompressedStreamCompressionDecorator.INSTANCE, this.keyGroupCompressionDecorator));
        final SupplierWithException checkpointStreamSupplier = this.localRecoveryConfig.isLocalRecoveryEnabled() && !checkpointOptions.getCheckpointType().isSavepoint() ? () -> CheckpointStreamWithResultProvider.createDuplicatingStream(checkpointId, CheckpointedStateScope.EXCLUSIVE, primaryStreamFactory, this.localRecoveryConfig.getLocalStateDirectoryProvider()) : () -> CheckpointStreamWithResultProvider.createSimpleStream(CheckpointedStateScope.EXCLUSIVE, primaryStreamFactory);
        AsyncSnapshotCallable<SnapshotResult<KeyedStateHandle>> asyncSnapshotCallable = new AsyncSnapshotCallable<SnapshotResult<KeyedStateHandle>>(){

            @Override
            protected SnapshotResult<KeyedStateHandle> callInternal() throws Exception {
                CheckpointStreamWithResultProvider streamWithResultProvider = (CheckpointStreamWithResultProvider)checkpointStreamSupplier.get();
                this.snapshotCloseableRegistry.registerCloseable((Closeable)streamWithResultProvider);
                CheckpointStreamFactory.CheckpointStateOutputStream localStream = streamWithResultProvider.getCheckpointOutputStream();
                DataOutputViewStreamWrapper outView = new DataOutputViewStreamWrapper((OutputStream)((Object)localStream));
                serializationProxy.write((DataOutputView)outView);
                long[] keyGroupRangeOffsets = new long[HeapSnapshotStrategy.this.keyGroupRange.getNumberOfKeyGroups()];
                for (int keyGroupPos = 0; keyGroupPos < HeapSnapshotStrategy.this.keyGroupRange.getNumberOfKeyGroups(); ++keyGroupPos) {
                    int keyGroupId = HeapSnapshotStrategy.this.keyGroupRange.getKeyGroupId(keyGroupPos);
                    keyGroupRangeOffsets[keyGroupPos] = localStream.getPos();
                    outView.writeInt(keyGroupId);
                    for (Map.Entry stateSnapshot : cowStateStableSnapshots.entrySet()) {
                        StateSnapshot.StateKeyGroupWriter partitionedSnapshot = ((StateSnapshot)stateSnapshot.getValue()).getKeyGroupWriter();
                        OutputStream kgCompressionOut = HeapSnapshotStrategy.this.keyGroupCompressionDecorator.decorateWithCompression((OutputStream)((Object)localStream));
                        Throwable throwable = null;
                        try {
                            DataOutputViewStreamWrapper kgCompressionView = new DataOutputViewStreamWrapper(kgCompressionOut);
                            kgCompressionView.writeShort(((Integer)stateNamesToId.get(stateSnapshot.getKey())).intValue());
                            partitionedSnapshot.writeStateInKeyGroup((DataOutputView)kgCompressionView, keyGroupId);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (kgCompressionOut == null) continue;
                            if (throwable != null) {
                                try {
                                    kgCompressionOut.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            kgCompressionOut.close();
                        }
                    }
                }
                if (this.snapshotCloseableRegistry.unregisterCloseable((Closeable)streamWithResultProvider)) {
                    KeyGroupRangeOffsets kgOffs = new KeyGroupRangeOffsets(HeapSnapshotStrategy.this.keyGroupRange, keyGroupRangeOffsets);
                    SnapshotResult<StreamStateHandle> result = streamWithResultProvider.closeAndFinalizeCheckpointStreamResult();
                    return CheckpointStreamWithResultProvider.toKeyedStateHandleSnapshotResult(result, kgOffs);
                }
                throw new IOException("Stream already unregistered.");
            }

            @Override
            protected void cleanupProvidedResources() {
                for (StateSnapshot tableSnapshot : cowStateStableSnapshots.values()) {
                    tableSnapshot.release();
                }
            }

            @Override
            protected void logAsyncSnapshotComplete(long startTime) {
                if (HeapSnapshotStrategy.this.snapshotStrategySynchronicityTrait.isAsynchronous()) {
                    HeapSnapshotStrategy.this.logAsyncCompleted(primaryStreamFactory, startTime);
                }
            }
        };
        AsyncSnapshotCallable.AsyncSnapshotTask task = asyncSnapshotCallable.toAsyncSnapshotFutureTask(this.cancelStreamRegistry);
        this.finalizeSnapshotBeforeReturnHook(task);
        return task;
    }

    @Override
    public void finalizeSnapshotBeforeReturnHook(Runnable runnable) {
        this.snapshotStrategySynchronicityTrait.finalizeSnapshotBeforeReturnHook(runnable);
    }

    @Override
    public boolean isAsynchronous() {
        return this.snapshotStrategySynchronicityTrait.isAsynchronous();
    }

    @Override
    public <N, V> StateTable<K, N, V> newStateTable(InternalKeyContext<K> keyContext, RegisteredKeyValueStateBackendMetaInfo<N, V> newMetaInfo, TypeSerializer<K> keySerializer) {
        return this.snapshotStrategySynchronicityTrait.newStateTable(keyContext, newMetaInfo, keySerializer);
    }

    private void processSnapshotMetaInfoForAllStates(List<StateMetaInfoSnapshot> metaInfoSnapshots, Map<StateUID, StateSnapshot> cowStateStableSnapshots, Map<StateUID, Integer> stateNamesToId, Map<String, ? extends StateSnapshotRestore> registeredStates, StateMetaInfoSnapshot.BackendStateType stateType) {
        for (Map.Entry<String, ? extends StateSnapshotRestore> kvState : registeredStates.entrySet()) {
            StateUID stateUid = StateUID.of(kvState.getKey(), stateType);
            stateNamesToId.put(stateUid, stateNamesToId.size());
            StateSnapshotRestore state = kvState.getValue();
            if (null == state) continue;
            StateSnapshot stateSnapshot = state.stateSnapshot();
            metaInfoSnapshots.add(stateSnapshot.getMetaInfoSnapshot());
            cowStateStableSnapshots.put(stateUid, stateSnapshot);
        }
    }

    private boolean hasRegisteredState() {
        return !this.registeredKVStates.isEmpty() || !this.registeredPQStates.isEmpty();
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializerProvider.currentSchemaSerializer();
    }
}

