/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.KeyExtractorFunction;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.StateSnapshot;
import org.apache.flink.runtime.state.StateSnapshotKeyGroupReader;
import org.apache.flink.util.Preconditions;

public class KeyGroupPartitioner<T> {
    @Nonnull
    protected final T[] partitioningSource;
    @Nonnull
    protected final T[] partitioningDestination;
    @Nonnegative
    protected final int numberOfElements;
    @Nonnegative
    protected final int totalKeyGroups;
    @Nonnull
    protected final KeyGroupRange keyGroupRange;
    @Nonnull
    protected final int[] counterHistogram;
    @Nonnull
    protected final int[] elementKeyGroups;
    @Nonnegative
    protected final int firstKeyGroup;
    @Nonnull
    protected final KeyExtractorFunction<T> keyExtractorFunction;
    @Nonnull
    protected final ElementWriterFunction<T> elementWriterFunction;
    @Nullable
    protected StateSnapshot.StateKeyGroupWriter computedResult;

    public KeyGroupPartitioner(@Nonnull T[] partitioningSource, @Nonnegative int numberOfElements, @Nonnull T[] partitioningDestination, @Nonnull KeyGroupRange keyGroupRange, @Nonnegative int totalKeyGroups, @Nonnull KeyExtractorFunction<T> keyExtractorFunction, @Nonnull ElementWriterFunction<T> elementWriterFunction) {
        Preconditions.checkState((partitioningSource != partitioningDestination ? 1 : 0) != 0);
        Preconditions.checkState((partitioningSource.length >= numberOfElements ? 1 : 0) != 0);
        Preconditions.checkState((partitioningDestination.length >= numberOfElements ? 1 : 0) != 0);
        this.partitioningSource = partitioningSource;
        this.partitioningDestination = partitioningDestination;
        this.numberOfElements = numberOfElements;
        this.keyGroupRange = keyGroupRange;
        this.totalKeyGroups = totalKeyGroups;
        this.keyExtractorFunction = keyExtractorFunction;
        this.elementWriterFunction = elementWriterFunction;
        this.firstKeyGroup = keyGroupRange.getStartKeyGroup();
        this.elementKeyGroups = new int[numberOfElements];
        this.counterHistogram = new int[keyGroupRange.getNumberOfKeyGroups()];
        this.computedResult = null;
    }

    public StateSnapshot.StateKeyGroupWriter partitionByKeyGroup() {
        if (this.computedResult == null) {
            this.reportAllElementKeyGroups();
            int outputNumberOfElements = this.buildHistogramByAccumulatingCounts();
            this.executePartitioning(outputNumberOfElements);
        }
        return this.computedResult;
    }

    protected void reportAllElementKeyGroups() {
        Preconditions.checkState((this.partitioningSource.length >= this.numberOfElements ? 1 : 0) != 0);
        for (int i = 0; i < this.numberOfElements; ++i) {
            int keyGroup = KeyGroupRangeAssignment.assignToKeyGroup(this.keyExtractorFunction.extractKeyFromElement(this.partitioningSource[i]), this.totalKeyGroups);
            this.reportKeyGroupOfElementAtIndex(i, keyGroup);
        }
    }

    protected void reportKeyGroupOfElementAtIndex(int index, int keyGroup) {
        int keyGroupIndex;
        this.elementKeyGroups[index] = keyGroupIndex = keyGroup - this.firstKeyGroup;
        int n = keyGroupIndex;
        this.counterHistogram[n] = this.counterHistogram[n] + 1;
    }

    private int buildHistogramByAccumulatingCounts() {
        int sum = 0;
        for (int i = 0; i < this.counterHistogram.length; ++i) {
            int currentSlotValue = this.counterHistogram[i];
            this.counterHistogram[i] = sum;
            sum += currentSlotValue;
        }
        return sum;
    }

    private void executePartitioning(int outputNumberOfElements) {
        for (int inIdx = 0; inIdx < outputNumberOfElements; ++inIdx) {
            int effectiveKgIdx;
            int n = effectiveKgIdx = this.elementKeyGroups[inIdx];
            this.counterHistogram[n] = this.counterHistogram[n] + 1;
            this.partitioningDestination[outIdx] = this.partitioningSource[inIdx];
        }
        this.computedResult = new PartitioningResult<T>(this.elementWriterFunction, this.firstKeyGroup, this.counterHistogram, this.partitioningDestination);
    }

    public static <T> StateSnapshotKeyGroupReader createKeyGroupPartitionReader(@Nonnull ElementReaderFunction<T> readerFunction, @Nonnull KeyGroupElementsConsumer<T> elementConsumer) {
        return new PartitioningResultKeyGroupReader<T>(readerFunction, elementConsumer);
    }

    @FunctionalInterface
    public static interface KeyGroupElementsConsumer<T> {
        public void consume(@Nonnull T var1, @Nonnegative int var2) throws IOException;
    }

    @FunctionalInterface
    public static interface ElementReaderFunction<T> {
        @Nonnull
        public T readElement(@Nonnull DataInputView var1) throws IOException;
    }

    @FunctionalInterface
    public static interface ElementWriterFunction<T> {
        public void writeElement(@Nonnull T var1, @Nonnull DataOutputView var2) throws IOException;
    }

    private static class PartitioningResultKeyGroupReader<T>
    implements StateSnapshotKeyGroupReader {
        @Nonnull
        private final ElementReaderFunction<T> readerFunction;
        @Nonnull
        private final KeyGroupElementsConsumer<T> elementConsumer;

        public PartitioningResultKeyGroupReader(@Nonnull ElementReaderFunction<T> readerFunction, @Nonnull KeyGroupElementsConsumer<T> elementConsumer) {
            this.readerFunction = readerFunction;
            this.elementConsumer = elementConsumer;
        }

        @Override
        public void readMappingsInKeyGroup(@Nonnull DataInputView in, @Nonnegative int keyGroupId) throws IOException {
            int numElements = in.readInt();
            for (int i = 0; i < numElements; ++i) {
                T element = this.readerFunction.readElement(in);
                this.elementConsumer.consume(element, keyGroupId);
            }
        }
    }

    private static class PartitioningResult<T>
    implements StateSnapshot.StateKeyGroupWriter {
        @Nonnull
        private final ElementWriterFunction<T> elementWriterFunction;
        @Nonnull
        private final int[] keyGroupOffsets;
        @Nonnull
        private final T[] partitionedElements;
        @Nonnegative
        private final int firstKeyGroup;

        PartitioningResult(@Nonnull ElementWriterFunction<T> elementWriterFunction, @Nonnegative int firstKeyGroup, @Nonnull int[] keyGroupEndOffsets, @Nonnull T[] partitionedElements) {
            this.elementWriterFunction = elementWriterFunction;
            this.firstKeyGroup = firstKeyGroup;
            this.keyGroupOffsets = keyGroupEndOffsets;
            this.partitionedElements = partitionedElements;
        }

        @Nonnegative
        private int getKeyGroupStartOffsetInclusive(int keyGroup) {
            int idx = keyGroup - this.firstKeyGroup - 1;
            return idx < 0 ? 0 : this.keyGroupOffsets[idx];
        }

        @Nonnegative
        private int getKeyGroupEndOffsetExclusive(int keyGroup) {
            return this.keyGroupOffsets[keyGroup - this.firstKeyGroup];
        }

        @Override
        public void writeStateInKeyGroup(@Nonnull DataOutputView dov, int keyGroupId) throws IOException {
            int startOffset = this.getKeyGroupStartOffsetInclusive(keyGroupId);
            int endOffset = this.getKeyGroupEndOffsetExclusive(keyGroupId);
            dov.writeInt(endOffset - startOffset);
            for (int i = startOffset; i < endOffset; ++i) {
                this.elementWriterFunction.writeElement(this.partitionedElements[i], dov);
            }
        }
    }
}

