/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.List;
import java.util.Set;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.scheduler.DeploymentOption;
import org.apache.flink.runtime.scheduler.ExecutionVertexDeploymentOption;
import org.apache.flink.runtime.scheduler.SchedulerOperations;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategy;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategyFactory;
import org.apache.flink.runtime.scheduler.strategy.SchedulingStrategyUtils;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.util.Preconditions;

public class EagerSchedulingStrategy
implements SchedulingStrategy {
    private final SchedulerOperations schedulerOperations;
    private final SchedulingTopology schedulingTopology;
    private final DeploymentOption deploymentOption = new DeploymentOption(false);

    public EagerSchedulingStrategy(SchedulerOperations schedulerOperations, SchedulingTopology schedulingTopology) {
        this.schedulerOperations = (SchedulerOperations)Preconditions.checkNotNull((Object)schedulerOperations);
        this.schedulingTopology = (SchedulingTopology)Preconditions.checkNotNull((Object)schedulingTopology);
    }

    @Override
    public void startScheduling() {
        this.allocateSlotsAndDeploy(SchedulingStrategyUtils.getAllVertexIdsFromTopology(this.schedulingTopology));
    }

    @Override
    public void restartTasks(Set<ExecutionVertexID> verticesToRestart) {
        this.allocateSlotsAndDeploy(verticesToRestart);
    }

    @Override
    public void onExecutionStateChange(ExecutionVertexID executionVertexId, ExecutionState executionState) {
    }

    @Override
    public void onPartitionConsumable(IntermediateResultPartitionID resultPartitionId) {
    }

    private void allocateSlotsAndDeploy(Set<ExecutionVertexID> verticesToDeploy) {
        List<ExecutionVertexDeploymentOption> executionVertexDeploymentOptions = SchedulingStrategyUtils.createExecutionVertexDeploymentOptionsInTopologicalOrder(this.schedulingTopology, verticesToDeploy, id -> this.deploymentOption);
        this.schedulerOperations.allocateSlotsAndDeploy(executionVertexDeploymentOptions);
    }

    public static class Factory
    implements SchedulingStrategyFactory {
        @Override
        public SchedulingStrategy createInstance(SchedulerOperations schedulerOperations, SchedulingTopology schedulingTopology) {
            return new EagerSchedulingStrategy(schedulerOperations, schedulingTopology);
        }
    }
}

