/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.legacy.backpressure;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.flink.util.Preconditions;

public class OperatorBackPressureStats
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int requestId;
    private final long endTimestamp;
    private final double[] subTaskBackPressureRatios;
    private final double maxSubTaskBackPressureRatio;

    public OperatorBackPressureStats(int requestId, long endTimestamp, double[] subTaskBackPressureRatios) {
        this.requestId = requestId;
        this.endTimestamp = endTimestamp;
        this.subTaskBackPressureRatios = (double[])Preconditions.checkNotNull((Object)subTaskBackPressureRatios);
        Preconditions.checkArgument((subTaskBackPressureRatios.length >= 1 ? 1 : 0) != 0, (Object)"No Sub task back pressure ratio specified.");
        double max = 0.0;
        for (double ratio : subTaskBackPressureRatios) {
            if (!(ratio > max)) continue;
            max = ratio;
        }
        this.maxSubTaskBackPressureRatio = max;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public int getNumberOfSubTasks() {
        return this.subTaskBackPressureRatios.length;
    }

    public double getBackPressureRatio(int index) {
        return this.subTaskBackPressureRatios[index];
    }

    public double getMaxBackPressureRatio() {
        return this.maxSubTaskBackPressureRatio;
    }

    public String toString() {
        return "OperatorBackPressureStats{requestId=" + this.requestId + ", endTimestamp=" + this.endTimestamp + ", subTaskBackPressureRatios=" + Arrays.toString(this.subTaskBackPressureRatios) + '}';
    }
}

