/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.job;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionGraph;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.handler.RestHandlerException;
import org.apache.flink.runtime.rest.handler.job.AbstractSubtaskAttemptHandler;
import org.apache.flink.runtime.rest.handler.legacy.ExecutionGraphCache;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.job.SubtaskAttemptMessageParameters;
import org.apache.flink.runtime.rest.messages.job.SubtaskExecutionAttemptAccumulatorsInfo;
import org.apache.flink.runtime.rest.messages.job.UserAccumulator;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.runtime.webmonitor.history.ArchivedJson;
import org.apache.flink.runtime.webmonitor.history.JsonArchivist;
import org.apache.flink.runtime.webmonitor.retriever.GatewayRetriever;

public class SubtaskExecutionAttemptAccumulatorsHandler
extends AbstractSubtaskAttemptHandler<SubtaskExecutionAttemptAccumulatorsInfo, SubtaskAttemptMessageParameters>
implements JsonArchivist {
    public SubtaskExecutionAttemptAccumulatorsHandler(GatewayRetriever<? extends RestfulGateway> leaderRetriever, Time timeout, Map<String, String> responseHeaders, MessageHeaders<EmptyRequestBody, SubtaskExecutionAttemptAccumulatorsInfo, SubtaskAttemptMessageParameters> messageHeaders, ExecutionGraphCache executionGraphCache, Executor executor) {
        super(leaderRetriever, timeout, responseHeaders, messageHeaders, executionGraphCache, executor);
    }

    @Override
    protected SubtaskExecutionAttemptAccumulatorsInfo handleRequest(HandlerRequest<EmptyRequestBody, SubtaskAttemptMessageParameters> request, AccessExecution execution) throws RestHandlerException {
        return SubtaskExecutionAttemptAccumulatorsHandler.createAccumulatorInfo(execution);
    }

    @Override
    public Collection<ArchivedJson> archiveJsonWithPath(AccessExecutionGraph graph) throws IOException {
        ArrayList<ArchivedJson> archive = new ArrayList<ArchivedJson>(16);
        for (AccessExecutionJobVertex accessExecutionJobVertex : graph.getAllVertices().values()) {
            for (AccessExecutionVertex subtask : accessExecutionJobVertex.getTaskVertices()) {
                SubtaskExecutionAttemptAccumulatorsInfo curAttemptJson = SubtaskExecutionAttemptAccumulatorsHandler.createAccumulatorInfo(subtask.getCurrentExecutionAttempt());
                String curAttemptPath = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString()).replace(":subtaskindex", String.valueOf(subtask.getParallelSubtaskIndex())).replace(":attempt", String.valueOf(subtask.getCurrentExecutionAttempt().getAttemptNumber()));
                archive.add(new ArchivedJson(curAttemptPath, curAttemptJson));
                for (int x = 0; x < subtask.getCurrentExecutionAttempt().getAttemptNumber(); ++x) {
                    AccessExecution attempt = subtask.getPriorExecutionAttempt(x);
                    if (attempt == null) continue;
                    SubtaskExecutionAttemptAccumulatorsInfo json = SubtaskExecutionAttemptAccumulatorsHandler.createAccumulatorInfo(attempt);
                    String path = this.getMessageHeaders().getTargetRestEndpointURL().replace(":jobid", graph.getJobID().toString()).replace(":vertexid", accessExecutionJobVertex.getJobVertexId().toString()).replace(":subtaskindex", String.valueOf(subtask.getParallelSubtaskIndex())).replace(":attempt", String.valueOf(attempt.getAttemptNumber()));
                    archive.add(new ArchivedJson(path, json));
                }
            }
        }
        return archive;
    }

    private static SubtaskExecutionAttemptAccumulatorsInfo createAccumulatorInfo(AccessExecution execution) {
        StringifiedAccumulatorResult[] accs = execution.getUserAccumulatorsStringified();
        ArrayList<UserAccumulator> userAccumulatorList = new ArrayList<UserAccumulator>(accs.length);
        for (StringifiedAccumulatorResult acc : accs) {
            userAccumulatorList.add(new UserAccumulator(acc.getName(), acc.getType(), acc.getValue()));
        }
        return new SubtaskExecutionAttemptAccumulatorsInfo(execution.getParallelSubtaskIndex(), execution.getAttemptNumber(), execution.getAttemptId().toString(), userAccumulatorList);
    }
}

