/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.ConnectionManager;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.runtime.io.network.metrics.InputChannelMetrics;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.LocalInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.util.Preconditions;

class UnknownInputChannel
extends InputChannel {
    private final ResultPartitionManager partitionManager;
    private final TaskEventPublisher taskEventPublisher;
    private final ConnectionManager connectionManager;
    private final int initialBackoff;
    private final int maxBackoff;
    private final InputChannelMetrics metrics;

    public UnknownInputChannel(SingleInputGate gate, int channelIndex, ResultPartitionID partitionId, ResultPartitionManager partitionManager, TaskEventPublisher taskEventPublisher, ConnectionManager connectionManager, int initialBackoff, int maxBackoff, InputChannelMetrics metrics) {
        super(gate, channelIndex, partitionId, initialBackoff, maxBackoff, null, null);
        this.partitionManager = (ResultPartitionManager)Preconditions.checkNotNull((Object)partitionManager);
        this.taskEventPublisher = (TaskEventPublisher)Preconditions.checkNotNull((Object)taskEventPublisher);
        this.connectionManager = (ConnectionManager)Preconditions.checkNotNull((Object)connectionManager);
        this.metrics = (InputChannelMetrics)Preconditions.checkNotNull((Object)metrics);
        this.initialBackoff = initialBackoff;
        this.maxBackoff = maxBackoff;
    }

    @Override
    public void resumeConsumption() {
        throw new UnsupportedOperationException("UnknownInputChannel should never be blocked.");
    }

    @Override
    public void requestSubpartition(int subpartitionIndex) throws IOException {
    }

    @Override
    public Optional<InputChannel.BufferAndAvailability> getNextBuffer() throws IOException {
        throw new UnsupportedOperationException("Cannot retrieve a buffer from an UnknownInputChannel");
    }

    @Override
    public void sendTaskEvent(TaskEvent event) throws IOException {
    }

    @Override
    public boolean isReleased() {
        return false;
    }

    @Override
    public void releaseAllResources() throws IOException {
    }

    public String toString() {
        return "UnknownInputChannel [" + this.partitionId + "]";
    }

    public RemoteInputChannel toRemoteInputChannel(ConnectionID producerAddress) {
        return new RemoteInputChannel(this.inputGate, this.getChannelIndex(), this.partitionId, (ConnectionID)Preconditions.checkNotNull((Object)producerAddress), this.connectionManager, this.initialBackoff, this.maxBackoff, this.metrics.getNumBytesInRemoteCounter(), this.metrics.getNumBuffersInRemoteCounter());
    }

    public LocalInputChannel toLocalInputChannel() {
        return new LocalInputChannel(this.inputGate, this.getChannelIndex(), this.partitionId, this.partitionManager, this.taskEventPublisher, this.initialBackoff, this.maxBackoff, this.metrics.getNumBytesInRemoteCounter(), this.metrics.getNumBuffersInRemoteCounter());
    }
}

