/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

public enum ResultPartitionType {
    BLOCKING(false, false, false, false),
    BLOCKING_PERSISTENT(false, false, false, true),
    PIPELINED(true, true, false, false),
    PIPELINED_BOUNDED(true, true, true, false);

    private final boolean isPipelined;
    private final boolean hasBackPressure;
    private final boolean isBounded;
    private final boolean isPersistent;

    private ResultPartitionType(boolean isPipelined, boolean hasBackPressure, boolean isBounded, boolean isPersistent) {
        this.isPipelined = isPipelined;
        this.hasBackPressure = hasBackPressure;
        this.isBounded = isBounded;
        this.isPersistent = isPersistent;
    }

    public boolean hasBackPressure() {
        return this.hasBackPressure;
    }

    public boolean isBlocking() {
        return !this.isPipelined;
    }

    public boolean isPipelined() {
        return this.isPipelined;
    }

    public boolean isBounded() {
        return this.isBounded;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }
}

