/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.Closeable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.util.Preconditions;

@NotThreadSafe
public class BufferConsumer
implements Closeable {
    private final Buffer buffer;
    private final CachedPositionMarker writerPosition;
    private int currentReaderPosition;

    public BufferConsumer(MemorySegment memorySegment, BufferRecycler recycler, BufferBuilder.PositionMarker currentWriterPosition, int currentReaderPosition) {
        this(new NetworkBuffer((MemorySegment)Preconditions.checkNotNull((Object)memorySegment), (BufferRecycler)Preconditions.checkNotNull((Object)recycler)), currentWriterPosition, currentReaderPosition);
    }

    public BufferConsumer(MemorySegment memorySegment, BufferRecycler recycler, Buffer.DataType dataType) {
        this(memorySegment, recycler, memorySegment.size(), dataType);
    }

    public BufferConsumer(MemorySegment memorySegment, BufferRecycler recycler, int size, Buffer.DataType dataType) {
        this(new NetworkBuffer((MemorySegment)Preconditions.checkNotNull((Object)memorySegment), (BufferRecycler)Preconditions.checkNotNull((Object)recycler), dataType), () -> -size, 0);
        Preconditions.checkState((memorySegment.size() > 0 ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.isFinished(), (Object)"BufferConsumer with static size must be finished after construction!");
    }

    private BufferConsumer(Buffer buffer, BufferBuilder.PositionMarker currentWriterPosition, int currentReaderPosition) {
        this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer);
        this.writerPosition = new CachedPositionMarker((BufferBuilder.PositionMarker)Preconditions.checkNotNull((Object)currentWriterPosition));
        Preconditions.checkArgument((currentReaderPosition <= this.writerPosition.getCached() ? 1 : 0) != 0, (Object)"Reader position larger than writer position");
        this.currentReaderPosition = currentReaderPosition;
    }

    public boolean isFinished() {
        return this.writerPosition.isFinished();
    }

    public Buffer build() {
        this.writerPosition.update();
        int cachedWriterPosition = this.writerPosition.getCached();
        Buffer slice = this.buffer.readOnlySlice(this.currentReaderPosition, cachedWriterPosition - this.currentReaderPosition);
        this.currentReaderPosition = cachedWriterPosition;
        return slice.retainBuffer();
    }

    public BufferConsumer copy() {
        return new BufferConsumer(this.buffer.retainBuffer(), this.writerPosition.positionMarker, this.currentReaderPosition);
    }

    public BufferConsumer copyWithReaderPosition(int readerPosition) {
        return new BufferConsumer(this.buffer.retainBuffer(), this.writerPosition.positionMarker, readerPosition);
    }

    public boolean isBuffer() {
        return this.buffer.isBuffer();
    }

    @Override
    public void close() {
        if (!this.buffer.isRecycled()) {
            this.buffer.recycleBuffer();
        }
    }

    public boolean isRecycled() {
        return this.buffer.isRecycled();
    }

    public int getWrittenBytes() {
        return this.writerPosition.getCached();
    }

    int getCurrentReaderPosition() {
        return this.currentReaderPosition;
    }

    public boolean isDataAvailable() {
        return this.currentReaderPosition < this.writerPosition.getLatest();
    }

    private static class CachedPositionMarker {
        private final BufferBuilder.PositionMarker positionMarker;
        private int cachedPosition;

        CachedPositionMarker(BufferBuilder.PositionMarker positionMarker) {
            this.positionMarker = (BufferBuilder.PositionMarker)Preconditions.checkNotNull((Object)positionMarker);
            this.update();
        }

        public boolean isFinished() {
            return BufferBuilder.PositionMarker.isFinished(this.cachedPosition);
        }

        public int getCached() {
            return BufferBuilder.PositionMarker.getAbsolute(this.cachedPosition);
        }

        private int getLatest() {
            return BufferBuilder.PositionMarker.getAbsolute(this.positionMarker.get());
        }

        private void update() {
            this.cachedPosition = this.positionMarker.get();
        }
    }
}

