/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.Archiveable;
import org.apache.flink.api.common.InputDependencyConstraint;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.AccumulatorHelper;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.core.io.InputSplitSource;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.OperatorIDPair;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.GlobalModVersionMismatch;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.jobgraph.IntermediateDataSet;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobEdge;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinatorHolder;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.types.Either;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;

public class ExecutionJobVertex
implements AccessExecutionJobVertex,
Archiveable<ArchivedExecutionJobVertex> {
    private static final Logger LOG = ExecutionGraph.LOG;
    public static final int VALUE_NOT_SET = -1;
    private final Object stateMonitor;
    private final ExecutionGraph graph;
    private final JobVertex jobVertex;
    private final ExecutionVertex[] taskVertices;
    private final IntermediateResult[] producedDataSets;
    private final List<IntermediateResult> inputs;
    private final int parallelism;
    private final SlotSharingGroup slotSharingGroup;
    private final CoLocationGroup coLocationGroup;
    private final InputSplit[] inputSplits;
    private final boolean maxParallelismConfigured;
    private int maxParallelism;
    private final ResourceProfile resourceProfile;
    private Either<SerializedValue<TaskInformation>, PermanentBlobKey> taskInformationOrBlobKey;
    private final Collection<OperatorCoordinatorHolder> operatorCoordinators;
    private InputSplitAssigner splitAssigner;

    @VisibleForTesting
    ExecutionJobVertex(ExecutionGraph graph, JobVertex jobVertex, int defaultParallelism, Time timeout) throws JobException {
        this(graph, jobVertex, defaultParallelism, (Integer)JobManagerOptions.MAX_ATTEMPTS_HISTORY_SIZE.defaultValue(), timeout, 1L, System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionJobVertex(ExecutionGraph graph, JobVertex jobVertex, int defaultParallelism, int maxPriorAttemptsHistoryLength, Time timeout, long initialGlobalModVersion, long createTimestamp) throws JobException {
        block18: {
            int i;
            this.stateMonitor = new Object();
            this.taskInformationOrBlobKey = null;
            if (graph == null || jobVertex == null) {
                throw new NullPointerException();
            }
            this.graph = graph;
            this.jobVertex = jobVertex;
            int vertexParallelism = jobVertex.getParallelism();
            int numTaskVertices = vertexParallelism > 0 ? vertexParallelism : defaultParallelism;
            int configuredMaxParallelism = jobVertex.getMaxParallelism();
            this.maxParallelismConfigured = -1 != configuredMaxParallelism;
            this.setMaxParallelismInternal(this.maxParallelismConfigured ? configuredMaxParallelism : KeyGroupRangeAssignment.computeDefaultMaxParallelism(numTaskVertices));
            if (numTaskVertices > this.maxParallelism) {
                throw new JobException(String.format("Vertex %s's parallelism (%s) is higher than the max parallelism (%s). Please lower the parallelism or increase the max parallelism.", jobVertex.getName(), numTaskVertices, this.maxParallelism));
            }
            this.parallelism = numTaskVertices;
            this.resourceProfile = ResourceProfile.fromResourceSpec(jobVertex.getMinResources(), MemorySize.ZERO);
            this.taskVertices = new ExecutionVertex[numTaskVertices];
            this.inputs = new ArrayList<IntermediateResult>(jobVertex.getInputs().size());
            this.slotSharingGroup = jobVertex.getSlotSharingGroup();
            this.coLocationGroup = jobVertex.getCoLocationGroup();
            if (this.coLocationGroup != null && this.slotSharingGroup == null) {
                throw new JobException("Vertex uses a co-location constraint without using slot sharing");
            }
            this.producedDataSets = new IntermediateResult[jobVertex.getNumberOfProducedIntermediateDataSets()];
            for (i = 0; i < jobVertex.getProducedDataSets().size(); ++i) {
                IntermediateDataSet result = jobVertex.getProducedDataSets().get(i);
                this.producedDataSets[i] = new IntermediateResult(result.getId(), this, numTaskVertices, result.getResultType());
            }
            for (i = 0; i < numTaskVertices; ++i) {
                ExecutionVertex vertex;
                this.taskVertices[i] = vertex = new ExecutionVertex(this, i, this.producedDataSets, timeout, initialGlobalModVersion, createTimestamp, maxPriorAttemptsHistoryLength);
            }
            for (IntermediateResult ir : this.producedDataSets) {
                if (ir.getNumberOfAssignedPartitions() == this.parallelism) continue;
                throw new RuntimeException("The intermediate result's partitions were not correctly assigned.");
            }
            List<SerializedValue<OperatorCoordinator.Provider>> coordinatorProviders = this.getJobVertex().getOperatorCoordinators();
            if (coordinatorProviders.isEmpty()) {
                this.operatorCoordinators = Collections.emptyList();
            } else {
                ArrayList<OperatorCoordinatorHolder> coordinators = new ArrayList<OperatorCoordinatorHolder>(coordinatorProviders.size());
                try {
                    for (SerializedValue<OperatorCoordinator.Provider> provider : coordinatorProviders) {
                        coordinators.add(OperatorCoordinatorHolder.create(provider, this, graph.getUserClassLoader()));
                    }
                }
                catch (Exception | LinkageError e) {
                    IOUtils.closeAllQuietly(coordinators);
                    throw new JobException("Cannot instantiate the coordinator for operator " + this.getName(), e);
                }
                this.operatorCoordinators = Collections.unmodifiableList(coordinators);
            }
            try {
                InputSplitSource<?> splitSource = jobVertex.getInputSplitSource();
                if (splitSource != null) {
                    Thread currentThread = Thread.currentThread();
                    ClassLoader oldContextClassLoader = currentThread.getContextClassLoader();
                    currentThread.setContextClassLoader(graph.getUserClassLoader());
                    try {
                        this.inputSplits = splitSource.createInputSplits(numTaskVertices);
                        if (this.inputSplits != null) {
                            this.splitAssigner = splitSource.getInputSplitAssigner(this.inputSplits);
                        }
                        break block18;
                    }
                    finally {
                        currentThread.setContextClassLoader(oldContextClassLoader);
                    }
                }
                this.inputSplits = null;
            }
            catch (Throwable t) {
                throw new JobException("Creating the input splits caused an error: " + t.getMessage(), t);
            }
        }
    }

    public List<OperatorIDPair> getOperatorIDs() {
        return this.jobVertex.getOperatorIDs();
    }

    public void setMaxParallelism(int maxParallelismDerived) {
        Preconditions.checkState((!this.maxParallelismConfigured ? 1 : 0) != 0, (Object)("Attempt to override a configured max parallelism. Configured: " + this.maxParallelism + ", argument: " + maxParallelismDerived));
        this.setMaxParallelismInternal(maxParallelismDerived);
    }

    private void setMaxParallelismInternal(int maxParallelism) {
        if (maxParallelism == Integer.MAX_VALUE) {
            maxParallelism = 32768;
        }
        Preconditions.checkArgument((maxParallelism > 0 && maxParallelism <= 32768 ? 1 : 0) != 0, (String)"Overriding max parallelism is not in valid bounds (1..%s), found: %s", (Object[])new Object[]{32768, maxParallelism});
        this.maxParallelism = maxParallelism;
    }

    public ExecutionGraph getGraph() {
        return this.graph;
    }

    public JobVertex getJobVertex() {
        return this.jobVertex;
    }

    @Override
    public String getName() {
        return this.getJobVertex().getName();
    }

    @Override
    public int getParallelism() {
        return this.parallelism;
    }

    @Override
    public int getMaxParallelism() {
        return this.maxParallelism;
    }

    @Override
    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public boolean isMaxParallelismConfigured() {
        return this.maxParallelismConfigured;
    }

    public JobID getJobId() {
        return this.graph.getJobID();
    }

    @Override
    public JobVertexID getJobVertexId() {
        return this.jobVertex.getID();
    }

    public ExecutionVertex[] getTaskVertices() {
        return this.taskVertices;
    }

    public IntermediateResult[] getProducedDataSets() {
        return this.producedDataSets;
    }

    public InputSplitAssigner getSplitAssigner() {
        return this.splitAssigner;
    }

    @Nullable
    public SlotSharingGroup getSlotSharingGroup() {
        return this.slotSharingGroup;
    }

    public CoLocationGroup getCoLocationGroup() {
        return this.coLocationGroup;
    }

    public List<IntermediateResult> getInputs() {
        return this.inputs;
    }

    public InputDependencyConstraint getInputDependencyConstraint() {
        return this.getJobVertex().getInputDependencyConstraint();
    }

    public Collection<OperatorCoordinatorHolder> getOperatorCoordinators() {
        return this.operatorCoordinators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Either<SerializedValue<TaskInformation>, PermanentBlobKey> getTaskInformationOrBlobKey() throws IOException {
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.taskInformationOrBlobKey == null) {
                BlobWriter blobWriter = this.graph.getBlobWriter();
                TaskInformation taskInformation = new TaskInformation(this.jobVertex.getID(), this.jobVertex.getName(), this.parallelism, this.maxParallelism, this.jobVertex.getInvokableClassName(), this.jobVertex.getConfiguration());
                this.taskInformationOrBlobKey = BlobWriter.serializeAndTryOffload(taskInformation, this.getJobId(), blobWriter);
            }
            return this.taskInformationOrBlobKey;
        }
    }

    @Override
    public ExecutionState getAggregateState() {
        int[] num = new int[ExecutionState.values().length];
        for (ExecutionVertex vertex : this.taskVertices) {
            int n = vertex.getExecutionState().ordinal();
            num[n] = num[n] + 1;
        }
        return ExecutionJobVertex.getAggregateJobVertexState(num, this.parallelism);
    }

    public void connectToPredecessors(Map<IntermediateDataSetID, IntermediateResult> intermediateDataSets) throws JobException {
        List<JobEdge> inputs = this.jobVertex.getInputs();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Connecting ExecutionJobVertex %s (%s) to %d predecessors.", this.jobVertex.getID(), this.jobVertex.getName(), inputs.size()));
        }
        for (int num = 0; num < inputs.size(); ++num) {
            IntermediateResult ires;
            JobEdge edge = inputs.get(num);
            if (LOG.isDebugEnabled()) {
                if (edge.getSource() == null) {
                    LOG.debug(String.format("Connecting input %d of vertex %s (%s) to intermediate result referenced via ID %s.", num, this.jobVertex.getID(), this.jobVertex.getName(), edge.getSourceId()));
                } else {
                    LOG.debug(String.format("Connecting input %d of vertex %s (%s) to intermediate result referenced via predecessor %s (%s).", num, this.jobVertex.getID(), this.jobVertex.getName(), edge.getSource().getProducer().getID(), edge.getSource().getProducer().getName()));
                }
            }
            if ((ires = intermediateDataSets.get(edge.getSourceId())) == null) {
                throw new JobException("Cannot connect this job graph to the previous graph. No previous intermediate result found for ID " + edge.getSourceId());
            }
            this.inputs.add(ires);
            int consumerIndex = ires.registerConsumer();
            for (int i = 0; i < this.parallelism; ++i) {
                ExecutionVertex ev = this.taskVertices[i];
                ev.connectSource(num, ires, edge, consumerIndex);
            }
        }
    }

    public void cancel() {
        for (ExecutionVertex ev : this.getTaskVertices()) {
            ev.cancel();
        }
    }

    public CompletableFuture<Void> cancelWithFuture() {
        return FutureUtils.waitForAll(this.mapExecutionVertices(ExecutionVertex::cancel));
    }

    public CompletableFuture<Void> suspend() {
        return FutureUtils.waitForAll(this.mapExecutionVertices(ExecutionVertex::suspend));
    }

    @Nonnull
    private Collection<CompletableFuture<?>> mapExecutionVertices(Function<ExecutionVertex, CompletableFuture<?>> mapFunction) {
        return Arrays.stream(this.getTaskVertices()).map(mapFunction).collect(Collectors.toList());
    }

    public void fail(Throwable t) {
        for (ExecutionVertex ev : this.getTaskVertices()) {
            ev.fail(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetForNewExecution(long timestamp, long expectedGlobalModVersion) throws GlobalModVersionMismatch {
        Object object = this.stateMonitor;
        synchronized (object) {
            for (int i = 0; i < this.parallelism; ++i) {
                this.taskVertices[i].resetForNewExecution(timestamp, expectedGlobalModVersion);
            }
            try {
                if (this.inputSplits != null) {
                    InputSplitSource<?> splitSource = this.jobVertex.getInputSplitSource();
                    this.splitAssigner = splitSource.getInputSplitAssigner(this.inputSplits);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Re-creating the input split assigner failed: " + t.getMessage(), t);
            }
        }
    }

    @Override
    public StringifiedAccumulatorResult[] getAggregatedUserAccumulatorsStringified() {
        HashMap userAccumulators = new HashMap();
        for (ExecutionVertex vertex : this.taskVertices) {
            Map<String, Accumulator<?, ?>> next = vertex.getCurrentExecutionAttempt().getUserAccumulators();
            if (next == null) continue;
            AccumulatorHelper.mergeInto(userAccumulators, next);
        }
        return StringifiedAccumulatorResult.stringifyAccumulatorResults(userAccumulators);
    }

    public ArchivedExecutionJobVertex archive() {
        return new ArchivedExecutionJobVertex(this);
    }

    public static ExecutionState getAggregateJobVertexState(int[] verticesPerState, int parallelism) {
        if (verticesPerState == null || verticesPerState.length != ExecutionState.values().length) {
            throw new IllegalArgumentException("Must provide an array as large as there are execution states.");
        }
        if (verticesPerState[ExecutionState.FAILED.ordinal()] > 0) {
            return ExecutionState.FAILED;
        }
        if (verticesPerState[ExecutionState.CANCELING.ordinal()] > 0) {
            return ExecutionState.CANCELING;
        }
        if (verticesPerState[ExecutionState.CANCELED.ordinal()] > 0) {
            return ExecutionState.CANCELED;
        }
        if (verticesPerState[ExecutionState.RUNNING.ordinal()] > 0) {
            return ExecutionState.RUNNING;
        }
        if (verticesPerState[ExecutionState.FINISHED.ordinal()] > 0) {
            return verticesPerState[ExecutionState.FINISHED.ordinal()] == parallelism ? ExecutionState.FINISHED : ExecutionState.RUNNING;
        }
        return ExecutionState.CREATED;
    }
}

