/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.util.Preconditions;

@Internal
@NotThreadSafe
interface ChannelStateByteBuffer {
    public boolean isWritable();

    public int writeBytes(InputStream var1, int var2) throws IOException;

    public static ChannelStateByteBuffer wrap(final Buffer buffer) {
        return new ChannelStateByteBuffer(){
            private final ByteBuf byteBuf;
            {
                this.byteBuf = buffer.asByteBuf();
            }

            @Override
            public boolean isWritable() {
                return this.byteBuf.isWritable();
            }

            @Override
            public int writeBytes(InputStream input, int bytesToRead) throws IOException {
                return this.byteBuf.writeBytes(input, Math.min(bytesToRead, this.byteBuf.writableBytes()));
            }
        };
    }

    public static ChannelStateByteBuffer wrap(final BufferBuilder bufferBuilder) {
        final byte[] buf = new byte[1024];
        return new ChannelStateByteBuffer(){

            @Override
            public boolean isWritable() {
                return !bufferBuilder.isFull();
            }

            @Override
            public int writeBytes(InputStream input, int bytesToRead) throws IOException {
                int left = bytesToRead;
                int toRead = this.getToRead(left);
                while (toRead > 0) {
                    int read = input.read(buf, 0, toRead);
                    int copied = bufferBuilder.append(ByteBuffer.wrap(buf, 0, read));
                    Preconditions.checkState((copied == read ? 1 : 0) != 0);
                    toRead = this.getToRead(left -= read);
                }
                bufferBuilder.commit();
                return bytesToRead - left;
            }

            private int getToRead(int bytesToRead) {
                return Math.min(bytesToRead, Math.min(buf.length, bufferBuilder.getWritableBytes()));
            }
        };
    }

    public static ChannelStateByteBuffer wrap(final byte[] bytes) {
        return new ChannelStateByteBuffer(){
            private int written = 0;

            @Override
            public boolean isWritable() {
                return this.written < bytes.length;
            }

            @Override
            public int writeBytes(InputStream input, int bytesToRead) throws IOException {
                int bytesRead = input.read(bytes, this.written, bytes.length - this.written);
                this.written += bytesRead;
                return bytesRead;
            }
        };
    }
}

