/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.util.Preconditions;

public class CheckpointMetrics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long alignmentDurationNanos;
    private long syncDurationMillis;
    private long asyncDurationMillis;
    private long checkpointStartDelayNanos;

    public CheckpointMetrics() {
        this(-1L, -1L, -1L, -1L);
    }

    public CheckpointMetrics(long bytesBufferedInAlignment, long alignmentDurationNanos, long syncDurationMillis, long asyncDurationMillis) {
        Preconditions.checkArgument((syncDurationMillis >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((asyncDurationMillis >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((bytesBufferedInAlignment >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((alignmentDurationNanos >= -1L ? 1 : 0) != 0);
        this.alignmentDurationNanos = alignmentDurationNanos;
        this.syncDurationMillis = syncDurationMillis;
        this.asyncDurationMillis = asyncDurationMillis;
    }

    public long getAlignmentDurationNanos() {
        return this.alignmentDurationNanos;
    }

    public CheckpointMetrics setAlignmentDurationNanos(long alignmentDurationNanos) {
        this.alignmentDurationNanos = alignmentDurationNanos;
        return this;
    }

    public long getSyncDurationMillis() {
        return this.syncDurationMillis;
    }

    public CheckpointMetrics setSyncDurationMillis(long syncDurationMillis) {
        this.syncDurationMillis = syncDurationMillis;
        return this;
    }

    public long getAsyncDurationMillis() {
        return this.asyncDurationMillis;
    }

    public CheckpointMetrics setAsyncDurationMillis(long asyncDurationMillis) {
        this.asyncDurationMillis = asyncDurationMillis;
        return this;
    }

    public CheckpointMetrics setCheckpointStartDelayNanos(long checkpointStartDelayNanos) {
        this.checkpointStartDelayNanos = checkpointStartDelayNanos;
        return this;
    }

    public long getCheckpointStartDelayNanos() {
        return this.checkpointStartDelayNanos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointMetrics that = (CheckpointMetrics)o;
        return this.alignmentDurationNanos == that.alignmentDurationNanos && this.syncDurationMillis == that.syncDurationMillis && this.asyncDurationMillis == that.asyncDurationMillis && this.checkpointStartDelayNanos == that.checkpointStartDelayNanos;
    }

    public int hashCode() {
        return Objects.hash(this.alignmentDurationNanos, this.syncDurationMillis, this.asyncDurationMillis, this.checkpointStartDelayNanos);
    }

    public String toString() {
        return "CheckpointMetrics{, alignmentDurationNanos=" + this.alignmentDurationNanos + ", syncDurationMillis=" + this.syncDurationMillis + ", asyncDurationMillis=" + this.asyncDurationMillis + ", checkpointStartDelayNanos=" + this.checkpointStartDelayNanos + '}';
    }
}

