/*
 * Decompiled with CFR 0.152.
 */
package akka.remote;

import akka.event.EventStream;
import akka.event.Logging;
import akka.event.SubchannelClassification;
import akka.remote.FailureDetector;
import akka.remote.FailureDetector$;
import akka.remote.HeartbeatHistory;
import akka.remote.HeartbeatHistory$;
import akka.remote.PhiAccrualFailureDetector$State$;
import akka.util.Helpers;
import akka.util.Helpers$;
import com.typesafe.config.Config;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t-e\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0004\u00155j\u0003\u000e\u001c'/^1m\r\u0006LG.\u001e:f\t\u0016$Xm\u0019;pe*\u00111\u0001B\u0001\u0007e\u0016lw\u000e^3\u000b\u0003\u0015\tA!Y6lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003\u001f\u0019\u000b\u0017\u000e\\;sK\u0012+G/Z2u_JD\u0001b\u0005\u0001\u0003\u0006\u0004%\t\u0001F\u0001\ni\"\u0014Xm\u001d5pY\u0012,\u0012!\u0006\t\u0003\u0013YI!a\u0006\u0006\u0003\r\u0011{WO\u00197f\u0011!I\u0002A!A!\u0002\u0013)\u0012A\u0003;ie\u0016\u001c\bn\u001c7eA!A1\u0004\u0001BC\u0002\u0013\u0005A$A\u0007nCb\u001c\u0016-\u001c9mKNK'0Z\u000b\u0002;A\u0011\u0011BH\u0005\u0003?)\u00111!\u00138u\u0011!\t\u0003A!A!\u0002\u0013i\u0012AD7bqN\u000bW\u000e\u001d7f'&TX\r\t\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005yQ.\u001b8Ti\u0012$UM^5bi&|g.F\u0001&!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0005ekJ\fG/[8o\u0015\tQ#\"\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001L\u0014\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"Aa\u0006\u0001B\u0001B\u0003%Q%\u0001\tnS:\u001cF\u000f\u001a#fm&\fG/[8oA!A\u0001\u0007\u0001BC\u0002\u0013\u0005A%\u0001\rbG\u000e,\u0007\u000f^1cY\u0016DU-\u0019:uE\u0016\fG\u000fU1vg\u0016D\u0001B\r\u0001\u0003\u0002\u0003\u0006I!J\u0001\u001aC\u000e\u001cW\r\u001d;bE2,\u0007*Z1si\n,\u0017\r\u001e)bkN,\u0007\u0005\u0003\u00055\u0001\t\u0015\r\u0011\"\u0001%\u0003Y1\u0017N]:u\u0011\u0016\f'\u000f\u001e2fCR,5\u000f^5nCR,\u0007\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002/\u0019L'o\u001d;IK\u0006\u0014HOY3bi\u0016\u001bH/[7bi\u0016\u0004\u0003\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u0017\u00154XM\u001c;TiJ,\u0017-\u001c\t\u0004\u0013ib\u0014BA\u001e\u000b\u0005\u0019y\u0005\u000f^5p]B\u0011Q\bQ\u0007\u0002})\u0011q\bB\u0001\u0006KZ,g\u000e^\u0005\u0003\u0003z\u00121\"\u0012<f]R\u001cFO]3b[\"A1\t\u0001B\u0001B\u0003-A)A\u0003dY>\u001c7\u000e\u0005\u0002F\u001f:\u0011a)\u0014\b\u0003\u000f2s!\u0001S&\u000e\u0003%S!A\u0013\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0011BA\u0002\u0005\u0013\tq%!A\bGC&dWO]3EKR,7\r^8s\u0013\t\u0001\u0016KA\u0003DY>\u001c7N\u0003\u0002O\u0005!)1\u000b\u0001C\u0001)\u00061A(\u001b8jiz\"r!\u0016-Z5ncV\f\u0006\u0002W/B\u0011q\u0002\u0001\u0005\u0006\u0007J\u0003\u001d\u0001\u0012\u0005\u0006'I\u0003\r!\u0006\u0005\u00067I\u0003\r!\b\u0005\u0006GI\u0003\r!\n\u0005\u0006aI\u0003\r!\n\u0005\u0006iI\u0003\r!\n\u0005\u0006qI\u0003\r!\u000f\u0005\u0006'\u0002!\ta\u0018\u000b\u0007A\n\u001cG-\u001a4\u0015\u0005Y\u000b\u0007\"B\"_\u0001\b!\u0005\"B\n_\u0001\u0004)\u0002\"B\u000e_\u0001\u0004i\u0002\"B\u0012_\u0001\u0004)\u0003\"\u0002\u0019_\u0001\u0004)\u0003\"\u0002\u001b_\u0001\u0004)\u0003\"B*\u0001\t\u0003AGc\u0001,ji\")!n\u001aa\u0001W\u000611m\u001c8gS\u001e\u0004\"\u0001\u001c:\u000e\u00035T!A\u001b8\u000b\u0005=\u0004\u0018\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003E\f1aY8n\u0013\t\u0019XN\u0001\u0004D_:4\u0017n\u001a\u0005\u0006k\u001e\u0004\r\u0001P\u0001\u0003KZDqa\u001e\u0001C\u0002\u0013%\u00010\u0001\bgSJ\u001cH\u000fS3beR\u0014W-\u0019;\u0016\u0003e\u0004\"a\u0004>\n\u0005m\u0014!\u0001\u0005%fCJ$(-Z1u\u0011&\u001cHo\u001c:z\u0011\u0019i\b\u0001)A\u0005s\u0006ya-\u001b:ti\"+\u0017M\u001d;cK\u0006$\b\u0005\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0003y\t7mY3qi\u0006\u0014G.\u001a%fCJ$(-Z1u!\u0006,8/Z'jY2L7/\u0006\u0002\u0002\u0004A\u0019\u0011\"!\u0002\n\u0007\u0005\u001d!B\u0001\u0003M_:<\u0007\u0002CA\u0006\u0001\u0001\u0006I!a\u0001\u0002?\u0005\u001c7-\u001a9uC\ndW\rS3beR\u0014W-\u0019;QCV\u001cX-T5mY&\u001c\b\u0005\u0003\u0006\u0002\u0010\u0001\u0001\r\u0011\"\u0001\u0005\u0003#\tq!\u00193ee\u0016\u001c8/\u0006\u0002\u0002\u0014A!\u0011QCA\u000e\u001d\rI\u0011qC\u0005\u0004\u00033Q\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001e\u0005}!AB*ue&twMC\u0002\u0002\u001a)A!\"a\t\u0001\u0001\u0004%\t\u0001BA\u0013\u0003-\tG\r\u001a:fgN|F%Z9\u0015\t\u0005\u001d\u0012Q\u0006\t\u0004\u0013\u0005%\u0012bAA\u0016\u0015\t!QK\\5u\u0011)\ty#!\t\u0002\u0002\u0003\u0007\u00111C\u0001\u0004q\u0012\n\u0004\u0002CA\u001a\u0001\u0001\u0006K!a\u0005\u0002\u0011\u0005$GM]3tg\u00022a!a\u000e\u0001\r\u0006e\"!B*uCR,7cBA\u001b\u0011\u0005m\u0012\u0011\t\t\u0004\u0013\u0005u\u0012bAA \u0015\t9\u0001K]8ek\u000e$\bcA\u0005\u0002D%\u0019\u0011Q\t\u0006\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0015\u0005%\u0013Q\u0007BK\u0002\u0013\u0005\u00010A\u0004iSN$xN]=\t\u0015\u00055\u0013Q\u0007B\tB\u0003%\u00110\u0001\u0005iSN$xN]=!\u0011-\t\t&!\u000e\u0003\u0016\u0004%\t!a\u0015\u0002\u0013QLW.Z:uC6\u0004XCAA+!\u0011I!(a\u0001\t\u0017\u0005e\u0013Q\u0007B\tB\u0003%\u0011QK\u0001\u000bi&lWm\u001d;b[B\u0004\u0003bB*\u00026\u0011\u0005\u0011Q\f\u000b\u0007\u0003?\n\u0019'!\u001a\u0011\t\u0005\u0005\u0014QG\u0007\u0002\u0001!9\u0011\u0011JA.\u0001\u0004I\b\u0002CA)\u00037\u0002\r!!\u0016\t\u0015\u0005%\u0014QGA\u0001\n\u0003\tY'\u0001\u0003d_BLHCBA0\u0003[\ny\u0007C\u0005\u0002J\u0005\u001d\u0004\u0013!a\u0001s\"Q\u0011\u0011KA4!\u0003\u0005\r!!\u0016\t\u0015\u0005M\u0014QGI\u0001\n\u0003\t)(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005]$fA=\u0002z-\u0012\u00111\u0010\t\u0005\u0003{\n9)\u0004\u0002\u0002\u0000)!\u0011\u0011QAB\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0006*\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI)a \u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0002\u000e\u0006U\u0012\u0013!C\u0001\u0003\u001f\u000babY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u0012*\"\u0011QKA=\u0011)\t)*!\u000e\u0002\u0002\u0013\u0005\u0013qS\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005e\u0005\u0003BAN\u0003Kk!!!(\u000b\t\u0005}\u0015\u0011U\u0001\u0005Y\u0006twM\u0003\u0002\u0002$\u0006!!.\u0019<b\u0013\u0011\ti\"!(\t\u0013\u0005%\u0016QGA\u0001\n\u0003a\u0012\u0001\u00049s_\u0012,8\r^!sSRL\bBCAW\u0003k\t\t\u0011\"\u0001\u00020\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAY\u0003o\u00032!CAZ\u0013\r\t)L\u0003\u0002\u0004\u0003:L\b\"CA\u0018\u0003W\u000b\t\u00111\u0001\u001e\u0011)\tY,!\u000e\u0002\u0002\u0013\u0005\u0013QX\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0018\t\u0007\u0003\u0003\f9-!-\u000e\u0005\u0005\r'bAAc\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00171\u0019\u0002\t\u0013R,'/\u0019;pe\"Q\u0011QZA\u001b\u0003\u0003%\t!a4\u0002\u0011\r\fg.R9vC2$B!!5\u0002XB\u0019\u0011\"a5\n\u0007\u0005U'BA\u0004C_>dW-\u00198\t\u0015\u0005=\u00121ZA\u0001\u0002\u0004\t\t\f\u0003\u0006\u0002\\\u0006U\u0012\u0011!C!\u0003;\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002;!Q\u0011\u0011]A\u001b\u0003\u0003%\t%a9\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!'\t\u0015\u0005\u001d\u0018QGA\u0001\n\u0003\nI/\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003#\fY\u000f\u0003\u0006\u00020\u0005\u0015\u0018\u0011!a\u0001\u0003c;\u0011\"a<\u0001\u0003\u0003EI!!=\u0002\u000bM#\u0018\r^3\u0011\t\u0005\u0005\u00141\u001f\u0004\n\u0003o\u0001\u0011\u0011!E\u0005\u0003k\u001cb!a=\u0002x\u0006\u0005\u0003#CA}\u0003\u007fL\u0018QKA0\u001b\t\tYPC\u0002\u0002~*\tqA];oi&lW-\u0003\u0003\u0003\u0002\u0005m(!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oe!91+a=\u0005\u0002\t\u0015ACAAy\u0011)\t\t/a=\u0002\u0002\u0013\u0015\u00131\u001d\u0005\u000b\u0005\u0017\t\u00190!A\u0005\u0002\n5\u0011!B1qa2LHCBA0\u0005\u001f\u0011\t\u0002C\u0004\u0002J\t%\u0001\u0019A=\t\u0011\u0005E#\u0011\u0002a\u0001\u0003+B!B!\u0006\u0002t\u0006\u0005I\u0011\u0011B\f\u0003\u001d)h.\u00199qYf$BA!\u0007\u0003\"A!\u0011B\u000fB\u000e!\u0019I!QD=\u0002V%\u0019!q\u0004\u0006\u0003\rQ+\b\u000f\\33\u0011)\u0011\u0019Ca\u0005\u0002\u0002\u0003\u0007\u0011qL\u0001\u0004q\u0012\u0002\u0004\"\u0003B\u0014\u0001\t\u0007I\u0011\u0002B\u0015\u0003\u0015\u0019H/\u0019;f+\t\u0011Y\u0003\u0005\u0004\u0003.\te\u0012qL\u0007\u0003\u0005_QAA!\r\u00034\u00051\u0011\r^8nS\u000eT1A\u000bB\u001b\u0015\u0011\u00119$!)\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005w\u0011yCA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f\u0011!\u0011y\u0004\u0001Q\u0001\n\t-\u0012AB:uCR,\u0007\u0005C\u0004\u0003D\u0001!\tE!\u0012\u0002\u0017%\u001c\u0018I^1jY\u0006\u0014G.Z\u000b\u0003\u0003#DqAa\u0011\u0001\t\u0013\u0011I\u0005\u0006\u0003\u0002R\n-\u0003\u0002CA)\u0005\u000f\u0002\r!a\u0001\t\u000f\t=\u0003\u0001\"\u0011\u0003F\u0005a\u0011n]'p]&$xN]5oO\"9!1\u000b\u0001\u0005F\tU\u0013!\u00035fCJ$(-Z1u)\t\t9\u0003\u000b\u0003\u0003R\te\u0003\u0003\u0002B.\u0005;j!!a!\n\t\t}\u00131\u0011\u0002\bi\u0006LGN]3d\u0011\u0019\u0011\u0019\u0007\u0001C\u0001)\u0005\u0019\u0001\u000f[5\t\u000f\t\r\u0004\u0001\"\u0003\u0003hQ\u0019QC!\u001b\t\u0011\u0005E#Q\ra\u0001\u0003\u0007A\u0001Ba\u0019\u0001\t\u0003!!Q\u000e\u000b\b+\t=$1\u000fB<\u0011!\u0011\tHa\u001bA\u0002\u0005\r\u0011\u0001\u0003;j[\u0016$\u0015N\u001a4\t\u000f\tU$1\u000ea\u0001+\u0005!Q.Z1o\u0011\u001d\u0011IHa\u001bA\u0002U\tAb\u001d;e\t\u00164\u0018.\u0019;j_:D\u0011B! \u0001\u0005\u0004%I!!\u0001\u0002+5Lgn\u0015;e\t\u00164\u0018.\u0019;j_:l\u0015\u000e\u001c7jg\"A!\u0011\u0011\u0001!\u0002\u0013\t\u0019!\u0001\fnS:\u001cF\u000f\u001a#fm&\fG/[8o\u001b&dG.[:!\u0011\u001d\u0011)\t\u0001C\u0005\u0005\u000f\u000bq#\u001a8tkJ,g+\u00197jIN#H\rR3wS\u0006$\u0018n\u001c8\u0015\u0007U\u0011I\tC\u0004\u0003z\t\r\u0005\u0019A\u000b")
public class PhiAccrualFailureDetector
implements FailureDetector {
    private final double threshold;
    private final int maxSampleSize;
    private final FiniteDuration minStdDeviation;
    private final FiniteDuration acceptableHeartbeatPause;
    private final FiniteDuration firstHeartbeatEstimate;
    private final Option<EventStream> eventStream;
    private final FailureDetector.Clock clock;
    private final HeartbeatHistory firstHeartbeat;
    private final long acceptableHeartbeatPauseMillis;
    private String address;
    private final AtomicReference<State> state;
    private final long minStdDeviationMillis;
    private volatile PhiAccrualFailureDetector$State$ akka$remote$PhiAccrualFailureDetector$$State$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PhiAccrualFailureDetector$State$ akka$remote$PhiAccrualFailureDetector$$State$lzycompute() {
        PhiAccrualFailureDetector phiAccrualFailureDetector = this;
        synchronized (phiAccrualFailureDetector) {
            if (this.akka$remote$PhiAccrualFailureDetector$$State$module != null) return this.akka$remote$PhiAccrualFailureDetector$$State$module;
            this.akka$remote$PhiAccrualFailureDetector$$State$module = new PhiAccrualFailureDetector$State$(this);
            return this.akka$remote$PhiAccrualFailureDetector$$State$module;
        }
    }

    public double threshold() {
        return this.threshold;
    }

    public int maxSampleSize() {
        return this.maxSampleSize;
    }

    public FiniteDuration minStdDeviation() {
        return this.minStdDeviation;
    }

    public FiniteDuration acceptableHeartbeatPause() {
        return this.acceptableHeartbeatPause;
    }

    public FiniteDuration firstHeartbeatEstimate() {
        return this.firstHeartbeatEstimate;
    }

    private HeartbeatHistory firstHeartbeat() {
        return this.firstHeartbeat;
    }

    private long acceptableHeartbeatPauseMillis() {
        return this.acceptableHeartbeatPauseMillis;
    }

    public String address() {
        return this.address;
    }

    public void address_$eq(String x$1) {
        this.address = x$1;
    }

    public PhiAccrualFailureDetector$State$ akka$remote$PhiAccrualFailureDetector$$State() {
        return this.akka$remote$PhiAccrualFailureDetector$$State$module == null ? this.akka$remote$PhiAccrualFailureDetector$$State$lzycompute() : this.akka$remote$PhiAccrualFailureDetector$$State$module;
    }

    private AtomicReference<State> state() {
        return this.state;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable(this.clock.apply$mcJ$sp());
    }

    private boolean isAvailable(long timestamp) {
        return this.phi(timestamp) < this.threshold();
    }

    @Override
    public boolean isMonitoring() {
        return this.state().get().timestamp().nonEmpty();
    }

    @Override
    public final void heartbeat() {
        Option<Object> option;
        block6: {
            State newState;
            State oldState;
            do {
                HeartbeatHistory heartbeatHistory;
                long timestamp = this.clock.apply$mcJ$sp();
                oldState = this.state().get();
                option = oldState.timestamp();
                if (None$.MODULE$.equals(option)) {
                    heartbeatHistory = this.firstHeartbeat();
                } else {
                    HeartbeatHistory heartbeatHistory2;
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    long latestTimestamp = BoxesRunTime.unboxToLong((Object)some.x());
                    long interval = timestamp - latestTimestamp;
                    if (this.isAvailable(timestamp)) {
                        if (interval >= this.acceptableHeartbeatPauseMillis() / 3L * 2L && this.eventStream.isDefined()) {
                            ((SubchannelClassification)this.eventStream.get()).publish((Object)new Logging.Warning(this.toString(), this.getClass(), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"heartbeat interval is growing too large for address ", ": ", " millis"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.address(), BoxesRunTime.boxToLong((long)interval)}))));
                        }
                        heartbeatHistory2 = oldState.history().$colon$plus(interval);
                    } else {
                        heartbeatHistory2 = oldState.history();
                    }
                    heartbeatHistory = heartbeatHistory2;
                }
                HeartbeatHistory newHistory = heartbeatHistory;
                newState = oldState.copy(newHistory, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timestamp)));
            } while (!this.state().compareAndSet(oldState, newState));
            return;
        }
        throw new MatchError(option);
    }

    public double phi() {
        return this.phi(this.clock.apply$mcJ$sp());
    }

    private double phi(long timestamp) {
        double d;
        State oldState = this.state().get();
        Option<Object> oldTimestamp = oldState.timestamp();
        if (oldTimestamp.isEmpty()) {
            d = 0.0;
        } else {
            long timeDiff = timestamp - BoxesRunTime.unboxToLong((Object)oldTimestamp.get());
            HeartbeatHistory history = oldState.history();
            double mean = history.mean();
            double stdDeviation = this.ensureValidStdDeviation(history.stdDeviation());
            d = this.phi(timeDiff, mean + (double)this.acceptableHeartbeatPauseMillis(), stdDeviation);
        }
        return d;
    }

    public double phi(long timeDiff, double mean, double stdDeviation) {
        double y = ((double)timeDiff - mean) / stdDeviation;
        double e = package$.MODULE$.exp(-y * (1.5976 + 0.070566 * y * y));
        return (double)timeDiff > mean ? -package$.MODULE$.log10(e / (1.0 + e)) : -package$.MODULE$.log10(1.0 - 1.0 / (1.0 + e));
    }

    private long minStdDeviationMillis() {
        return this.minStdDeviationMillis;
    }

    private double ensureValidStdDeviation(double stdDeviation) {
        return package$.MODULE$.max(stdDeviation, (double)this.minStdDeviationMillis());
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, Option<EventStream> eventStream, FailureDetector.Clock clock) {
        this.threshold = threshold;
        this.maxSampleSize = maxSampleSize;
        this.minStdDeviation = minStdDeviation;
        this.acceptableHeartbeatPause = acceptableHeartbeatPause;
        this.firstHeartbeatEstimate = firstHeartbeatEstimate;
        this.eventStream = eventStream;
        this.clock = clock;
        Predef$.MODULE$.require(threshold > 0.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failure-detector.threshold must be > 0";
            }
        });
        Predef$.MODULE$.require(maxSampleSize > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failure-detector.max-sample-size must be > 0";
            }
        });
        Predef$.MODULE$.require(minStdDeviation.$greater((Object)Duration$.MODULE$.Zero()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failure-detector.min-std-deviation must be > 0";
            }
        });
        Predef$.MODULE$.require(acceptableHeartbeatPause.$greater$eq((Object)Duration$.MODULE$.Zero()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failure-detector.acceptable-heartbeat-pause must be >= 0";
            }
        });
        Predef$.MODULE$.require(firstHeartbeatEstimate.$greater((Object)Duration$.MODULE$.Zero()), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "failure-detector.heartbeat-interval must be > 0";
            }
        });
        long mean = firstHeartbeatEstimate.toMillis();
        long stdDeviation = mean / 4L;
        this.firstHeartbeat = HeartbeatHistory$.MODULE$.apply(maxSampleSize).$colon$plus(mean - stdDeviation).$colon$plus(mean + stdDeviation);
        this.acceptableHeartbeatPauseMillis = acceptableHeartbeatPause.toMillis();
        this.address = "N/A";
        this.state = new AtomicReference<State>(this.akka$remote$PhiAccrualFailureDetector$$State().apply(this.firstHeartbeat(), (Option<Object>)None$.MODULE$));
        this.minStdDeviationMillis = minStdDeviation.toMillis();
    }

    public PhiAccrualFailureDetector(double threshold, int maxSampleSize, FiniteDuration minStdDeviation, FiniteDuration acceptableHeartbeatPause, FiniteDuration firstHeartbeatEstimate, FailureDetector.Clock clock) {
        this(threshold, maxSampleSize, minStdDeviation, acceptableHeartbeatPause, firstHeartbeatEstimate, (Option<EventStream>)None$.MODULE$, clock);
    }

    public PhiAccrualFailureDetector(Config config, EventStream ev) {
        this(config.getDouble("threshold"), config.getInt("max-sample-size"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "min-std-deviation"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "acceptable-heartbeat-pause"), Helpers.ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "heartbeat-interval"), (Option<EventStream>)new Some((Object)ev), FailureDetector$.MODULE$.defaultClock());
    }

    public final class State
    implements Product,
    Serializable {
        private final HeartbeatHistory history;
        private final Option<Object> timestamp;
        private final /* synthetic */ PhiAccrualFailureDetector $outer;

        public HeartbeatHistory history() {
            return this.history;
        }

        public Option<Object> timestamp() {
            return this.timestamp;
        }

        public State copy(HeartbeatHistory history, Option<Object> timestamp) {
            return new State(this.$outer, history, timestamp);
        }

        public HeartbeatHistory copy$default$1() {
            return this.history();
        }

        public Option<Object> copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "State";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.timestamp();
                    break;
                }
                case 0: {
                    object = this.history();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof State;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof State)) return false;
            boolean bl = true;
            if (!bl) return false;
            State state = (State)x$1;
            HeartbeatHistory heartbeatHistory = this.history();
            HeartbeatHistory heartbeatHistory2 = state.history();
            if (heartbeatHistory == null) {
                if (heartbeatHistory2 != null) {
                    return false;
                }
            } else if (!((Object)heartbeatHistory).equals(heartbeatHistory2)) return false;
            Option<Object> option = this.timestamp();
            Option<Object> option2 = state.timestamp();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public State(PhiAccrualFailureDetector $outer, HeartbeatHistory history, Option<Object> timestamp) {
            this.history = history;
            this.timestamp = timestamp;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

