/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.sendnagiospassivecheck;

import com.googlecode.jsendnsca.Level;
import com.googlecode.jsendnsca.MessagePayload;
import com.googlecode.jsendnsca.NagiosPassiveCheckSender;
import com.googlecode.jsendnsca.NagiosSettings;
import com.googlecode.jsendnsca.builders.MessagePayloadBuilder;
import com.googlecode.jsendnsca.builders.NagiosSettingsBuilder;
import com.googlecode.jsendnsca.encryption.Encryption;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="SEND_NAGIOS_PASSIVE_CHECK", name="i18n::ActionSendNagiosPassiveCheck.Name", description="i18n::ActionSendNagiosPassiveCheck.Description", image="SendNagiosPassiveCheck.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Utility", documentationUrl="/workflow/actions/sendnagiospassivecheck.html")
public class ActionSendNagiosPassiveCheck
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionSendNagiosPassiveCheck.class;
    private String serverName = null;
    private String port = "" + DEFAULT_PORT;
    private String responseTimeOut;
    private String connectionTimeOut = String.valueOf(DEFAULT_CONNECTION_TIME_OUT);
    private String message = null;
    private String senderServerName = null;
    private String senderServiceName = null;
    private int encryptionMode = 0;
    private int level = 0;
    private String password = null;
    private static int DEFAULT_RESPONSE_TIME_OUT = 10000;
    public static int DEFAULT_CONNECTION_TIME_OUT = 5000;
    public static int DEFAULT_PORT = 5667;
    public static final String[] encryptionModeDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.EncryptionMode.None", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.EncryptionMode.TripleDES", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.EncryptionMode.XOR", (String[])new String[0])};
    public static final String[] encryptionModeCode = new String[]{"none", "tripledes", "xor"};
    public static final int ENCRYPTION_MODE_NONE = 0;
    public static final int ENCRYPTION_MODE_TRIPLEDES = 1;
    public static final int ENCRYPTION_MODE_XOR = 2;
    public static final String[] levelTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.LevelType.Unknown", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.EncryptionMode.OK", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.EncryptionMode.Warning", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.EncryptionMode.Critical", (String[])new String[0])};
    public static final String[] levelTypeCode = new String[]{"unknown", "ok", "warning", "critical"};
    public static final int LEVEL_TYPE_UNKNOWN = 0;
    public static final int LEVEL_TYPE_OK = 1;
    public static final int LEVEL_TYPE_WARNING = 2;
    public static final int LEVEL_TYPE_CRITICAL = 3;

    public ActionSendNagiosPassiveCheck(String n) {
        super(n, "");
        this.responseTimeOut = String.valueOf(DEFAULT_RESPONSE_TIME_OUT);
    }

    public ActionSendNagiosPassiveCheck() {
        this("");
    }

    public Object clone() {
        ActionSendNagiosPassiveCheck je = (ActionSendNagiosPassiveCheck)super.clone();
        return je;
    }

    public static int getEncryptionModeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < encryptionModeDesc.length; ++i) {
            if (!encryptionModeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionSendNagiosPassiveCheck.getEncryptionModeByCode(tt);
    }

    public static String getEncryptionModeDesc(int i) {
        if (i < 0 || i >= encryptionModeDesc.length) {
            return encryptionModeDesc[0];
        }
        return encryptionModeDesc[i];
    }

    public static String getLevelDesc(int i) {
        if (i < 0 || i >= levelTypeDesc.length) {
            return levelTypeDesc[0];
        }
        return levelTypeDesc[i];
    }

    public static int getLevelByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < levelTypeDesc.length; ++i) {
            if (!levelTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionSendNagiosPassiveCheck.getEncryptionModeByCode(tt);
    }

    private static String getEncryptionModeCode(int i) {
        if (i < 0 || i >= encryptionModeCode.length) {
            return encryptionModeCode[0];
        }
        return encryptionModeCode[i];
    }

    private String getLevelCode(int i) {
        if (i < 0 || i >= levelTypeCode.length) {
            return levelTypeCode[0];
        }
        return levelTypeCode[i];
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(200);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XmlHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"password", (String)this.password));
        retval.append("      ").append(XmlHandler.addTagValue((String)"responseTimeOut", (String)this.responseTimeOut));
        retval.append("      ").append(XmlHandler.addTagValue((String)"connectionTimeOut", (String)this.connectionTimeOut));
        retval.append("      ").append(XmlHandler.addTagValue((String)"senderServerName", (String)this.senderServerName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"senderServiceName", (String)this.senderServiceName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"message", (String)this.message));
        retval.append("      ").append(XmlHandler.addTagValue((String)"encryptionMode", (String)ActionSendNagiosPassiveCheck.getEncryptionModeCode(this.encryptionMode)));
        retval.append("      ").append(XmlHandler.addTagValue((String)"level", (String)this.getLevelCode(this.level)));
        return retval.toString();
    }

    private static int getEncryptionModeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < encryptionModeCode.length; ++i) {
            if (!encryptionModeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getLevelByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < levelTypeCode.length; ++i) {
            if (!levelTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.port = XmlHandler.getTagValue((Node)entrynode, (String)"port");
            this.serverName = XmlHandler.getTagValue((Node)entrynode, (String)"servername");
            this.responseTimeOut = XmlHandler.getTagValue((Node)entrynode, (String)"responseTimeOut");
            this.connectionTimeOut = XmlHandler.getTagValue((Node)entrynode, (String)"connectionTimeOut");
            this.password = XmlHandler.getTagValue((Node)entrynode, (String)"password");
            this.senderServerName = XmlHandler.getTagValue((Node)entrynode, (String)"senderServerName");
            this.senderServiceName = XmlHandler.getTagValue((Node)entrynode, (String)"senderServiceName");
            this.message = XmlHandler.getTagValue((Node)entrynode, (String)"message");
            this.encryptionMode = ActionSendNagiosPassiveCheck.getEncryptionModeByCode(XmlHandler.getTagValue((Node)entrynode, (String)"encryptionMode"));
            this.level = ActionSendNagiosPassiveCheck.getLevelByCode(XmlHandler.getTagValue((Node)entrynode, (String)"level"));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'SendNagiosPassiveCheck' from XML node", (Throwable)xe);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getSenderServerName() {
        return this.senderServerName;
    }

    public void setSenderServerName(String senderServerName) {
        this.senderServerName = senderServerName;
    }

    public String getSenderServiceName() {
        return this.senderServiceName;
    }

    public void setSenderServiceName(String senderServiceName) {
        this.senderServiceName = senderServiceName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public int getEncryptionMode() {
        return this.encryptionMode;
    }

    public void setEncryptionMode(int encryptionModein) {
        this.encryptionMode = encryptionModein;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int levelMode) {
        this.level = levelMode;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setResponseTimeOut(String responseTimeOut) {
        this.responseTimeOut = responseTimeOut;
    }

    public String getResponseTimeOut() {
        return this.responseTimeOut;
    }

    public void setConnectionTimeOut(String connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    public String getConnectionTimeOut() {
        return this.connectionTimeOut;
    }

    public Result execute(Result previousResult, int nr) {
        this.log.logBasic(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Started", (String[])new String[]{this.serverName}));
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String realServername = this.resolve(this.serverName);
        String realPassword = Utils.resolvePassword((IVariables)this.getVariables(), (String)this.password);
        int realPort = Const.toInt((String)this.resolve(this.port), (int)DEFAULT_PORT);
        int realResponseTimeOut = Const.toInt((String)this.resolve(this.responseTimeOut), (int)DEFAULT_RESPONSE_TIME_OUT);
        int realConnectionTimeOut = Const.toInt((String)this.resolve(this.connectionTimeOut), (int)DEFAULT_CONNECTION_TIME_OUT);
        String realSenderServerName = this.resolve(this.senderServerName);
        String realSenderServiceName = this.resolve(this.senderServiceName);
        try {
            if (Utils.isEmpty((CharSequence)realServername)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Error.TargetServerMissing", (String[])new String[0]));
            }
            String realMessageString = this.resolve(this.message);
            if (Utils.isEmpty((CharSequence)realMessageString)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.Error.MessageMissing", (String[])new String[0]));
            }
            Level level = Level.UNKNOWN;
            switch (this.getLevel()) {
                case 1: {
                    level = Level.OK;
                    break;
                }
                case 3: {
                    level = Level.CRITICAL;
                    break;
                }
                case 2: {
                    level = Level.WARNING;
                    break;
                }
            }
            Encryption encr = Encryption.NONE;
            switch (this.getEncryptionMode()) {
                case 1: {
                    encr = Encryption.TRIPLE_DES;
                    break;
                }
                case 2: {
                    encr = Encryption.XOR;
                    break;
                }
            }
            NagiosSettingsBuilder ns = new NagiosSettingsBuilder();
            ns.withNagiosHost(realServername);
            ns.withPort(realPort);
            ns.withConnectionTimeout(realConnectionTimeOut);
            ns.withResponseTimeout(realResponseTimeOut);
            ns.withEncryption(encr);
            if (!Utils.isEmpty((CharSequence)realPassword)) {
                ns.withPassword(realPassword);
            } else {
                ns.withNoPassword();
            }
            NagiosSettings settings = ns.create();
            MessagePayloadBuilder pb = new MessagePayloadBuilder();
            if (!Utils.isEmpty((CharSequence)realSenderServerName)) {
                pb.withHostname(realSenderServerName);
            }
            pb.withLevel(level);
            if (!Utils.isEmpty((CharSequence)realSenderServiceName)) {
                pb.withServiceName(realSenderServiceName);
            }
            pb.withMessage(realMessageString);
            MessagePayload payload = pb.create();
            NagiosPassiveCheckSender sender = new NagiosPassiveCheckSender(settings);
            sender.send(payload);
            result.setNrErrors(0L);
            result.setResult(true);
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"ActionSendNagiosPassiveCheck.ErrorGetting", (String[])new String[]{e.toString()}));
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.serverName)) {
            String realServername = this.resolve(this.serverName);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

