/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.checkfilelocked;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.actions.checkfilelocked.LockFile;
import org.w3c.dom.Node;

@Action(id="CHECK_FILES_LOCKED", name="i18n::ActionCheckFilesLocked.Name", description="i18n::ActionCheckFilesLocked.Description", image="CheckFilesLocked.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", documentationUrl="/workflow/actions/checkfilelocked.html")
public class ActionCheckFilesLocked
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionCheckFilesLocked.class;
    public boolean argFromPrevious = false;
    public boolean includeSubfolders = false;
    public String[] arguments = null;
    public String[] filemasks;
    private boolean oneFileLocked;

    public ActionCheckFilesLocked(String n) {
        super(n, "");
    }

    public ActionCheckFilesLocked() {
        this("");
    }

    public Object clone() {
        ActionCheckFilesLocked je = (ActionCheckFilesLocked)super.clone();
        if (this.arguments != null) {
            int nrFields = this.arguments.length;
            je.allocate(nrFields);
            System.arraycopy(this.arguments, 0, je.arguments, 0, nrFields);
            System.arraycopy(this.filemasks, 0, je.filemasks, 0, nrFields);
        }
        return je;
    }

    public void allocate(int nrFields) {
        this.arguments = new String[nrFields];
        this.filemasks = new String[nrFields];
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(300);
        xml.append(super.getXml());
        xml.append("      ").append(XmlHandler.addTagValue((String)"arg_from_previous", (boolean)this.argFromPrevious));
        xml.append("      ").append(XmlHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubfolders));
        xml.append("      <fields>").append(Const.CR);
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                xml.append("        <field>").append(Const.CR);
                xml.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.arguments[i]));
                xml.append("          ").append(XmlHandler.addTagValue((String)"filemask", (String)this.filemasks[i]));
                xml.append("        </field>").append(Const.CR);
            }
        }
        xml.append("      </fields>").append(Const.CR);
        return xml.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.argFromPrevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.includeSubfolders = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            Node fields = XmlHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.arguments[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                this.filemasks[i] = XmlHandler.getTagValue((Node)fnode, (String)"filemask");
            }
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.UnableToLoadFromXml", (String[])new String[0]), (Throwable)xe);
        }
    }

    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        this.oneFileLocked = false;
        result.setResult(true);
        try {
            if (this.argFromPrevious && this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.FoundPreviousRows", (String[])new String[]{String.valueOf(rows != null ? rows.size() : 0)}));
            }
            if (this.argFromPrevious && rows != null) {
                for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    String fileFolderPrevious = resultRow.getString(0, "");
                    String fileMasksPrevious = resultRow.getString(1, "");
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.ProcessingRow", (String[])new String[]{fileFolderPrevious, fileMasksPrevious}));
                    }
                    this.ProcessFile(fileFolderPrevious, fileMasksPrevious);
                }
            } else if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length && !this.parentWorkflow.isStopped(); ++i) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.ProcessingArg", (String[])new String[]{this.arguments[i], this.filemasks[i]}));
                    }
                    this.ProcessFile(this.arguments[i], this.filemasks[i]);
                }
            }
            if (this.oneFileLocked) {
                result.setResult(false);
                result.setNrErrors(1L);
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.ErrorRunningAction", (Object[])new Object[]{e}));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ProcessFile(String filename, String wildcard) {
        FileObject filefolder = null;
        String realFilefoldername = this.resolve(filename);
        String realwilcard = this.resolve(wildcard);
        try {
            filefolder = HopVfs.getFileObject((String)realFilefoldername);
            FileObject[] files = new FileObject[]{filefolder};
            if (filefolder.exists()) {
                if (filefolder.getType() == FileType.FOLDER) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.ProcessingFolder", (String[])new String[]{realFilefoldername}));
                    }
                    files = filefolder.findFiles((FileSelector)new TextFileSelector(filefolder.toString(), realwilcard));
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.TotalFilesToCheck", (String[])new String[]{String.valueOf(files.length)}));
                    }
                } else if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.ProcessingFile", (String[])new String[]{realFilefoldername}));
                }
                this.checkFilesLocked(files);
            } else {
                this.logBasic(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.FileNotExist", (String[])new String[]{realFilefoldername}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.CouldNotProcess", (String[])new String[]{realFilefoldername, e.getMessage()}));
        }
        finally {
            if (filefolder != null) {
                try {
                    filefolder.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void checkFilesLocked(FileObject[] files) throws HopException {
        for (int i = 0; i < files.length && !this.oneFileLocked; ++i) {
            FileObject file = files[i];
            String filename = HopVfs.getFilename((FileObject)file);
            LockFile locked = new LockFile(filename);
            if (locked.isLocked()) {
                this.oneFileLocked = true;
                this.logError(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Log.FileLocked", (String[])new String[]{filename}));
                continue;
            }
            if (!this.isDetailed()) continue;
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCheckFilesLocked.Log.FileNotLocked", (String[])new String[]{filename}));
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Utils.isEmpty((CharSequence)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includeSubfolders = includeSubfolders;
    }

    public void setargFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String[] getFilemasks() {
        return this.filemasks;
    }

    public boolean isIncludeSubfolders() {
        return this.includeSubfolders;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        boolean res = ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        for (int i = 0; i < this.arguments.length; ++i) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    private class TextFileSelector
    implements FileSelector {
        String fileWildcard = null;
        String sourceFolder = null;

        public TextFileSelector(String sourcefolderin, String filewildcard) {
            if (!Utils.isEmpty((CharSequence)sourcefolderin)) {
                this.sourceFolder = sourcefolderin;
            }
            if (!Utils.isEmpty((CharSequence)filewildcard)) {
                this.fileWildcard = filewildcard;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            Object filename = null;
            try {
                if (!info.getFile().toString().equals(this.sourceFolder)) {
                    String shortFilename = info.getFile().getName().getBaseName();
                    if (!info.getFile().getParent().equals(info.getBaseFolder())) {
                        if (ActionCheckFilesLocked.this.includeSubfolders && info.getFile().getType() == FileType.FILE && ActionCheckFilesLocked.this.GetFileWildcard(shortFilename, this.fileWildcard)) {
                            if (ActionCheckFilesLocked.this.isDetailed()) {
                                ActionCheckFilesLocked.this.logDetailed(BaseMessages.getString((Class)PKG, (String)"ActionCheckFilesLocked.CheckingFile", (String[])new String[]{info.getFile().toString()}));
                            }
                            returncode = true;
                        }
                    } else if (info.getFile().getType() == FileType.FILE && ActionCheckFilesLocked.this.GetFileWildcard(shortFilename, this.fileWildcard)) {
                        if (ActionCheckFilesLocked.this.isDetailed()) {
                            ActionCheckFilesLocked.this.logDetailed(BaseMessages.getString((Class)PKG, (String)"ActionCheckFilesLocked.CheckingFile", (String[])new String[]{info.getFile().toString()}));
                        }
                        returncode = true;
                    }
                }
            }
            catch (Exception e) {
                ActionCheckFilesLocked.this.logError(BaseMessages.getString((Class)PKG, (String)"ActionCheckFilesLocked.Error.Exception.ProcessError", (String[])new String[0]), new Object[]{BaseMessages.getString((Class)PKG, (String)"JobCheckFilesLocked.Error.Exception.Process", (String[])new String[]{info.getFile().toString(), e.getMessage()})});
                returncode = false;
            }
            finally {
                if (filename != null) {
                    try {
                        filename.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return info.getDepth() == 0 || ActionCheckFilesLocked.this.includeSubfolders;
        }
    }
}

