/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.synchronizeaftermerge;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.synchronizeaftermerge.SynchronizeAfterMerge;
import org.apache.hop.pipeline.transforms.synchronizeaftermerge.SynchronizeAfterMergeData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="SynchronizeAfterMerge.Injection.", groups={"KEYS_TO_LOOKUP", "UPDATE_FIELDS"})
@Transform(id="SynchronizeAfterMerge", image="synchronizeaftermerge.svg", name="i18n::SynchronizeAfterMerge.Name", description="i18n::SynchronizeAfterMerge.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", documentationUrl="/pipeline/transforms/synchronizeaftermerge.html")
public class SynchronizeAfterMergeMeta
extends BaseTransformMeta
implements ITransformMeta<SynchronizeAfterMerge, SynchronizeAfterMergeData> {
    private static final Class<?> PKG = SynchronizeAfterMergeMeta.class;
    @Injection(name="SHEMA_NAME")
    private String schemaName;
    @Injection(name="TABLE_NAME")
    private String tableName;
    private IHopMetadataProvider metadataProvider;
    private DatabaseMeta databaseMeta;
    @Injection(name="STREAM_FIELD1", group="KEYS_TO_LOOKUP")
    private String[] keyStream;
    @Injection(name="TABLE_FIELD", group="KEYS_TO_LOOKUP")
    private String[] keyLookup;
    @Injection(name="COMPARATOR", group="KEYS_TO_LOOKUP")
    private String[] keyCondition;
    @Injection(name="STREAM_FIELD2", group="KEYS_TO_LOOKUP")
    private String[] keyStream2;
    @Injection(name="UPDATE_TABLE_FIELD", group="UPDATE_FIELDS")
    private String[] updateLookup;
    @Injection(name="STREAM_FIELD", group="UPDATE_FIELDS")
    private String[] updateStream;
    @Injection(name="UPDATE", group="UPDATE_FIELDS")
    private Boolean[] update;
    @Injection(name="COMMIT_SIZE")
    private String commitSize;
    @Injection(name="TABLE_NAME_IN_FIELD")
    private boolean tablenameInField;
    @Injection(name="TABLE_NAME_FIELD")
    private String tablenameField;
    @Injection(name="OPERATION_ORDER_FIELD")
    private String operationOrderField;
    @Injection(name="USE_BATCH_UPDATE")
    private boolean useBatchUpdate;
    @Injection(name="PERFORM_LOOKUP")
    private boolean performLookup;
    @Injection(name="ORDER_INSERT")
    private String OrderInsert;
    @Injection(name="ORDER_UPDATE")
    private String OrderUpdate;
    @Injection(name="ORDER_DELETE")
    private String OrderDelete;

    @Injection(name="CONNECTION_NAME")
    public void setConnection(String connectionName) {
        try {
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)this.metadataProvider, (String)connectionName);
        }
        catch (HopXmlException e) {
            throw new RuntimeException("Error load connection '" + connectionName + "'", e);
        }
    }

    public void setUseBatchUpdate(boolean useBatchUpdate) {
        this.useBatchUpdate = useBatchUpdate;
    }

    public boolean useBatchUpdate() {
        return this.useBatchUpdate;
    }

    public void setPerformLookup(boolean performLookup) {
        this.performLookup = performLookup;
    }

    public boolean isPerformLookup() {
        return this.performLookup;
    }

    public boolean istablenameInField() {
        return this.tablenameInField;
    }

    public void settablenameInField(boolean tablenamefield) {
        this.tablenameInField = tablenamefield;
    }

    public String gettablenameField() {
        return this.tablenameField;
    }

    public String getOperationOrderField() {
        return this.operationOrderField;
    }

    public String getOrderInsert() {
        return this.OrderInsert;
    }

    public String getOrderUpdate() {
        return this.OrderUpdate;
    }

    public String getOrderDelete() {
        return this.OrderDelete;
    }

    public void setOrderInsert(String insert) {
        this.OrderInsert = insert;
    }

    public void setOrderUpdate(String update) {
        this.OrderUpdate = update;
    }

    public void setOrderDelete(String delete) {
        this.OrderDelete = delete;
    }

    public void setOperationOrderField(String operationOrderField) {
        this.operationOrderField = operationOrderField;
    }

    public void settablenameField(String tablenamefield) {
        this.tablenameField = tablenamefield;
    }

    public String getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = Integer.toString(commitSize);
    }

    public void setCommitSize(String commitSize) {
        this.commitSize = commitSize;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public String[] getKeyCondition() {
        return this.keyCondition;
    }

    public void setKeyCondition(String[] keyCondition) {
        this.keyCondition = keyCondition;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public String[] getKeyStream() {
        return this.keyStream;
    }

    public void setKeyStream(String[] keyStream) {
        this.keyStream = keyStream;
    }

    public String[] getKeyStream2() {
        return this.keyStream2;
    }

    public void setKeyStream2(String[] keyStream2) {
        this.keyStream2 = keyStream2;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getUpdateLookup() {
        return this.updateLookup;
    }

    public void setUpdateLookup(String[] updateLookup) {
        this.updateLookup = updateLookup;
    }

    public String[] getUpdateStream() {
        return this.updateStream;
    }

    public void setUpdateStream(String[] updateStream) {
        this.updateStream = updateStream;
    }

    public Boolean[] getUpdate() {
        return this.update;
    }

    public void setUpdate(Boolean[] update) {
        this.update = update;
    }

    public void normalizeAllocationFields() {
        if (this.keyStream != null) {
            int keyGroupSize = this.keyStream.length;
            this.keyLookup = this.normalizeAllocation(this.keyLookup, keyGroupSize);
            this.keyCondition = this.normalizeAllocation(this.keyCondition, keyGroupSize);
            this.keyStream2 = this.normalizeAllocation(this.keyStream2, keyGroupSize);
        }
        if (this.updateLookup != null) {
            int updateGroupSize = this.updateLookup.length;
            this.updateStream = this.normalizeAllocation(this.updateStream, updateGroupSize);
            this.update = this.normalizeAllocation(this.update, updateGroupSize);
        }
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public void allocate(int nrkeys, int nrvalues) {
        this.keyStream = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
        this.keyCondition = new String[nrkeys];
        this.keyStream2 = new String[nrkeys];
        this.updateLookup = new String[nrvalues];
        this.updateStream = new String[nrvalues];
        this.update = new Boolean[nrvalues];
    }

    public Object clone() {
        SynchronizeAfterMergeMeta retval = (SynchronizeAfterMergeMeta)((Object)super.clone());
        int nrkeys = this.keyStream.length;
        int nrvalues = this.updateLookup.length;
        retval.allocate(nrkeys, nrvalues);
        System.arraycopy(this.keyStream, 0, retval.keyStream, 0, nrkeys);
        System.arraycopy(this.keyLookup, 0, retval.keyLookup, 0, nrkeys);
        System.arraycopy(this.keyCondition, 0, retval.keyCondition, 0, nrkeys);
        System.arraycopy(this.keyStream2, 0, retval.keyStream2, 0, nrkeys);
        System.arraycopy(this.updateLookup, 0, retval.updateLookup, 0, nrvalues);
        System.arraycopy(this.updateStream, 0, retval.updateStream, 0, nrvalues);
        System.arraycopy(this.update, 0, retval.update, 0, nrvalues);
        return retval;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.metadataProvider = metadataProvider;
        try {
            int i;
            this.databases = this.databases;
            String con = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)con);
            this.commitSize = XmlHandler.getTagValue((Node)transformNode, (String)"commit");
            this.schemaName = XmlHandler.getTagValue((Node)transformNode, (String)"lookup", (String)"schema");
            this.tableName = XmlHandler.getTagValue((Node)transformNode, (String)"lookup", (String)"table");
            this.useBatchUpdate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"use_batch"));
            this.performLookup = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"perform_lookup"));
            this.tablenameInField = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"tablename_in_field"));
            this.tablenameField = XmlHandler.getTagValue((Node)transformNode, (String)"tablename_field");
            this.operationOrderField = XmlHandler.getTagValue((Node)transformNode, (String)"operation_order_field");
            this.OrderInsert = XmlHandler.getTagValue((Node)transformNode, (String)"order_insert");
            this.OrderUpdate = XmlHandler.getTagValue((Node)transformNode, (String)"order_update");
            this.OrderDelete = XmlHandler.getTagValue((Node)transformNode, (String)"order_delete");
            Node lookup = XmlHandler.getSubNode((Node)transformNode, (String)"lookup");
            int nrkeys = XmlHandler.countNodes((Node)lookup, (String)"key");
            int nrvalues = XmlHandler.countNodes((Node)lookup, (String)"value");
            this.allocate(nrkeys, nrvalues);
            for (i = 0; i < nrkeys; ++i) {
                Node knode = XmlHandler.getSubNodeByNr((Node)lookup, (String)"key", (int)i);
                this.keyStream[i] = XmlHandler.getTagValue((Node)knode, (String)"name");
                this.keyLookup[i] = XmlHandler.getTagValue((Node)knode, (String)"field");
                this.keyCondition[i] = XmlHandler.getTagValue((Node)knode, (String)"condition");
                if (this.keyCondition[i] == null) {
                    this.keyCondition[i] = "=";
                }
                this.keyStream2[i] = XmlHandler.getTagValue((Node)knode, (String)"name2");
            }
            for (i = 0; i < nrvalues; ++i) {
                String updateValue;
                Node vnode = XmlHandler.getSubNodeByNr((Node)lookup, (String)"value", (int)i);
                this.updateLookup[i] = XmlHandler.getTagValue((Node)vnode, (String)"name");
                this.updateStream[i] = XmlHandler.getTagValue((Node)vnode, (String)"rename");
                if (this.updateStream[i] == null) {
                    this.updateStream[i] = this.updateLookup[i];
                }
                this.update[i] = (updateValue = XmlHandler.getTagValue((Node)vnode, (String)"update")) == null ? Boolean.TRUE : (updateValue.equalsIgnoreCase("Y") ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.Exception.UnableToReadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        int i;
        this.tablenameInField = false;
        this.tablenameField = null;
        this.keyStream = null;
        this.updateLookup = null;
        this.databaseMeta = null;
        this.commitSize = "100";
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.DefaultTableName", (String[])new String[0]);
        this.operationOrderField = null;
        this.OrderInsert = null;
        this.OrderUpdate = null;
        this.OrderDelete = null;
        this.performLookup = false;
        int nrkeys = 0;
        int nrvalues = 0;
        this.allocate(nrkeys, nrvalues);
        for (i = 0; i < nrkeys; ++i) {
            this.keyLookup[i] = "age";
            this.keyCondition[i] = "BETWEEN";
            this.keyStream[i] = "age_from";
            this.keyStream2[i] = "age_to";
        }
        for (i = 0; i < nrvalues; ++i) {
            this.updateLookup[i] = BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.ColumnName.ReturnField", (String[])new String[0]) + i;
            this.updateStream[i] = BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.ColumnName.NewName", (String[])new String[0]) + i;
            this.update[i] = Boolean.TRUE;
        }
    }

    public String getXml() {
        int i;
        this.normalizeAllocationFields();
        StringBuilder retval = new StringBuilder(200);
        retval.append("    ").append(XmlHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    ").append(XmlHandler.addTagValue((String)"commit", (String)this.commitSize));
        retval.append("    ").append(XmlHandler.addTagValue((String)"tablename_in_field", (boolean)this.tablenameInField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"tablename_field", (String)this.tablenameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"use_batch", (boolean)this.useBatchUpdate));
        retval.append("    ").append(XmlHandler.addTagValue((String)"perform_lookup", (boolean)this.performLookup));
        retval.append("    ").append(XmlHandler.addTagValue((String)"operation_order_field", (String)this.operationOrderField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"order_insert", (String)this.OrderInsert));
        retval.append("    ").append(XmlHandler.addTagValue((String)"order_update", (String)this.OrderUpdate));
        retval.append("    ").append(XmlHandler.addTagValue((String)"order_delete", (String)this.OrderDelete));
        retval.append("    <lookup>").append(Const.CR);
        retval.append("      ").append(XmlHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("      ").append(XmlHandler.addTagValue((String)"table", (String)this.tableName));
        for (i = 0; i < this.keyStream.length; ++i) {
            retval.append("      <key>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.keyStream[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"field", (String)this.keyLookup[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"condition", (String)this.keyCondition[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"name2", (String)this.keyStream2[i]));
            retval.append("      </key>").append(Const.CR);
        }
        for (i = 0; i < this.updateLookup.length; ++i) {
            retval.append("      <value>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.updateLookup[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"rename", (String)this.updateStream[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"update", (boolean)this.update[i]));
            retval.append("      </value>").append(Const.CR);
        }
        retval.append("    </lookup>").append(Const.CR);
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        errorMessage = "";
        if (this.databaseMeta != null) {
            db = new Database(SynchronizeAfterMergeMeta.loggingObject, variables, this.databaseMeta);
            try {
                db.connect();
                if (!Utils.isEmpty((CharSequence)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.TableNameOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    r = db.getTableFieldsMeta(this.schemaName, this.tableName);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.TableExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        for (i = 0; i < this.keyLookup.length; ++i) {
                            lufield = this.keyLookup[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = errorMessage + BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingCompareFieldsInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = errorMessage + "\t\t" + lufield + Const.CR;
                        }
                        cr = errorFound != false ? new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.AllLookupFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                        first = true;
                        errorFound = false;
                        errorMessage = "";
                        for (i = 0; i < this.updateLookup.length; ++i) {
                            lufield = this.updateLookup[i];
                            v = r.searchValueMeta(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                errorMessage = errorMessage + BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingFieldsToUpdateInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            errorFound = true;
                            errorMessage = errorMessage + "\t\t" + lufield + Const.CR;
                        }
                        cr = errorFound != false ? new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.AllFieldsToUpdateFoundInTargetTable", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    } else {
                        errorMessage = BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    cr = new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.TransformReceivingDatas", (String[])new String[]{prev.size() + ""}), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorMessage = "";
                    errorFound = false;
                    for (i = 0; i < this.keyStream.length; ++i) {
                        v = prev.searchValueMeta(this.keyStream[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = errorMessage + BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = errorMessage + "\t\t" + this.keyStream[i] + Const.CR;
                    }
                    for (i = 0; i < this.keyStream2.length; ++i) {
                        if (this.keyStream2[i] == null || this.keyStream2[i].length() <= 0 || (v = prev.searchValueMeta(this.keyStream2[i])) != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = errorMessage + BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = errorMessage + "\t\t" + this.keyStream[i] + Const.CR;
                    }
                    cr = errorFound != false ? new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    first = true;
                    errorFound = false;
                    errorMessage = "";
                    for (i = 0; i < this.updateStream.length; ++i) {
                        lufield = this.updateStream[i];
                        v = prev.searchValueMeta(lufield);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            errorMessage = errorMessage + BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingInputStreamFields", (String[])new String[0]) + Const.CR;
                        }
                        errorFound = true;
                        errorMessage = errorMessage + "\t\t" + lufield + Const.CR;
                    }
                    if (errorFound) {
                        cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                    } else {
                        cr = new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.AllFieldsFoundInInput2", (String[])new String[0]), (ICheckResultSource)transformMeta);
                        remarks.add((ICheckResult)cr);
                    }
                    errorMsgDiffField = "";
                    errorDiffLenField = false;
                    errorMsgDiffLenField = "";
                    errorDiffField = false;
                    r = db.getTableFieldsMeta(this.schemaName, this.tableName);
                    if (r == null) ** GOTO lbl145
                    for (i = 0; i < this.updateStream.length; ++i) {
                        lufieldstream = this.updateStream[i];
                        lufieldtable = this.updateLookup[i];
                        vs = prev.searchValueMeta(lufieldstream);
                        vt = r.searchValueMeta(lufieldtable);
                        if (vs == null || vt == null) continue;
                        if (!vs.getTypeDesc().equalsIgnoreCase(vt.getTypeDesc())) {
                            errorMsgDiffField = errorMsgDiffField + Const.CR + "The input field [" + vs.getName() + "] ( Type=" + vs.getTypeDesc() + ") is not the same as the type in the target table (Type=" + vt.getTypeDesc() + ")" + Const.CR;
                            errorDiffField = true;
                            continue;
                        }
                        if (vt.getLength() >= vs.getLength() && vs.getLength() != -1 || vt.getLength() == -1) continue;
                        errorMsgDiffLenField = errorMsgDiffLenField + Const.CR + "The input field [" + vs.getName() + "] (" + vs.getTypeDesc() + ") has a length (" + vs.getLength() + ") that is higher than that in the target table (" + vt.getLength() + ")." + Const.CR;
                        errorDiffLenField = true;
                    }
                    if (errorDiffField) {
                        errorMsgDiffField = BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.FieldsTypeDifferent", (String[])new String[0]) + Const.CR + errorMsgDiffField;
                        cr = new CheckResult(4, errorMsgDiffField, (ICheckResultSource)transformMeta);
                    }
                    if (errorDiffLenField) {
                        errorMsgDiffLenField = BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.FieldsLenDifferent", (String[])new String[0]) + Const.CR + errorMsgDiffLenField;
                        cr = new CheckResult(3, errorMsgDiffLenField, (ICheckResultSource)transformMeta);
                    }
                    remarks.add((ICheckResult)cr);
                }
                errorMessage = BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            errorMessage = BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
lbl145:
        // 5 sources

        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(SynchronizeAfterMergeMeta.PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public SqlStatement getSqlStatements(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, IHopMetadataProvider metadataProvider) throws HopTransformException {
        SqlStatement retval;
        block18: {
            retval = new SqlStatement(transformMeta.getName(), this.databaseMeta, null);
            if (this.databaseMeta != null) {
                if (prev != null && prev.size() > 0) {
                    IValueMeta v;
                    int i;
                    RowMeta tableFields = new RowMeta();
                    if (this.keyLookup != null) {
                        for (i = 0; i < this.keyLookup.length; ++i) {
                            v = prev.searchValueMeta(this.keyStream[i]);
                            if (v == null) {
                                throw new HopTransformException("Unable to find field [" + this.keyStream[i] + "] in the input rows");
                            }
                            IValueMeta tableField = v.clone();
                            tableField.setName(this.keyLookup[i]);
                            tableFields.addValueMeta(tableField);
                        }
                    }
                    for (i = 0; i < this.updateLookup.length; ++i) {
                        v = prev.searchValueMeta(this.updateStream[i]);
                        if (v != null) {
                            IValueMeta vk = tableFields.searchValueMeta(this.updateStream[i]);
                            if (vk != null) continue;
                            IValueMeta tableField = v.clone();
                            tableField.setName(this.updateLookup[i]);
                            tableFields.addValueMeta(tableField);
                            continue;
                        }
                        throw new HopTransformException("Unable to find field [" + this.updateStream[i] + "] in the input rows");
                    }
                    if (!Utils.isEmpty((CharSequence)this.tableName)) {
                        Database db = new Database(loggingObject, variables, this.databaseMeta);
                        try {
                            String sql;
                            db.connect();
                            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(variables, this.schemaName, this.tableName);
                            String crTable = db.getDDL(schemaTable, (IRowMeta)tableFields, null, false, null, true);
                            String crIndex = "";
                            String[] idxFields = null;
                            if (this.keyLookup != null && this.keyLookup.length > 0) {
                                idxFields = new String[this.keyLookup.length];
                                for (int i2 = 0; i2 < this.keyLookup.length; ++i2) {
                                    idxFields[i2] = this.keyLookup[i2];
                                }
                            } else {
                                retval.setError(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.CheckResult.MissingKeyFields", (String[])new String[0]));
                            }
                            if (idxFields != null && idxFields.length > 0 && !db.checkIndexExists(this.schemaName, this.tableName, idxFields)) {
                                String indexname = "idx_" + this.tableName + "_lookup";
                                crIndex = db.getCreateIndexStatement(schemaTable, indexname, idxFields, false, false, false, true);
                            }
                            if ((sql = crTable + crIndex).length() == 0) {
                                retval.setSql(null);
                                break block18;
                            }
                            retval.setSql(sql);
                        }
                        catch (HopException e) {
                            retval.setError(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.ReturnValue.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                        }
                    } else {
                        retval.setError(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.ReturnValue.NoTableDefinedOnConnection", (String[])new String[0]));
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.ReturnValue.NotReceivingAnyFields", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.ReturnValue.NoConnectionDefined", (String[])new String[0]));
            }
        }
        return retval;
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (prev != null) {
            DatabaseImpact ii;
            IValueMeta v;
            int i;
            for (i = 0; i < this.keyLookup.length; ++i) {
                v = prev.searchValueMeta(this.keyStream[i]);
                ii = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.keyLookup[i], this.keyStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
            for (i = 0; i < this.updateLookup.length; ++i) {
                v = prev.searchValueMeta(this.updateStream[i]);
                ii = new DatabaseImpact(3, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), this.tableName, this.updateLookup[i], this.updateStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    public ITransform createTransform(TransformMeta transformMeta, SynchronizeAfterMergeData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new SynchronizeAfterMerge(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public SynchronizeAfterMergeData getTransformData() {
        return new SynchronizeAfterMergeData();
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRowMeta getRequiredFields(IVariables variables) throws HopException {
        String realTableName = variables.resolve(this.tableName);
        String realSchemaName = variables.resolve(this.schemaName);
        if (this.databaseMeta == null) throw new HopException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, variables, this.databaseMeta);
        try {
            db.connect();
            if (Utils.isEmpty((CharSequence)realTableName)) throw new HopException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.Exception.TableNotSpecified", (String[])new String[0]));
            if (db.checkTableExists(realSchemaName, realTableName)) {
                IRowMeta iRowMeta = db.getTableFieldsMeta(realSchemaName, realTableName);
                return iRowMeta;
            }
            try {
                throw new HopException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SynchronizeAfterMergeMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    private String[] normalizeAllocation(String[] oldAllocation, int length) {
        String[] newAllocation = null;
        if (oldAllocation.length < length) {
            newAllocation = new String[length];
            System.arraycopy(oldAllocation, 0, newAllocation, 0, oldAllocation.length);
        } else {
            newAllocation = oldAllocation;
        }
        return newAllocation;
    }

    private Boolean[] normalizeAllocation(Boolean[] oldAllocation, int length) {
        Boolean[] newAllocation = null;
        if (oldAllocation.length < length) {
            newAllocation = new Boolean[length];
            System.arraycopy(oldAllocation, 0, newAllocation, 0, oldAllocation.length);
            for (int i = 0; i < length; ++i) {
                if (newAllocation[i] != null) continue;
                newAllocation[i] = Boolean.TRUE;
            }
        } else {
            newAllocation = oldAllocation;
        }
        return newAllocation;
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        this.normalizeAllocationFields();
    }
}

