/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePainterExtension;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.PipelineUnitTestSetLocation;
import org.apache.hop.testing.gui.TestingGuiPlugin;

@ExtensionPoint(id="DrawGoldenDataSetOnTransformExtensionPoint", description="Draws a marker on top of a transform if it has a golden data set defined is for it", extensionPointId="PipelinePainterTransform")
public class DrawGoldenDataSetOnTransformExtensionPoint
implements IExtensionPoint<PipelinePainterExtension> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, PipelinePainterExtension ext) throws HopException {
        TransformMeta transformMeta = ext.transformMeta;
        PipelineMeta pipelineMeta = ext.pipelineMeta;
        PipelineUnitTest unitTest = TestingGuiPlugin.getCurrentUnitTest(pipelineMeta);
        if (unitTest != null) {
            this.drawGoldenSetMarker(ext, transformMeta, unitTest, ext.areaOwners);
        }
    }

    protected void drawGoldenSetMarker(PipelinePainterExtension ext, TransformMeta transformMeta, PipelineUnitTest unitTest, List<AreaOwner> areaOwners) {
        Boolean result;
        Map results;
        PipelineUnitTestSetLocation location = unitTest.findGoldenLocation(transformMeta.getName());
        if (location == null) {
            return;
        }
        String dataSetName = Const.NVL((String)location.getDataSetName(), (String)"");
        IGc gc = ext.gc;
        int iconSize = ext.iconSize;
        int x = ext.x1;
        int y = ext.y1;
        gc.setLineWidth(transformMeta.isSelected() ? 2 : 1);
        gc.setForeground(IGc.EColor.CRYSTAL);
        gc.setBackground(IGc.EColor.LIGHTGRAY);
        gc.setFont(IGc.EFont.GRAPH);
        Point textExtent = gc.textExtent(dataSetName);
        textExtent.x += 6;
        textExtent.y += 6;
        int arrowSize = textExtent.y;
        Point point = new Point(x + iconSize, y + (iconSize - textExtent.y) / 2);
        int[] arrow = new int[]{point.x, point.y + textExtent.y / 2, point.x + arrowSize, point.y, point.x + textExtent.x + arrowSize, point.y, point.x + textExtent.x + arrowSize, point.y + textExtent.y, point.x + arrowSize, point.y + textExtent.y};
        gc.fillPolygon(arrow);
        gc.drawPolygon(arrow);
        gc.drawText(dataSetName, point.x + arrowSize + 3, point.y + 3);
        areaOwners.add(new AreaOwner(AreaOwner.AreaType.CUSTOM, point.x, point.y, textExtent.x, textExtent.y, new Point(0, 0), (Object)"Golden_DataSet", (Object)transformMeta.getName()));
        if (ext.stateMap != null && (results = (Map)ext.stateMap.get("GoldenDataSetResults")) != null && (result = (Boolean)results.get(dataSetName)) != null) {
            try {
                int iconX = point.x + arrowSize + textExtent.x - 5;
                int iconY = point.y - 5;
                if (result.booleanValue()) {
                    gc.drawImage(IGc.EImage.SUCCESS, iconX, iconY, gc.getMagnification());
                } else {
                    gc.drawImage(IGc.EImage.FAILURE, iconX, iconY, gc.getMagnification());
                }
                areaOwners.add(new AreaOwner(AreaOwner.AreaType.CUSTOM, iconX + 16, iconY + 5, 16, 16, new Point(0, 0), (Object)"Golden_DataSet_Result", (Object)transformMeta.getName()));
            }
            catch (Exception e) {
                LogChannel.UI.logError("Error drawing golden data set result on pipeline", (Throwable)e);
            }
        }
    }
}

