/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import java.io.OutputStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.VariableValue;
import org.apache.hop.testing.xp.PipelineMetaModifier;

@ExtensionPoint(extensionPointId="PipelinePrepareExecution", id="ChangePipelineMetaPriorToExecutionExtensionPoint", description="Change the pipeline metadata in prior to execution preparation but only during execution in HopGui")
public class ChangePipelineMetaPriorToExecutionExtensionPoint
implements IExtensionPoint<IPipelineEngine<PipelineMeta>> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, IPipelineEngine<PipelineMeta> pipeline) throws HopException {
        PipelineMeta pipelineMeta = pipeline.getPipelineMeta();
        boolean runUnitTest = "Y".equalsIgnoreCase(variables.getVariable("__UnitTest_Run__"));
        if (!runUnitTest) {
            if (log.isDetailed()) {
                log.logDetailed("Not running a unit test...");
            }
            return;
        }
        String unitTestName = pipeline.getVariable("__UnitTest_Name__");
        if (StringUtils.isEmpty((String)unitTestName)) {
            if (log.isDetailed()) {
                log.logDetailed("Unit test disabled.");
            }
            return;
        }
        PipelineUnitTest unitTest = null;
        try {
            unitTest = (PipelineUnitTest)pipeline.getMetadataProvider().getSerializer(PipelineUnitTest.class).load(unitTestName);
        }
        catch (HopException e) {
            throw new HopException("Unable to load unit test '" + unitTestName + "'", (Throwable)e);
        }
        if (unitTest == null) {
            throw new HopException("Unit test '" + unitTestName + "' could not be found.");
        }
        PipelineMetaModifier modifier = new PipelineMetaModifier((IVariables)pipeline, pipelineMeta, unitTest);
        PipelineMeta copyPipelineMeta = modifier.getTestPipeline(log, (IVariables)pipeline, pipeline.getMetadataProvider());
        pipeline.setPipelineMeta(copyPipelineMeta);
        String[] parameters = copyPipelineMeta.listParameters();
        List<VariableValue> variableValues = unitTest.getVariableValues();
        for (VariableValue variableValue : variableValues) {
            String key = pipeline.resolve(variableValue.getKey());
            String value = pipeline.resolve(variableValue.getValue());
            if (StringUtils.isEmpty((String)key)) continue;
            if (Const.indexOfString((String)key, (String[])parameters) < 0) {
                pipeline.setVariable(key, value);
                continue;
            }
            pipeline.setParameterValue(key, value);
        }
        String testFilename = pipeline.resolve(unitTest.getFilename());
        if (!StringUtil.isEmpty((String)testFilename)) {
            try {
                OutputStream os = HopVfs.getOutputStream((String)testFilename, (boolean)false);
                os.write(XmlHandler.getXmlHeader().getBytes());
                os.write(copyPipelineMeta.getXml(variables).getBytes());
                os.close();
            }
            catch (Exception e) {
                throw new HopException("Error writing test filename to '" + testFilename + "'", (Throwable)e);
            }
        }
    }
}

