/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.util;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Result;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.UnitTestResult;
import org.apache.hop.testing.util.DataSetConst;
import org.apache.hop.testing.util.IExceptionEvaluator;
import org.apache.hop.testing.util.IPipelineResultEvaluator;
import org.apache.hop.testing.util.ITestResultsEvaluator;

public class UnitTestUtil {
    public static final PipelineMeta loadTestPipeline(PipelineUnitTest test, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        PipelineMeta unitTestPipelineMeta = null;
        String filename = test.calculateCompletePipelineFilename(variables);
        if (StringUtils.isNotEmpty((String)filename)) {
            unitTestPipelineMeta = new PipelineMeta(filename, metadataProvider, true, variables);
        }
        if (unitTestPipelineMeta == null) {
            throw new HopException("Unable to find a valid pipeline filename in unit test '" + test.getName() + "'");
        }
        unitTestPipelineMeta.setMetadataProvider(metadataProvider);
        return unitTestPipelineMeta;
    }

    public static final void executeUnitTest(PipelineUnitTest test, ILoggingObject parentObject, LogLevel logLevel, IHopMetadataProvider metadataProvider, IVariables variables, IPipelineResultEvaluator pipelineResultEvaluator, ITestResultsEvaluator testResultsEvaluator, IExceptionEvaluator exceptionEvaluator) throws HopException {
        PipelineMeta testPipelineMeta = null;
        try {
            testPipelineMeta = UnitTestUtil.loadTestPipeline(test, metadataProvider, variables);
            LocalPipelineEngine testPipeline = new LocalPipelineEngine(testPipelineMeta, variables, parentObject);
            testPipeline.initializeFrom(variables);
            testPipeline.setLogLevel(logLevel);
            testPipeline.setMetadataProvider(metadataProvider);
            testPipeline.setVariable("__UnitTest_DontShowUnitTestErrors__", "Y");
            testPipeline.setVariable("__UnitTest_Run__", "Y");
            testPipeline.setVariable("__UnitTest_Name__", test.getName());
            testPipeline.execute();
            testPipeline.waitUntilFinished();
            Result pipelineResult = testPipeline.getResult();
            pipelineResultEvaluator.evaluatePipelineResults((IPipelineEngine)testPipeline, pipelineResult);
            ArrayList<UnitTestResult> testResults = new ArrayList<UnitTestResult>();
            DataSetConst.validateTransformResultAgainstUnitTest((IPipelineEngine<PipelineMeta>)testPipeline, test, metadataProvider, testResults);
            testResultsEvaluator.evaluateTestResults((IPipelineEngine)testPipeline, testResults);
        }
        catch (HopException e) {
            exceptionEvaluator.evaluateTestException(test, testPipelineMeta, (Exception)((Object)e));
        }
    }
}

