/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.testing.DataSet;
import org.apache.hop.testing.DataSetField;
import org.apache.hop.testing.PipelineTweak;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.PipelineUnitTestFieldMapping;
import org.apache.hop.testing.PipelineUnitTestSetLocation;
import org.apache.hop.testing.PipelineUnitTestTweak;
import org.apache.hop.testing.xp.PipelineMetaModifier;
import org.apache.hop.testing.xp.WriteToDataSetExtensionPoint;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.SelectRowDialog;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.file.pipeline.context.HopGuiPipelineTransformContext;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.testing.EditRowsDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;

@GuiPlugin
public class TestingGuiPlugin {
    protected static Class<?> PKG = TestingGuiPlugin.class;
    public static final String ID_TOOLBAR_ITEM_UNIT_TEST_EDIT = "HopGuiPipelineGraph-ToolBar-20015-unit-test-edit";
    public static final String ID_TOOLBAR_ITEM_UNIT_TESTS_CREATE = "HopGuiPipelineGraph-ToolBar-20020-unit-tests-create";
    public static final String ID_TOOLBAR_ITEM_UNIT_TEST_DETACH = "HopGuiPipelineGraph-ToolBar-20030-unit-test-detach";
    public static final String ID_TOOLBAR_ITEM_UNIT_TESTS_DELETE = "HopGuiPipelineGraph-ToolBar-20050-unit-tests-delete";
    public static final String ID_TOOLBAR_UNIT_TESTS_LABEL = "HopGuiPipelineGraph-ToolBar-20000-unit-tests-label";
    public static final String ID_TOOLBAR_UNIT_TESTS_COMBO = "HopGuiPipelineGraph-ToolBar-20010-unit-tests-combo";
    private static TestingGuiPlugin instance = null;

    public static TestingGuiPlugin getInstance() {
        if (instance == null) {
            instance = new TestingGuiPlugin();
        }
        return instance;
    }

    public static String validateDataSet(DataSet dataSet, String previousName, List<String> setNames) {
        String message = null;
        String newName = dataSet.getName();
        if (StringUtil.isEmpty((String)newName)) {
            message = BaseMessages.getString(PKG, (String)"TestingGuiPlugin.DataSet.NoNameSpecified.Message", (String[])new String[0]);
        } else if (!StringUtil.isEmpty((String)previousName) && !previousName.equals(newName)) {
            message = BaseMessages.getString(PKG, (String)"TestingGuiPlugin.DataSet.RenamingOfADataSetsNotSupported.Message", (String[])new String[0]);
        } else if (StringUtil.isEmpty((String)previousName) && Const.indexOfString((String)newName, setNames) >= 0) {
            message = BaseMessages.getString(PKG, (String)"TestingGuiPlugin.DataSet.ADataSetWithNameExists.Message", (String[])new String[]{newName});
        }
        return message;
    }

    @GuiContextAction(id="pipeline-graph-transform-20200-define-input-data-set", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::TestingGuiPlugin.ContextAction.SetInputDataset.Name", tooltip="i18n::TestingGuiPlugin.ContextAction.SetInputDataset.Tooltip", image="set-input-dataset.svg", category="i18n::TestingGuiPlugin.Category", categoryOrder="8")
    public void setInputDataSet(HopGuiPipelineTransformContext context) {
        HopGui hopGui = HopGui.getInstance();
        IHopMetadataProvider metadataProvider = hopGui.getMetadataProvider();
        IVariables variables = context.getPipelineGraph().getVariables();
        PipelineMeta pipelineMeta = context.getPipelineMeta();
        TransformMeta transformMeta = context.getTransformMeta();
        if (this.checkTestPresent(hopGui, pipelineMeta)) {
            return;
        }
        PipelineUnitTest unitTest = TestingGuiPlugin.getCurrentUnitTest(pipelineMeta);
        try {
            DataSet dataSet;
            boolean changed;
            IHopMetadataSerializer setSerializer = metadataProvider.getSerializer(DataSet.class);
            List setNames = setSerializer.listObjectNames();
            Collections.sort(setNames);
            EnterSelectionDialog esd = new EnterSelectionDialog(hopGui.getShell(), setNames.toArray(new String[setNames.size()]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.SetInputDataset.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.SetInputDataset.Message", (String[])new String[0]));
            String setName = esd.open();
            if (setName != null && (changed = this.setInputDataSetOnTransform(variables, metadataProvider, pipelineMeta, transformMeta, unitTest, dataSet = (DataSet)setSerializer.load(setName)))) {
                context.getPipelineGraph().updateGui();
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.SetInputDataset.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.SetInputDataset.Error.Message", (String[])new String[0]), e);
        }
    }

    private boolean setInputDataSetOnTransform(IVariables variables, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, TransformMeta transformMeta, PipelineUnitTest unitTest, DataSet dataSet) throws HopPluginException, HopValueException, HopException {
        String setFieldName;
        IRowMeta transformFields;
        HopGui hopGui = HopGui.getInstance();
        IRowMeta setFields = dataSet.getSetRowMeta();
        try {
            transformFields = pipelineMeta.getTransformFields(variables, transformMeta);
        }
        catch (HopTransformException e) {
            transformFields = new RowMeta();
        }
        if (transformFields.isEmpty()) {
            transformFields = setFields.clone();
        }
        String[] transformFieldNames = transformFields.getFieldNames();
        String[] setFieldNames = setFields.getFieldNames();
        EnterMappingDialog mappingDialog = new EnterMappingDialog(hopGui.getShell(), setFieldNames, transformFieldNames);
        List mappings = mappingDialog.open();
        if (mappings == null) {
            return false;
        }
        RowMeta sortMeta = new RowMeta();
        sortMeta.addValueMeta((IValueMeta)new ValueMetaString(BaseMessages.getString(PKG, (String)"TestingGuiPlugin.SortOrder.Column.SetField", (String[])new String[0])));
        ArrayList<Object[]> sortData = new ArrayList<Object[]>();
        for (String setFieldName2 : setFieldNames) {
            sortData.add(new Object[]{setFieldName2});
        }
        EditRowsDialog orderDialog = new EditRowsDialog(hopGui.getShell(), 0, BaseMessages.getString(PKG, (String)"TestingGuiPlugin.SortOrder.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.SortOrder.Message", (String[])new String[0]), (IRowMeta)sortMeta, sortData);
        List<Object[]> orderMappings = orderDialog.open();
        if (orderMappings == null) {
            return false;
        }
        unitTest.removeInputAndGoldenDataSets(transformMeta.getName());
        PipelineUnitTestSetLocation inputLocation = new PipelineUnitTestSetLocation();
        unitTest.getInputDataSets().add(inputLocation);
        inputLocation.setTransformName(transformMeta.getName());
        inputLocation.setDataSetName(dataSet.getName());
        List<PipelineUnitTestFieldMapping> fieldMappings = inputLocation.getFieldMappings();
        fieldMappings.clear();
        for (SourceToTargetMapping mapping : mappings) {
            String transformFieldName = mapping.getTargetString(transformFieldNames);
            setFieldName = mapping.getSourceString(setFieldNames);
            fieldMappings.add(new PipelineUnitTestFieldMapping(transformFieldName, setFieldName));
        }
        ArrayList<String> setFieldOrder = new ArrayList<String>();
        for (Object[] orderMapping : orderMappings) {
            setFieldName = sortMeta.getString(orderMapping, 0);
            setFieldOrder.add(setFieldName);
        }
        inputLocation.setFieldOrder(setFieldOrder);
        this.saveUnitTest(variables, metadataProvider, unitTest, pipelineMeta);
        transformMeta.setChanged();
        return true;
    }

    @GuiContextAction(id="pipeline-graph-transform-20210-clear-input-data-set", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Delete, name="i18n::TestingGuiPlugin.ContextAction.ClearInputDataset.Name", tooltip="i18n::TestingGuiPlugin.ContextAction.ClearInputDataset.Message", image="clear-input-dataset.svg", category="i18n::TestingGuiPlugin.Category", categoryOrder="8")
    public void clearInputDataSet(HopGuiPipelineTransformContext context) {
        HopGui hopGui = HopGui.getInstance();
        PipelineMeta pipelineMeta = context.getPipelineMeta();
        TransformMeta transformMeta = context.getTransformMeta();
        IVariables variables = context.getPipelineGraph().getVariables();
        if (this.checkTestPresent(hopGui, pipelineMeta)) {
            return;
        }
        try {
            PipelineUnitTest currentUnitTest = TestingGuiPlugin.getCurrentUnitTest(pipelineMeta);
            PipelineUnitTestSetLocation inputLocation = currentUnitTest.findInputLocation(transformMeta.getName());
            if (inputLocation != null) {
                currentUnitTest.getInputDataSets().remove(inputLocation);
            }
            this.saveUnitTest(variables, hopGui.getMetadataProvider(), currentUnitTest, pipelineMeta);
            context.getPipelineGraph().updateGui();
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.ClearInputDataset.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.ClearInputDataset.Error.Message", (String[])new String[0]), e);
        }
    }

    private boolean checkTestPresent(HopGui hopGui, PipelineMeta pipelineMeta) {
        PipelineUnitTest activeTest = TestingGuiPlugin.getCurrentUnitTest(pipelineMeta);
        if (activeTest != null) {
            return false;
        }
        MessageBox box = new MessageBox(hopGui.getShell(), 34);
        box.setMessage(BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.CheckTestPresent.Message", (String[])new String[0]));
        box.setText(BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.CheckTestPresent.Header", (String[])new String[0]));
        box.open();
        return true;
    }

    @GuiContextAction(id="pipeline-graph-transform-20220-define-golden-data-set", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::TestingGuiPlugin.ContextAction.SetGoldenDataset.Name", tooltip="i18n::TestingGuiPlugin.ContextAction.SetGoldenDataset.Tooltip", image="set-golden-dataset.svg", category="i18n::TestingGuiPlugin.Category", categoryOrder="8")
    public void setGoldenDataSet(HopGuiPipelineTransformContext context) {
        PipelineMeta sourcePipelineMeta = context.getPipelineMeta();
        TransformMeta transformMeta = context.getTransformMeta();
        HopGuiPipelineGraph pipelineGraph = context.getPipelineGraph();
        IVariables variables = pipelineGraph.getVariables();
        HopGui hopGui = HopGui.getInstance();
        IHopMetadataProvider metadataProvider = hopGui.getMetadataProvider();
        if (this.checkTestPresent(hopGui, sourcePipelineMeta)) {
            return;
        }
        PipelineUnitTest unitTest = TestingGuiPlugin.getCurrentUnitTest(sourcePipelineMeta);
        try {
            DataSet dataSet;
            boolean changed;
            PipelineMetaModifier modifier = new PipelineMetaModifier(variables, sourcePipelineMeta, unitTest);
            PipelineMeta pipelineMeta = modifier.getTestPipeline(LogChannel.UI, variables, metadataProvider);
            IHopMetadataSerializer setSerializer = metadataProvider.getSerializer(DataSet.class);
            List setNames = setSerializer.listObjectNames();
            Collections.sort(setNames);
            EnterSelectionDialog esd = new EnterSelectionDialog(hopGui.getShell(), setNames.toArray(new String[setNames.size()]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.SetGoldenDataset.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.SetGoldenDataset.Message", (String[])new String[0]));
            String setName = esd.open();
            if (setName != null && (changed = this.setGoldenDataSetOnTransform(variables, metadataProvider, pipelineMeta, transformMeta, unitTest, dataSet = (DataSet)setSerializer.load(setName)))) {
                pipelineGraph.updateGui();
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.SetGoldenDataset.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.SetGoldenDataset.Error.Message", (String[])new String[0]), e);
        }
    }

    private boolean setGoldenDataSetOnTransform(IVariables variables, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, TransformMeta transformMeta, PipelineUnitTest unitTest, DataSet dataSet) throws HopPluginException, HopValueException, HopException {
        IRowMeta transformFields;
        try {
            transformFields = pipelineMeta.getPrevTransformFields(variables, transformMeta);
        }
        catch (HopTransformException e) {
            transformFields = new RowMeta();
        }
        IRowMeta setFields = dataSet.getSetRowMeta();
        String[] transformFieldNames = transformFields.getFieldNames();
        String[] setFieldNames = setFields.getFieldNames();
        EnterMappingDialog mappingDialog = new EnterMappingDialog(HopGui.getInstance().getShell(), transformFieldNames, setFieldNames);
        List mappings = mappingDialog.open();
        if (mappings == null) {
            return false;
        }
        RowMeta sortMeta = new RowMeta();
        sortMeta.addValueMeta((IValueMeta)new ValueMetaString(BaseMessages.getString(PKG, (String)"TestingGuiPlugin.SortOrder.Column.SetField", (String[])new String[0])));
        ArrayList<Object[]> sortData = new ArrayList<Object[]>();
        for (String setFieldName : setFieldNames) {
            sortData.add(new Object[]{setFieldName});
        }
        EditRowsDialog orderDialog = new EditRowsDialog(HopGui.getInstance().getShell(), 0, BaseMessages.getString(PKG, (String)"TestingGuiPlugin.SortOrder.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.SortOrder.Message", (String[])new String[0]), (IRowMeta)sortMeta, sortData);
        List<Object[]> orderMappings = orderDialog.open();
        if (orderMappings == null) {
            return false;
        }
        unitTest.removeInputAndGoldenDataSets(transformMeta.getName());
        PipelineUnitTestSetLocation goldenLocation = new PipelineUnitTestSetLocation();
        unitTest.getGoldenDataSets().add(goldenLocation);
        goldenLocation.setTransformName(transformMeta.getName());
        goldenLocation.setDataSetName(dataSet.getName());
        List<PipelineUnitTestFieldMapping> fieldMappings = goldenLocation.getFieldMappings();
        fieldMappings.clear();
        for (SourceToTargetMapping mapping : mappings) {
            fieldMappings.add(new PipelineUnitTestFieldMapping(mapping.getSourceString(transformFieldNames), mapping.getTargetString(setFieldNames)));
        }
        ArrayList<String> setFieldOrder = new ArrayList<String>();
        for (Object[] orderMapping : orderMappings) {
            setFieldOrder.add(sortMeta.getString(orderMapping, 0));
        }
        goldenLocation.setFieldOrder(setFieldOrder);
        this.saveUnitTest(variables, metadataProvider, unitTest, pipelineMeta);
        transformMeta.setChanged();
        return true;
    }

    @GuiContextAction(id="pipeline-graph-transform-20240-clear-golden-data-set", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Delete, name="i18n::TestingGuiPlugin.ContextAction.ClearGoldenDataset.Name", tooltip="i18n::TestingGuiPlugin.ContextAction.ClearGoldenDataset.Tooltip", image="clear-golden-dataset.svg", category="i18n::TestingGuiPlugin.Category", categoryOrder="8")
    public void clearGoldenDataSet(HopGuiPipelineTransformContext context) {
        HopGui hopGui = HopGui.getInstance();
        PipelineMeta pipelineMeta = context.getPipelineMeta();
        TransformMeta transformMeta = context.getTransformMeta();
        IVariables variables = context.getPipelineGraph().getVariables();
        if (this.checkTestPresent(hopGui, pipelineMeta)) {
            return;
        }
        try {
            PipelineUnitTest currentUnitTest = TestingGuiPlugin.getCurrentUnitTest(pipelineMeta);
            PipelineUnitTestSetLocation goldenLocation = currentUnitTest.findGoldenLocation(transformMeta.getName());
            if (goldenLocation != null) {
                currentUnitTest.getGoldenDataSets().remove(goldenLocation);
            }
            this.saveUnitTest(variables, hopGui.getMetadataProvider(), currentUnitTest, pipelineMeta);
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.ClearGoldenDataset.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.ClearGoldenDataset.Error.Message", (String[])new String[0]), e);
        }
        pipelineMeta.setChanged();
        context.getPipelineGraph().updateGui();
    }

    @GuiContextAction(id="pipeline-graph-transform-20400-clear-golden-data-set", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Delete, name="i18n::TestingGuiPlugin.ContextAction.CreateDataset.Name", tooltip="i18n::TestingGuiPlugin.ContextAction.CreateDataset.Tooltip", image="create-dataset.svg", category="i18n::TestingGuiPlugin.Category", categoryOrder="8")
    public void createDataSetFromTransform(HopGuiPipelineTransformContext context) {
        HopGui hopGui = HopGui.getInstance();
        IHopMetadataProvider metadataProvider = hopGui.getMetadataProvider();
        IVariables variables = context.getPipelineGraph().getVariables();
        TransformMeta transformMeta = context.getTransformMeta();
        PipelineMeta pipelineMeta = context.getPipelineMeta();
        try {
            DataSet dataSet = new DataSet();
            IRowMeta rowMeta = pipelineMeta.getTransformFields(variables, transformMeta);
            for (int i = 0; i < rowMeta.size(); ++i) {
                IValueMeta valueMeta = rowMeta.getValueMeta(i);
                String setFieldName = valueMeta.getName();
                DataSetField field = new DataSetField(setFieldName, valueMeta.getType(), valueMeta.getLength(), valueMeta.getPrecision(), valueMeta.getComments(), valueMeta.getFormatMask());
                dataSet.getFields().add(field);
            }
            MetadataManager manager = new MetadataManager(hopGui.getVariables(), hopGui.getMetadataProvider(), DataSet.class);
            if (manager.newMetadata((IHopMetadata)dataSet) != null) {
                PipelineUnitTest unitTest = TestingGuiPlugin.getCurrentUnitTest(pipelineMeta);
                if (unitTest == null) {
                    return;
                }
                MessageBox box = new MessageBox(hopGui.getShell(), 452);
                box.setText(BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.CreateDataset.DatasetType.Header", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.CreateDataset.DatasetType.Message", (String[])new String[]{dataSet.getName(), transformMeta.getName()}) + Const.CR + BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.CreateDataset.DatasetType.Answer1", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.CreateDataset.DatasetType.Answer2", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.CreateDataset.DatasetType.Answer3", (String[])new String[0]) + Const.CR);
                int answer = box.open();
                if ((answer & 0x40) != 0) {
                    this.setInputDataSetOnTransform(variables, metadataProvider, pipelineMeta, transformMeta, unitTest, dataSet);
                }
                if ((answer & 0x80) != 0) {
                    this.setGoldenDataSetOnTransform(variables, metadataProvider, pipelineMeta, transformMeta, unitTest, dataSet);
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.CreateDataset.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.CreateDataset.Error.Message", (String[])new String[0]), e);
        }
    }

    @GuiContextAction(id="pipeline-graph-transform-20500-write-transform-data-to-set", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Create, name="i18n::TestingGuiPlugin.ContextAction.Run.Name", tooltip="i18n::TestingGuiPlugin.ContextAction.Run.Tooltip", image="write-to-dataset.svg", category="i18n::TestingGuiPlugin.Category", categoryOrder="8")
    public void writeTransformDataToDataSet(HopGuiPipelineTransformContext context) {
        HopGui hopGui = HopGui.getInstance();
        IHopMetadataProvider metadataProvider = hopGui.getMetadataProvider();
        IVariables variables = context.getPipelineGraph().getVariables();
        TransformMeta transformMeta = context.getTransformMeta();
        PipelineMeta pipelineMeta = context.getPipelineMeta();
        if (pipelineMeta.hasChanged()) {
            MessageBox box = new MessageBox(hopGui.getShell(), 34);
            box.setText(BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.Run.SavePipelineDialog.Header", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.Run.SavePipelineDialog.Message", (String[])new String[0]));
            box.open();
            return;
        }
        try {
            IHopMetadataSerializer setSerializer = metadataProvider.getSerializer(DataSet.class);
            List setNames = setSerializer.listObjectNames();
            Collections.sort(setNames);
            EnterSelectionDialog esd = new EnterSelectionDialog(hopGui.getShell(), setNames.toArray(new String[setNames.size()]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.Run.ActionList.Item1", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.Run.ActionList.Item2", (String[])new String[0]));
            String setName = esd.open();
            if (setName == null) {
                return;
            }
            DataSet dataSet = (DataSet)setSerializer.load(setName);
            String[] setFields = new String[dataSet.getFields().size()];
            for (int i = 0; i < setFields.length; ++i) {
                setFields[i] = dataSet.getFields().get(i).getFieldName();
            }
            IRowMeta rowMeta = pipelineMeta.getTransformFields(variables, transformMeta);
            String[] transformFields = new String[rowMeta.size()];
            for (int i = 0; i < rowMeta.size(); ++i) {
                IValueMeta valueMeta = rowMeta.getValueMeta(i);
                transformFields[i] = valueMeta.getName();
            }
            EnterMappingDialog mappingDialog = new EnterMappingDialog(hopGui.getShell(), transformFields, setFields);
            List mapping = mappingDialog.open();
            if (mapping == null) {
                return;
            }
            WriteToDataSetExtensionPoint.transformsMap.put(pipelineMeta.getName(), transformMeta);
            WriteToDataSetExtensionPoint.mappingsMap.put(pipelineMeta.getName(), mapping);
            WriteToDataSetExtensionPoint.setsMap.put(pipelineMeta.getName(), dataSet);
            variables.setVariable("__UnitTest_WriteDataSet__", "Y");
            context.getPipelineGraph().start();
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.Run.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ContextAction.Run.Error.Message", (String[])new String[0]), e);
        }
    }

    private void saveUnitTest(IVariables variables, IHopMetadataProvider metadataProvider, PipelineUnitTest unitTest, PipelineMeta pipelineMeta) throws HopException {
        unitTest.setRelativeFilename(variables, pipelineMeta.getFilename());
        metadataProvider.getSerializer(PipelineUnitTest.class).save((IHopMetadata)unitTest);
    }

    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-20030-unit-test-detach", toolTip="i18n::TestingGuiPlugin.ToolbarElement.UnitTest.Detach.Tooltip", image="Test_tube_icon_detach.svg")
    public void detachUnitTest() {
        HopGui hopGui = HopGui.getInstance();
        HopGuiPipelineGraph pipelineGraph = HopGui.getActivePipelineGraph();
        if (pipelineGraph == null) {
            return;
        }
        try {
            Combo combo;
            PipelineMeta pipelineMeta = TestingGuiPlugin.getActivePipelineMeta();
            if (pipelineMeta == null) {
                return;
            }
            Map<String, Object> stateMap = TestingGuiPlugin.getStateMap(pipelineMeta);
            if (stateMap != null) {
                stateMap.remove("ActiveUnitTest");
            }
            if ((combo = this.getUnitTestsCombo()) != null) {
                combo.setText("");
            }
            pipelineGraph.updateGui();
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ToolbarElement.Detach.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ToolbarElement.Detach.Error.Message", (String[])new String[0]), e);
        }
    }

    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-20015-unit-test-edit", toolTip="i18n::TestingGuiPlugin.ToolbarElement.UnitTest.Edit.Tooltip", image="Test_tube_icon_edit.svg", separator=true)
    public void editUnitTest() {
        HopGui hopGui = HopGui.getInstance();
        PipelineMeta pipelineMeta = TestingGuiPlugin.getActivePipelineMeta();
        if (pipelineMeta == null) {
            return;
        }
        PipelineUnitTest unitTest = TestingGuiPlugin.getCurrentUnitTest(pipelineMeta);
        MetadataManager manager = new MetadataManager(hopGui.getVariables(), hopGui.getMetadataProvider(), PipelineUnitTest.class);
        if (manager.editMetadata(unitTest.getName())) {
            TestingGuiPlugin.refreshUnitTestsList();
            TestingGuiPlugin.selectUnitTest(pipelineMeta, unitTest);
        }
    }

    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-20020-unit-tests-create", toolTip="i18n::TestingGuiPlugin.ToolbarElement.UnitTest.Create.Tooltip", image="Test_tube_icon_create.svg", separator=true)
    public void createUnitTest() {
        HopGui hopGui = HopGui.getInstance();
        PipelineMeta pipelineMeta = TestingGuiPlugin.getActivePipelineMeta();
        if (pipelineMeta == null) {
            return;
        }
        MetadataManager manager = new MetadataManager(hopGui.getVariables(), hopGui.getMetadataProvider(), PipelineUnitTest.class);
        PipelineUnitTest test = (PipelineUnitTest)manager.newMetadata();
        if (test != null) {
            TestingGuiPlugin.refreshUnitTestsList();
            TestingGuiPlugin.selectUnitTest(pipelineMeta, test);
        }
    }

    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-20050-unit-tests-delete", toolTip="i18n::TestingGuiPlugin.ToolbarElement.UnitTest.Delete.Tooltip", image="Test_tube_icon_delete.svg", separator=true)
    public void deleteUnitTest() {
        HopGui hopGui = HopGui.getInstance();
        PipelineMeta pipelineMeta = TestingGuiPlugin.getActivePipelineMeta();
        if (pipelineMeta == null) {
            return;
        }
        Combo combo = this.getUnitTestsCombo();
        if (combo == null) {
            return;
        }
        if (StringUtils.isEmpty((String)combo.getText())) {
            return;
        }
        try {
            IHopMetadataSerializer testSerializer = hopGui.getMetadataProvider().getSerializer(PipelineUnitTest.class);
            PipelineUnitTest pipelineUnitTest = (PipelineUnitTest)testSerializer.load(combo.getText());
            if (pipelineUnitTest == null) {
                return;
            }
            MessageBox box = new MessageBox(hopGui.getShell(), 196);
            box.setMessage(BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ToolbarElement.Delete.Confirmation.Message", (String[])new String[]{pipelineUnitTest.getName()}));
            box.setText(BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ToolbarElement.Delete.Confirmation.Header", (String[])new String[0]));
            int answer = box.open();
            if ((answer & 0x40) == 0) {
                return;
            }
            this.detachUnitTest();
            testSerializer.delete(pipelineUnitTest.getName());
            TestingGuiPlugin.refreshUnitTestsList();
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ToolbarElement.Delete.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ToolbarElement.Delete.Error.Message", (String[])new String[0]), e);
        }
    }

    private Combo getUnitTestsCombo() {
        HopGuiPipelineGraph pipelineGraph = HopGui.getActivePipelineGraph();
        if (pipelineGraph == null) {
            return null;
        }
        Control control = (Control)pipelineGraph.getToolBarWidgets().getWidgetsMap().get(ID_TOOLBAR_UNIT_TESTS_COMBO);
        if (control != null && control instanceof Combo) {
            Combo combo = (Combo)control;
            return combo;
        }
        return null;
    }

    public static void refreshUnitTestsList() {
        HopGuiPipelineGraph pipelineGraph = HopGui.getActivePipelineGraph();
        if (pipelineGraph == null) {
            return;
        }
        pipelineGraph.getToolBarWidgets().refreshComboItemList(ID_TOOLBAR_UNIT_TESTS_COMBO);
    }

    public static void selectUnitTestInList(String name) {
        HopGuiPipelineGraph pipelineGraph = HopGui.getActivePipelineGraph();
        if (pipelineGraph == null) {
            return;
        }
        pipelineGraph.getToolBarWidgets().selectComboItem(ID_TOOLBAR_UNIT_TESTS_COMBO, name);
    }

    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-20000-unit-tests-label", type=GuiToolbarElementType.LABEL, label="i18n::TestingGuiPlugin.ToolbarElement.UnitTest.Label", toolTip="i18n::TestingGuiPlugin.ToolbarElement.UnitTest.Tooltip", separator=true)
    public void editPipelineUnitTest() {
        HopGui hopGui = HopGui.getInstance();
        Combo combo = this.getUnitTestsCombo();
        if (combo == null) {
            return;
        }
        String unitTestName = combo.getText();
        try {
            MetadataManager manager = new MetadataManager(hopGui.getVariables(), hopGui.getMetadataProvider(), PipelineUnitTest.class);
            if (manager.editMetadata(unitTestName)) {
                TestingGuiPlugin.refreshUnitTestsList();
                TestingGuiPlugin.selectUnitTestInList(unitTestName);
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ToolbarElement.UnitTest.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ToolbarElement.UnitTest.Error.Message", (String[])new String[]{unitTestName}), e);
        }
    }

    public static final PipelineMeta getActivePipelineMeta() {
        IHopFileTypeHandler handler = HopGui.getInstance().getActiveFileTypeHandler();
        if (handler == null || handler.getSubject() == null) {
            return null;
        }
        Object subject = handler.getSubject();
        if (!(subject instanceof PipelineMeta)) {
            return null;
        }
        PipelineMeta pipelineMeta = (PipelineMeta)subject;
        return pipelineMeta;
    }

    public List<String> getUnitTestsList(ILogChannel log, IHopMetadataProvider metadataProvider, String instanceId) throws Exception {
        ArrayList<String> names;
        Object guiPluginObject = GuiRegistry.getInstance().findGuiPluginObject(HopGui.getInstance().getId(), HopGuiPipelineGraph.class.getName(), instanceId);
        if (guiPluginObject == null) {
            return Collections.emptyList();
        }
        if (!(guiPluginObject instanceof HopGuiPipelineGraph)) {
            return Collections.emptyList();
        }
        HopGuiPipelineGraph pipelineGraph = (HopGuiPipelineGraph)guiPluginObject;
        IVariables variables = pipelineGraph.getVariables();
        PipelineMeta pipelineMeta = pipelineGraph.getPipelineMeta();
        IHopMetadataSerializer testSerializer = metadataProvider.getSerializer(PipelineUnitTest.class);
        if (pipelineMeta == null) {
            names = testSerializer.listObjectNames();
        } else {
            List tests = testSerializer.loadAll();
            names = new ArrayList<String>();
            for (PipelineUnitTest test : tests) {
                if (!test.matchesPipelineFilename(variables, pipelineMeta.getFilename())) continue;
                names.add(test.getName());
            }
        }
        Collections.sort(names);
        return names;
    }

    @GuiToolbarElement(root="HopGuiPipelineGraph-Toolbar", id="HopGuiPipelineGraph-ToolBar-20010-unit-tests-combo", type=GuiToolbarElementType.COMBO, comboValuesMethod="getUnitTestsList", extraWidth=200, toolTip="i18n::TestingGuiPlugin.ToolbarElement.GetUnitTestList.Tooltip")
    public void selectUnitTest() {
        HopGui hopGui = HopGui.getInstance();
        try {
            PipelineMeta pipelineMeta = TestingGuiPlugin.getActivePipelineMeta();
            if (pipelineMeta == null) {
                return;
            }
            IHopMetadataProvider metadataProvider = hopGui.getMetadataProvider();
            Combo combo = this.getUnitTestsCombo();
            if (combo == null) {
                return;
            }
            IHopMetadataSerializer testSerializer = metadataProvider.getSerializer(PipelineUnitTest.class);
            String testName = combo.getText();
            if (testName != null) {
                PipelineUnitTest unitTest = (PipelineUnitTest)testSerializer.load(testName);
                if (unitTest == null) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ToolbarElement.GetUnitTestList.Exception", (String[])new String[]{testName}));
                }
                TestingGuiPlugin.selectUnitTest(pipelineMeta, unitTest);
                hopGui.getActiveFileTypeHandler().updateGui();
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ToolbarElement.GetUnitTestList.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.ToolbarElement.GetUnitTestList.Error.Message", (String[])new String[0]), e);
        }
    }

    public static final void selectUnitTest(PipelineMeta pipelineMeta, PipelineUnitTest unitTest) {
        Map<String, Object> stateMap = TestingGuiPlugin.getStateMap(pipelineMeta);
        if (stateMap == null) {
            // empty if block
        }
        stateMap.put("ActiveUnitTest", unitTest);
        TestingGuiPlugin.selectUnitTestInList(unitTest.getName());
    }

    public static final Map<String, Object> getStateMap(PipelineMeta pipelineMeta) {
        for (TabItemHandler item : HopGui.getDataOrchestrationPerspective().getItems()) {
            if (!item.getTypeHandler().getSubject().equals(pipelineMeta)) continue;
            HopGuiPipelineGraph pipelineGraph = (HopGuiPipelineGraph)item.getTypeHandler();
            return pipelineGraph.getStateMap();
        }
        return null;
    }

    public static final PipelineUnitTest getCurrentUnitTest(PipelineMeta pipelineMeta) {
        Map<String, Object> stateMap = TestingGuiPlugin.getStateMap(pipelineMeta);
        if (stateMap == null) {
            return null;
        }
        PipelineUnitTest test = (PipelineUnitTest)stateMap.get("ActiveUnitTest");
        return test;
    }

    @GuiContextAction(id="pipeline-graph-transform-20800-enable-tweak-remove-transform", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::TestingGuiPlugin.ContextAction.RemoveFromTest.Name", tooltip="i18n::TestingGuiPlugin.ContextAction.RemoveFromTest.Tooltip", image="Test_tube_icon.svg", category="i18n::TestingGuiPlugin.Category", categoryOrder="8")
    public void enableTweakRemoveTransformInUnitTest(HopGuiPipelineTransformContext context) {
        IVariables variables = context.getPipelineGraph().getVariables();
        this.tweakRemoveTransformInUnitTest(variables, context.getPipelineMeta(), context.getTransformMeta(), true);
    }

    @GuiContextAction(id="pipeline-graph-transform-20810-disable-tweak-remove-transform", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::TestingGuiPlugin.ContextAction.IncludeInTest.Name", tooltip="i18n::TestingGuiPlugin.ContextAction.IncludeInTest.Tooltip", image="Test_tube_icon.svg", category="i18n::TestingGuiPlugin.Category", categoryOrder="8")
    public void disableTweakRemoveTransformInUnitTest(HopGuiPipelineTransformContext context) {
        this.tweakRemoveTransformInUnitTest(context.getPipelineGraph().getVariables(), context.getPipelineMeta(), context.getTransformMeta(), false);
    }

    public void tweakRemoveTransformInUnitTest(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, boolean enable) {
        this.tweakUnitTestTransform(variables, pipelineMeta, transformMeta, PipelineTweak.REMOVE_TRANSFORM, enable);
    }

    @GuiContextAction(id="pipeline-graph-transform-20820-enable-tweak-bypass-transform", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::TestingGuiPlugin.ContextAction.BypassInTest.Name", tooltip="i18n::TestingGuiPlugin.ContextAction.BypassInTest.Tooltip", image="Test_tube_icon.svg", category="i18n::TestingGuiPlugin.Category", categoryOrder="8")
    public void enableTweakBypassTransformInUnitTest(HopGuiPipelineTransformContext context) {
        this.tweakBypassTransformInUnitTest(context.getPipelineGraph().getVariables(), context.getPipelineMeta(), context.getTransformMeta(), true);
    }

    @GuiContextAction(id="pipeline-graph-transform-20830-disable-tweak-bypass-transform", parentId="HopGuiPipelineTransformContext", type=GuiActionType.Modify, name="i18n::TestingGuiPlugin.ContextAction.RemoveBypassInTest.Name", tooltip="i18n::TestingGuiPlugin.ContextAction.RemoveBypassInTest.Tooltip", image="Test_tube_icon.svg", category="i18n::TestingGuiPlugin.Category", categoryOrder="8")
    public void disableTweakBypassTransformInUnitTest(HopGuiPipelineTransformContext context) {
        this.tweakBypassTransformInUnitTest(context.getPipelineGraph().getVariables(), context.getPipelineMeta(), context.getTransformMeta(), false);
    }

    public void tweakBypassTransformInUnitTest(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, boolean enable) {
        this.tweakUnitTestTransform(variables, pipelineMeta, transformMeta, PipelineTweak.BYPASS_TRANSFORM, enable);
    }

    private void tweakUnitTestTransform(IVariables variables, PipelineMeta pipelineMeta, TransformMeta transformMeta, PipelineTweak tweak, boolean enable) {
        HopGui hopGui = HopGui.getInstance();
        IHopMetadataProvider metadataProvider = hopGui.getMetadataProvider();
        if (transformMeta == null || pipelineMeta == null) {
            return;
        }
        if (this.checkTestPresent(hopGui, pipelineMeta)) {
            return;
        }
        try {
            PipelineUnitTest unitTest = TestingGuiPlugin.getCurrentUnitTest(pipelineMeta);
            PipelineUnitTestTweak unitTestTweak = unitTest.findTweak(transformMeta.getName());
            if (unitTestTweak != null) {
                unitTest.getTweaks().remove(unitTestTweak);
            }
            if (enable) {
                unitTest.getTweaks().add(new PipelineUnitTestTweak(tweak, transformMeta.getName()));
            }
            this.saveUnitTest(variables, metadataProvider, unitTest, pipelineMeta);
            TestingGuiPlugin.selectUnitTest(pipelineMeta, unitTest);
            hopGui.getActiveFileTypeHandler().updateGui();
        }
        catch (Exception exception) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.TweakUnitTestTransform.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.TweakUnitTestTransform.Error.Message", (String[])new String[]{transformMeta.getName(), tweak.name()}), exception);
        }
    }

    public RowMetaAndData selectUnitTestFromAllTests() {
        HopGui hopGui = HopGui.getInstance();
        IHopMetadataProvider metadataProvider = hopGui.getMetadataProvider();
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((IValueMeta)new ValueMetaString("Unit test"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaString("Description"));
        rowMeta.addValueMeta((IValueMeta)new ValueMetaString("Filename"));
        ArrayList<RowMetaAndData> rows = new ArrayList<RowMetaAndData>();
        try {
            IHopMetadataSerializer testSerializer = metadataProvider.getSerializer(PipelineUnitTest.class);
            List testNames = testSerializer.listObjectNames();
            for (String testName : testNames) {
                PipelineUnitTest unitTest = (PipelineUnitTest)testSerializer.load(testName);
                Object[] row = RowDataUtil.allocateRowData((int)rowMeta.size());
                row[0] = testName;
                row[1] = unitTest.getDescription();
                row[2] = unitTest.getPipelineFilename();
                rows.add(new RowMetaAndData((IRowMeta)rowMeta, row));
            }
            SelectRowDialog dialog = new SelectRowDialog(hopGui.getShell(), (IVariables)new Variables(), 3184, rows);
            RowMetaAndData selection = dialog.open();
            if (selection != null) {
                return selection;
            }
            return null;
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.SelectUnitTestFromAllTests.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.SelectUnitTestFromAllTests.Error.Message", (String[])new String[0]), e);
            return null;
        }
    }

    public void openUnitTestPipeline(IVariables variables) {
        block5: {
            try {
                HopGui hopGui = HopGui.getInstance();
                IHopMetadataProvider metadataProvider = hopGui.getMetadataProvider();
                RowMetaAndData selection = this.selectUnitTestFromAllTests();
                if (selection == null) break block5;
                String filename = selection.getString(2, null);
                if (StringUtils.isNotEmpty((String)filename)) {
                    String unitTestName = selection.getString(0, null);
                    PipelineUnitTest targetTest = (PipelineUnitTest)metadataProvider.getSerializer(PipelineUnitTest.class).load(unitTestName);
                    if (targetTest != null) {
                        String completeFilename = targetTest.calculateCompletePipelineFilename(variables);
                        hopGui.fileDelegate.fileOpen(completeFilename);
                        PipelineMeta pipelineMeta = TestingGuiPlugin.getActivePipelineMeta();
                        if (pipelineMeta != null) {
                            this.switchUnitTest(targetTest, pipelineMeta);
                        }
                    }
                    break block5;
                }
                throw new HopException("No filename found in the selected test");
            }
            catch (Exception e) {
                new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.OpenUnitTestPipeline.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TestingGuiPlugin.OpenUnitTestPipeline.Error.Message", (String[])new String[0]), e);
            }
        }
    }

    public void switchUnitTest(PipelineUnitTest targetTest, PipelineMeta pipelineMeta) {
        try {
            TestingGuiPlugin.getInstance().detachUnitTest();
            TestingGuiPlugin.selectUnitTest(pipelineMeta, targetTest);
        }
        catch (Exception exception) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"ShowUnitTestMenuExtensionPoint.ErrorSwitchingUnitTest.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ShowUnitTestMenuExtensionPoint.ErrorSwitchingUnitTest.Message", (String[])new String[]{targetTest.getName()}), exception);
        }
        HopGui.getInstance().getActiveFileTypeHandler().updateGui();
    }

    public static List<PipelineUnitTest> findPipelineUnitTest(IVariables variables, PipelineMeta pipelineMeta, IHopMetadataProvider metadataProvider) {
        ArrayList<PipelineUnitTest> tests = new ArrayList<PipelineUnitTest>();
        try {
            IHopMetadataSerializer testSerializer = metadataProvider.getSerializer(PipelineUnitTest.class);
            if (StringUtils.isNotEmpty((String)pipelineMeta.getFilename())) {
                List allTests = testSerializer.loadAll();
                for (PipelineUnitTest test : allTests) {
                    if (!test.matchesPipelineFilename(variables, pipelineMeta.getFilename())) continue;
                    tests.add(test);
                }
            }
        }
        catch (Exception exception) {
            new ErrorDialog(HopGui.getInstance().getShell(), BaseMessages.getString(PKG, (String)"ShowUnitTestMenuExtensionPoint.ErrorFindingUnitTestsForPipeline.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ShowUnitTestMenuExtensionPoint.ErrorFindingUnitTestsForPipeline.Message", (String[])new String[0]), exception);
        }
        return tests;
    }
}

