/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.testing.DataSet;
import org.apache.hop.testing.PipelineUnitTestDatabaseReplacement;
import org.apache.hop.testing.PipelineUnitTestSetLocation;
import org.apache.hop.testing.PipelineUnitTestTweak;
import org.apache.hop.testing.TestType;
import org.apache.hop.testing.VariableValue;

@HopMetadata(key="unit-test", name="Pipeline Unit Test", description="This describes a test for a pipeline with alternative data sets as input from certain transform and testing output against golden data", image="Test_tube_icon.svg", documentationUrl="/metadata-types/pipeline-unit-test.html")
public class PipelineUnitTest
extends HopMetadataBase
implements Cloneable,
IHopMetadata {
    @HopMetadataProperty
    private String description;
    @HopMetadataProperty(key="pipeline_filename")
    protected String pipelineFilename;
    @HopMetadataProperty(key="input_data_sets")
    protected List<PipelineUnitTestSetLocation> inputDataSets = new ArrayList<PipelineUnitTestSetLocation>();
    @HopMetadataProperty(key="golden_data_sets")
    protected List<PipelineUnitTestSetLocation> goldenDataSets = new ArrayList<PipelineUnitTestSetLocation>();
    @HopMetadataProperty(key="trans_test_tweaks")
    protected List<PipelineUnitTestTweak> tweaks = new ArrayList<PipelineUnitTestTweak>();
    @HopMetadataProperty(key="test_type")
    protected TestType type = TestType.DEVELOPMENT;
    @HopMetadataProperty(key="persist_filename")
    protected String filename;
    @HopMetadataProperty
    protected String basePath = null;
    @HopMetadataProperty(key="database_replacements")
    protected List<PipelineUnitTestDatabaseReplacement> databaseReplacements = new ArrayList<PipelineUnitTestDatabaseReplacement>();
    @HopMetadataProperty
    protected List<VariableValue> variableValues = new ArrayList<VariableValue>();
    @HopMetadataProperty
    protected boolean autoOpening = true;

    public PipelineUnitTest() {
    }

    public PipelineUnitTest(String name, String description, String pipelineFilename, List<PipelineUnitTestSetLocation> inputDataSets, List<PipelineUnitTestSetLocation> goldenDataSets, List<PipelineUnitTestTweak> tweaks, TestType type, String filename, List<PipelineUnitTestDatabaseReplacement> databaseReplacements, boolean autoOpening) {
        this();
        this.name = name;
        this.description = description;
        this.pipelineFilename = pipelineFilename;
        this.inputDataSets = inputDataSets;
        this.goldenDataSets = goldenDataSets;
        this.tweaks = tweaks;
        this.type = type;
        this.filename = filename;
        this.databaseReplacements = databaseReplacements;
        this.autoOpening = autoOpening;
    }

    public PipelineUnitTestSetLocation findGoldenLocation(String transformName) {
        for (PipelineUnitTestSetLocation location : this.goldenDataSets) {
            if (!transformName.equalsIgnoreCase(location.getTransformName())) continue;
            return location;
        }
        return null;
    }

    public PipelineUnitTestSetLocation findInputLocation(String transformName) {
        for (PipelineUnitTestSetLocation location : this.inputDataSets) {
            if (!transformName.equalsIgnoreCase(location.getTransformName())) continue;
            return location;
        }
        return null;
    }

    public DataSet getGoldenDataSet(ILogChannel log, IHopMetadataProvider metadataProvider, PipelineUnitTestSetLocation location) throws HopException {
        String transformName = location.getTransformName();
        String goldenDataSetName = location.getDataSetName();
        try {
            if (goldenDataSetName == null) {
                throw new HopException("Unable to find golden data set for transform '" + transformName + "'");
            }
            DataSet goldenDataSet = (DataSet)metadataProvider.getSerializer(DataSet.class).load(goldenDataSetName);
            if (goldenDataSet == null) {
                throw new HopException("Unable to find golden data set '" + goldenDataSetName + "' for transform '" + transformName + "'");
            }
            return goldenDataSet;
        }
        catch (Exception e) {
            throw new HopException("Unable to retrieve sorted golden row data set '" + transformName + "'", (Throwable)e);
        }
    }

    public PipelineUnitTestTweak findTweak(String transformName) {
        for (PipelineUnitTestTweak tweak : this.tweaks) {
            if (tweak.getTransformName() == null || !tweak.getTransformName().equalsIgnoreCase(transformName)) continue;
            return tweak;
        }
        return null;
    }

    public void removeInputAndGoldenDataSets(String transformName) {
        Iterator<PipelineUnitTestSetLocation> iterator = this.inputDataSets.iterator();
        while (iterator.hasNext()) {
            PipelineUnitTestSetLocation inputLocation = iterator.next();
            if (!inputLocation.getTransformName().equalsIgnoreCase(transformName)) continue;
            iterator.remove();
        }
        iterator = this.goldenDataSets.iterator();
        while (iterator.hasNext()) {
            PipelineUnitTestSetLocation goldenLocation = iterator.next();
            if (!goldenLocation.getTransformName().equalsIgnoreCase(transformName)) continue;
            iterator.remove();
        }
    }

    public boolean matchesPipelineFilename(IVariables variables, String referencePipelineFilename) throws HopFileException, FileSystemException {
        if (Utils.isEmpty((CharSequence)referencePipelineFilename)) {
            return false;
        }
        FileObject pipelineFile = HopVfs.getFileObject((String)referencePipelineFilename);
        String pipelineUri = pipelineFile.getName().getURI();
        String testPipelineFilename = this.calculateCompletePipelineFilename(variables);
        if (Utils.isEmpty((CharSequence)testPipelineFilename)) {
            return false;
        }
        FileObject testPipelineFile = HopVfs.getFileObject((String)testPipelineFilename);
        String testPipelineUri = testPipelineFile.getName().getURI();
        return pipelineUri.equals(testPipelineUri);
    }

    public String calculateCompletePipelineFilename(IVariables variables) {
        if (StringUtil.isEmpty((String)this.pipelineFilename)) {
            return null;
        }
        if (this.pipelineFilename.startsWith("/") || this.pipelineFilename.startsWith("file:///")) {
            return variables.resolve(this.pipelineFilename);
        }
        String baseFilePath = variables.resolve(this.basePath);
        if (StringUtils.isEmpty((String)baseFilePath)) {
            baseFilePath = variables.getVariable("HOP_UNIT_TESTS_FOLDER");
        }
        if (StringUtils.isEmpty((String)baseFilePath)) {
            baseFilePath = "";
        }
        if (StringUtils.isNotEmpty((String)baseFilePath) && !baseFilePath.endsWith("/") && !baseFilePath.endsWith("\\")) {
            baseFilePath = baseFilePath + "/";
        }
        return baseFilePath + this.pipelineFilename;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPipelineFilename() {
        return this.pipelineFilename;
    }

    public void setPipelineFilename(String pipelineFilename) {
        this.pipelineFilename = pipelineFilename;
    }

    public List<PipelineUnitTestSetLocation> getInputDataSets() {
        return this.inputDataSets;
    }

    public void setInputDataSets(List<PipelineUnitTestSetLocation> inputDataSets) {
        this.inputDataSets = inputDataSets;
    }

    public List<PipelineUnitTestSetLocation> getGoldenDataSets() {
        return this.goldenDataSets;
    }

    public void setGoldenDataSets(List<PipelineUnitTestSetLocation> goldenDataSets) {
        this.goldenDataSets = goldenDataSets;
    }

    public List<PipelineUnitTestTweak> getTweaks() {
        return this.tweaks;
    }

    public void setTweaks(List<PipelineUnitTestTweak> tweaks) {
        this.tweaks = tweaks;
    }

    public TestType getType() {
        return this.type;
    }

    public void setType(TestType type) {
        this.type = type;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public List<PipelineUnitTestDatabaseReplacement> getDatabaseReplacements() {
        return this.databaseReplacements;
    }

    public void setDatabaseReplacements(List<PipelineUnitTestDatabaseReplacement> databaseReplacements) {
        this.databaseReplacements = databaseReplacements;
    }

    public List<VariableValue> getVariableValues() {
        return this.variableValues;
    }

    public void setVariableValues(List<VariableValue> variableValues) {
        this.variableValues = variableValues;
    }

    public boolean isAutoOpening() {
        return this.autoOpening;
    }

    public void setAutoOpening(boolean autoOpening) {
        this.autoOpening = autoOpening;
    }

    public void setRelativeFilename(IVariables variables, String referencePipelineFilename) throws HopException {
        if (StringUtils.isEmpty((String)referencePipelineFilename)) {
            return;
        }
        this.setPipelineFilename(referencePipelineFilename);
        String base = this.getBasePath();
        if (StringUtils.isEmpty((String)base)) {
            base = variables.getVariable("HOP_UNIT_TESTS_FOLDER");
        }
        if (StringUtils.isNotEmpty((String)(base = variables.resolve(base)))) {
            try {
                FileObject baseFolder = HopVfs.getFileObject((String)base);
                FileObject pipelineFile = HopVfs.getFileObject((String)referencePipelineFilename);
                for (FileObject parent = pipelineFile.getParent(); parent != null; parent = parent.getParent()) {
                    String baseFolderName;
                    String pipelineFileString;
                    if (!parent.equals(baseFolder) || !(pipelineFileString = pipelineFile.toString()).startsWith(baseFolderName = parent.toString())) continue;
                    String relativeFile = pipelineFileString.substring(baseFolderName.length());
                    String relativeFilename = relativeFile.startsWith("/") ? "." + relativeFile : "./" + relativeFile;
                    this.setPipelineFilename(relativeFilename);
                    LogChannel.GENERAL.logDetailed("Unit test '" + this.getName() + "' : saved relative path to pipeline: " + relativeFilename);
                }
            }
            catch (Exception e) {
                throw new HopException("Error calculating relative unit test file path", (Throwable)e);
            }
        }
    }
}

