/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.testing.DataSet;
import org.apache.hop.testing.PipelineUnitTestFieldMapping;
import org.apache.hop.testing.PipelineUnitTestSetLocation;

public class DataSetCsvUtil {
    private static void setValueFormats(IRowMeta rowMeta) {
        for (IValueMeta valueMeta : rowMeta.getValueMetaList()) {
            if (!StringUtils.isEmpty((String)valueMeta.getConversionMask())) continue;
            switch (valueMeta.getType()) {
                case 5: {
                    valueMeta.setConversionMask("0");
                    break;
                }
                case 1: {
                    valueMeta.setConversionMask("0.#");
                    break;
                }
                case 3: {
                    valueMeta.setConversionMask("yyyyMMdd-HHmmss.SSS");
                    break;
                }
            }
        }
    }

    public static final List<Object[]> getAllRows(IVariables variables, DataSet dataSet) throws HopException {
        IRowMeta setRowMeta = dataSet.getSetRowMeta();
        DataSetCsvUtil.setValueFormats(setRowMeta);
        String dataSetFilename = dataSet.getActualDataSetFilename(variables);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        ValueMetaString constantValueMeta = new ValueMetaString("constant");
        try {
            FileObject file = HopVfs.getFileObject((String)dataSetFilename);
            if (!file.exists()) {
                return rows;
            }
            try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(HopVfs.getInputStream((FileObject)file)));
                 CSVParser csvParser = new CSVParser((Reader)reader, DataSetCsvUtil.getCsvFormat(setRowMeta));){
                for (CSVRecord csvRecord : csvParser) {
                    if (csvRecord.getRecordNumber() <= 1L) continue;
                    Object[] row = RowDataUtil.allocateRowData((int)setRowMeta.size());
                    for (int i = 0; i < setRowMeta.size(); ++i) {
                        IValueMeta valueMeta = setRowMeta.getValueMeta(i).clone();
                        constantValueMeta.setConversionMetadata(valueMeta);
                        String value = csvRecord.get(i);
                        row[i] = valueMeta.convertData((IValueMeta)constantValueMeta, (Object)value);
                    }
                    rows.add(row);
                }
            }
            return rows;
        }
        catch (Exception e) {
            throw new HopException("Unable to get all rows for CSV data set '" + dataSet.getName() + "'", (Throwable)e);
        }
    }

    public static final List<Object[]> getAllRows(IVariables variables, ILogChannel log, DataSet dataSet, PipelineUnitTestSetLocation location) throws HopException {
        IRowMeta setRowMeta = dataSet.getSetRowMeta();
        IRowMeta outputRowMeta = dataSet.getMappedDataSetFieldsRowMeta(location);
        DataSetCsvUtil.setValueFormats(setRowMeta);
        String dataSetFilename = dataSet.getActualDataSetFilename(variables);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        ValueMetaString constantValueMeta = new ValueMetaString("constant");
        try {
            Object fieldMapping;
            FileObject file = HopVfs.getFileObject((String)dataSetFilename);
            if (!file.exists()) {
                return rows;
            }
            List<String> sortFields = location.getFieldOrder();
            List<PipelineUnitTestFieldMapping> fieldMappings = location.getFieldMappings();
            int[] dataSetFieldIndexes = new int[fieldMappings.size()];
            for (int i = 0; i < fieldMappings.size(); ++i) {
                fieldMapping = fieldMappings.get(i);
                String dataSetFieldName = ((PipelineUnitTestFieldMapping)fieldMapping).getDataSetFieldName();
                dataSetFieldIndexes[i] = setRowMeta.indexOfValue(dataSetFieldName);
            }
            InputStreamReader reader = new InputStreamReader(new BufferedInputStream(HopVfs.getInputStream((FileObject)file)));
            fieldMapping = null;
            try (CSVParser csvParser = new CSVParser((Reader)reader, CSVFormat.DEFAULT);){
                for (CSVRecord csvRecord : csvParser) {
                    if (csvRecord.getRecordNumber() <= 1L) continue;
                    Object[] row = RowDataUtil.allocateRowData((int)dataSetFieldIndexes.length);
                    for (int i = 0; i < dataSetFieldIndexes.length; ++i) {
                        int index = dataSetFieldIndexes[i];
                        IValueMeta valueMeta = setRowMeta.getValueMeta(index);
                        constantValueMeta.setConversionMetadata(valueMeta);
                        String value = csvRecord.get(index);
                        row[i] = valueMeta.convertData((IValueMeta)constantValueMeta, (Object)value);
                    }
                    rows.add(row);
                }
            }
            catch (Throwable throwable) {
                fieldMapping = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (fieldMapping != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)fieldMapping).addSuppressed(throwable);
                        }
                    } else {
                        ((Reader)reader).close();
                    }
                }
            }
            int[] sortIndexes = new int[sortFields.size()];
            for (int i = 0; i < sortIndexes.length; ++i) {
                sortIndexes[i] = outputRowMeta.indexOfValue(sortFields.get(i));
            }
            if (outputRowMeta.isEmpty()) {
                log.logError("WARNING: No field mappings selected for data set '" + dataSet.getName() + "', returning empty set of rows");
                return new ArrayList<Object[]>();
            }
            if (!sortFields.isEmpty()) {
                Collections.sort(rows, (o1, o2) -> {
                    try {
                        return outputRowMeta.compare(o1, o2, sortIndexes);
                    }
                    catch (HopValueException e) {
                        throw new RuntimeException("Unable to compare 2 rows", e);
                    }
                });
            }
            return rows;
        }
        catch (Exception e) {
            throw new HopException("Unable to get all rows for database data set '" + dataSet.getName() + "'", (Throwable)e);
        }
    }

    public static final void writeDataSetData(IVariables variables, DataSet dataSet, IRowMeta rowMeta, List<Object[]> rows) throws HopException {
        String dataSetFilename = dataSet.getActualDataSetFilename(variables);
        IRowMeta setRowMeta = rowMeta.clone();
        DataSetCsvUtil.setValueFormats(setRowMeta);
        OutputStream outputStream = null;
        BufferedWriter writer = null;
        CSVPrinter csvPrinter = null;
        try {
            FileObject file = HopVfs.getFileObject((String)dataSetFilename);
            outputStream = HopVfs.getOutputStream((FileObject)file, (boolean)false);
            writer = new BufferedWriter(new OutputStreamWriter(outputStream));
            CSVFormat csvFormat = DataSetCsvUtil.getCsvFormat(rowMeta);
            csvPrinter = new CSVPrinter((Appendable)writer, csvFormat);
            for (Object[] row : rows) {
                ArrayList<String> strings = new ArrayList<String>();
                for (int i = 0; i < setRowMeta.size(); ++i) {
                    IValueMeta valueMeta = setRowMeta.getValueMeta(i);
                    String string = valueMeta.getString(row[i]);
                    strings.add(string);
                }
                csvPrinter.printRecord(strings);
            }
            csvPrinter.flush();
        }
        catch (Exception e) {
            throw new HopException("Unable to write data set to file '" + dataSetFilename + "'", (Throwable)e);
        }
        finally {
            try {
                if (csvPrinter != null) {
                    csvPrinter.close();
                }
                if (writer != null) {
                    writer.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new HopException("Error closing file " + dataSetFilename + " : ", (Throwable)e);
            }
        }
    }

    public static CSVFormat getCsvFormat(IRowMeta rowMeta) {
        return CSVFormat.DEFAULT.withHeader(rowMeta.getFieldNames()).withQuote('\"').withQuoteMode(QuoteMode.MINIMAL);
    }
}

