/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mapping;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mapping.MappingIODefinition;
import org.apache.hop.pipeline.transforms.mapping.MappingParameters;
import org.apache.hop.pipeline.transforms.mapping.MappingValueRename;
import org.apache.hop.pipeline.transforms.mapping.SimpleMappingMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ColumnsResizer;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SimpleMappingDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = SimpleMappingMeta.class;
    private SimpleMappingMeta mappingMeta;
    private Label wlPath;
    private TextVar wPath;
    private Button wbBrowse;
    private CTabFolder wTabFolder;
    private PipelineMeta mappingPipelineMeta = null;
    protected boolean transModified;
    private ModifyListener lsMod;
    private int middle;
    private int margin;
    private MappingParameters mappingParameters;
    private MappingIODefinition inputMapping;
    private MappingIODefinition outputMapping;
    private List<ApplyChanges> changeList;

    public SimpleMappingDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.mappingMeta = (SimpleMappingMeta)((Object)in);
        this.transModified = false;
        this.mappingParameters = (MappingParameters)this.mappingMeta.getMappingParameters().clone();
        this.inputMapping = (MappingIODefinition)this.mappingMeta.getInputMapping().clone();
        this.outputMapping = (MappingIODefinition)this.mappingMeta.getOutputMapping().clone();
        this.changeList = new ArrayList<ApplyChanges>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.mappingMeta);
        this.lsMod = e -> this.mappingMeta.setChanged();
        this.changed = this.mappingMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.margin = this.props.getMargin();
        this.middle = this.props.getMiddlePct();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Shell.Title", (String[])new String[0]));
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        SimpleMappingDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)this.margin, null);
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, 0);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.fdTransformName.left = new FormAttachment(0, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 5);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wTransformName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.wlPath = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlPath);
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Pipeline.Label", (String[])new String[0]));
        FormData fdlTransformation = new FormData();
        fdlTransformation.left = new FormAttachment(0, 0);
        fdlTransformation.top = new FormAttachment((Control)spacer, 20);
        fdlTransformation.right = new FormAttachment(50, 0);
        this.wlPath.setLayoutData((Object)fdlTransformation);
        this.wbBrowse = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbBrowse);
        this.wbBrowse.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.right = new FormAttachment(100, 0);
        fdBrowse.top = new FormAttachment((Control)this.wlPath, Const.isOSX() ? 0 : 5);
        this.wbBrowse.setLayoutData((Object)fdBrowse);
        this.wbBrowse.addListener(13, e -> this.selectFilePipeline());
        this.wPath = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPath);
        FormData fdTransformation = new FormData();
        fdTransformation.left = new FormAttachment(0, 0);
        fdTransformation.top = new FormAttachment((Control)this.wlPath, 5);
        fdTransformation.right = new FormAttachment((Control)this.wbBrowse, -5);
        this.wPath.setLayoutData((Object)fdTransformation);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wTabFolder.setUnselectedCloseVisible(true);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wPath, 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        this.mappingMeta.setChanged(this.changed);
        this.wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"MAP.svg", (int)32, (int)32);
    }

    private void selectFilePipeline() {
        try {
            HopPipelineFileType fileType = new HopPipelineFileType();
            String filename = BaseDialog.presentFileDialog((boolean)false, (Shell)this.shell, (String[])fileType.getFilterExtensions(), (String[])fileType.getFilterNames(), (boolean)true);
            if (filename != null) {
                this.loadPipelineFile(filename);
                this.wPath.setText(filename);
            }
        }
        catch (HopException ex) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorLoadingPipeline.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorLoadingPipeline.DialogMessage", (String[])new String[0]), (Exception)((Object)ex));
        }
    }

    private void loadPipelineFile(String fname) throws HopException {
        this.mappingPipelineMeta = new PipelineMeta(this.variables.resolve(fname), this.metadataProvider, true, this.variables);
        this.mappingPipelineMeta.clearChanged();
    }

    void loadPipeline() throws HopException {
        String filename = this.wPath.getText();
        if (Utils.isEmpty((CharSequence)filename)) {
            return;
        }
        if (!filename.endsWith(".hpl")) {
            filename = filename + ".hpl";
            this.wPath.setText(filename);
        }
        this.loadPipelineFile(filename);
    }

    public void getData() {
        this.wPath.setText(Const.NVL((String)this.mappingMeta.getFilename(), (String)""));
        this.addParametersTab(this.mappingParameters);
        this.wTabFolder.setSelection(0);
        this.addInputMappingDefinitionTab(this.inputMapping, 0);
        this.addOutputMappingDefinitionTab(this.outputMapping, 1);
        try {
            this.loadPipeline();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void addOutputMappingDefinitionTab(MappingIODefinition definition, int index) {
        this.addMappingDefinitionTab(definition, index + 1, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.OutputTab.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.OutputTab.Tooltip", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.OutputTab.column.SourceField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.OutputTab.column.TargetField", (String[])new String[0]), false);
    }

    private void addInputMappingDefinitionTab(MappingIODefinition definition, int index) {
        this.addMappingDefinitionTab(definition, index + 1, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.InputTab.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.InputTab.Tooltip", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.InputTab.column.SourceField", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.InputTab.column.TargetField", (String[])new String[0]), true);
    }

    private void addParametersTab(MappingParameters parameters) {
        CTabItem wParametersTab = new CTabItem(this.wTabFolder, 0);
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.Title", (String[])new String[0]));
        wParametersTab.setToolTipText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.Tooltip", (String[])new String[0]));
        Composite wParametersComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wParametersComposite);
        FormLayout parameterTabLayout = new FormLayout();
        parameterTabLayout.marginWidth = 15;
        parameterTabLayout.marginHeight = 15;
        wParametersComposite.setLayout((Layout)parameterTabLayout);
        Button wInheritAll = new Button(wParametersComposite, 32);
        wInheritAll.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.InheritAll", (String[])new String[0]));
        this.props.setLook((Control)wInheritAll);
        FormData fdInheritAll = new FormData();
        fdInheritAll.bottom = new FormAttachment(100, 0);
        fdInheritAll.left = new FormAttachment(0, 0);
        fdInheritAll.right = new FormAttachment(100, -30);
        wInheritAll.setLayoutData((Object)fdInheritAll);
        wInheritAll.setSelection(parameters.isInheritingAllVariables());
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.column.Variable", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Parameters.column.ValueOrField", (String[])new String[0]), 1, false, false)};
        colinfo[1].setUsingVariables(true);
        TableView wMappingParameters = new TableView(this.variables, wParametersComposite, 67588, colinfo, parameters.getVariable().length, false, this.lsMod, this.props, false);
        this.props.setLook((Control)wMappingParameters);
        FormData fdMappings = new FormData();
        fdMappings.left = new FormAttachment(0, 0);
        fdMappings.right = new FormAttachment(100, 0);
        fdMappings.top = new FormAttachment(0, 0);
        fdMappings.bottom = new FormAttachment((Control)wInheritAll, -10);
        wMappingParameters.setLayoutData((Object)fdMappings);
        wMappingParameters.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 50, 50}));
        for (int i = 0; i < parameters.getVariable().length; ++i) {
            TableItem tableItem = wMappingParameters.table.getItem(i);
            tableItem.setText(1, parameters.getVariable()[i]);
            tableItem.setText(2, parameters.getInputField()[i]);
        }
        wMappingParameters.setRowNums();
        wMappingParameters.optWidth(true);
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wParametersComposite.setLayoutData((Object)fdParametersComposite);
        wParametersComposite.layout();
        wParametersTab.setControl((Control)wParametersComposite);
        this.changeList.add(new MappingParametersTab(wMappingParameters, wInheritAll, parameters));
    }

    public static String[] getMappingTransforms(PipelineMeta mappingPipelineMeta, boolean mappingInput) {
        ArrayList<TransformMeta> transforms = new ArrayList<TransformMeta>();
        for (TransformMeta transformMeta : mappingPipelineMeta.getTransforms()) {
            if (mappingInput && transformMeta.getTransformPluginId().equals("MappingInput")) {
                transforms.add(transformMeta);
            }
            if (mappingInput || !transformMeta.getTransformPluginId().equals("MappingOutput")) continue;
            transforms.add(transformMeta);
        }
        String[] transformnames = new String[transforms.size()];
        for (int i = 0; i < transformnames.length; ++i) {
            transformnames[i] = ((TransformMeta)transforms.get(i)).getName();
        }
        return transformnames;
    }

    public IRowMeta getFieldsFromTransform(boolean parent, boolean input) throws HopException {
        if (input) {
            if (parent) {
                return this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
            }
            if (this.mappingPipelineMeta == null) {
                throw new HopException(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.Exception.NoMappingSpecified", (String[])new String[0]));
            }
            TransformMeta mappingInputTransformMeta = this.mappingPipelineMeta.findMappingInputTransform(null);
            return this.mappingPipelineMeta.getTransformFields(this.variables, mappingInputTransformMeta);
        }
        TransformMeta mappingOutputTransformMeta = this.mappingPipelineMeta.findMappingOutputTransform(null);
        return this.mappingPipelineMeta.getTransformFields(this.variables, mappingOutputTransformMeta);
    }

    private void addMappingDefinitionTab(final MappingIODefinition definition, int index, String tabTitle, String tabTooltip, String sourceColumnLabel, String targetColumnLabel, final boolean input) {
        CTabItem wTab = index >= this.wTabFolder.getItemCount() ? new CTabItem(this.wTabFolder, 64) : new CTabItem(this.wTabFolder, 64, index);
        this.setMappingDefinitionTabNameAndToolTip(wTab, tabTitle, tabTooltip, definition, input);
        Composite wInputComposite = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)wInputComposite);
        FormLayout tabLayout = new FormLayout();
        tabLayout.marginWidth = 15;
        tabLayout.marginHeight = 15;
        wInputComposite.setLayout((Layout)tabLayout);
        Button wbEnterMapping = new Button(wInputComposite, 8);
        this.props.setLook((Control)wbEnterMapping);
        if (input) {
            wbEnterMapping.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.button.EnterMapping", (String[])new String[0]));
        } else {
            wbEnterMapping.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.button.GetFields", (String[])new String[0]));
        }
        FormData fdbEnterMapping = new FormData();
        fdbEnterMapping.bottom = new FormAttachment(100);
        fdbEnterMapping.right = new FormAttachment(100);
        wbEnterMapping.setLayoutData((Object)fdbEnterMapping);
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(sourceColumnLabel, 1, false, false), new ColumnInfo(targetColumnLabel, 1, false, false)};
        final TableView wFieldMappings = new TableView(this.variables, wInputComposite, 67588, colinfo, 1, false, this.lsMod, this.props, false);
        this.props.setLook((Control)wFieldMappings);
        FormData fdMappings = new FormData();
        fdMappings.left = new FormAttachment(0);
        fdMappings.right = new FormAttachment(100);
        fdMappings.top = new FormAttachment(0);
        fdMappings.bottom = new FormAttachment((Control)wbEnterMapping, -10);
        wFieldMappings.setLayoutData((Object)fdMappings);
        wFieldMappings.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 50, 50}));
        for (MappingValueRename valueRename : definition.getValueRenames()) {
            TableItem tableItem = new TableItem(wFieldMappings.table, 0);
            tableItem.setText(1, Const.NVL((String)valueRename.getSourceValueName(), (String)""));
            tableItem.setText(2, Const.NVL((String)valueRename.getTargetValueName(), (String)""));
        }
        wFieldMappings.removeEmptyRows();
        wFieldMappings.setRowNums();
        wFieldMappings.optWidth(true);
        wbEnterMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    if (input) {
                        IRowMeta sourceRowMeta = SimpleMappingDialog.this.getFieldsFromTransform(true, input);
                        IRowMeta targetRowMeta = SimpleMappingDialog.this.getFieldsFromTransform(false, input);
                        String[] sourceFields = sourceRowMeta.getFieldNames();
                        String[] targetFields = targetRowMeta.getFieldNames();
                        EnterMappingDialog dialog = new EnterMappingDialog(SimpleMappingDialog.this.shell, sourceFields, targetFields);
                        List mappings = dialog.open();
                        if (mappings != null) {
                            wFieldMappings.clearAll(false);
                            definition.getValueRenames().clear();
                            for (int i = 0; i < mappings.size(); ++i) {
                                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                                TableItem item = new TableItem(wFieldMappings.table, 0);
                                item.setText(1, mapping.getSourceString(sourceFields));
                                item.setText(2, mapping.getTargetString(targetFields));
                                String source = input ? item.getText(1) : item.getText(2);
                                String target = input ? item.getText(2) : item.getText(1);
                                definition.getValueRenames().add(new MappingValueRename(source, target));
                            }
                            wFieldMappings.removeEmptyRows();
                            wFieldMappings.setRowNums();
                            wFieldMappings.optWidth(true);
                        }
                    } else {
                        IRowMeta sourceRowMeta = SimpleMappingDialog.this.getFieldsFromTransform(true, input);
                        BaseTransformDialog.getFieldsFromPrevious((IRowMeta)sourceRowMeta, (TableView)wFieldMappings, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
                    }
                }
                catch (HopException e) {
                    new ErrorDialog(SimpleMappingDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SimpleMappingDialog.Exception.ErrorGettingMappingSourceAndTargetFields", (String[])new String[]{e.toString()}), (Exception)((Object)e));
                }
            }
        });
        if (input) {
            Button wRenameOutput = new Button(wInputComposite, 32);
            this.props.setLook((Control)wRenameOutput);
            wRenameOutput.setText(BaseMessages.getString(PKG, (String)"SimpleMappingDialog.input.RenamingOnOutput", (String[])new String[0]));
            FormData fdRenameOutput = new FormData();
            fdRenameOutput.top = new FormAttachment((Control)wFieldMappings, 10);
            fdRenameOutput.left = new FormAttachment(0, 0);
            wRenameOutput.setLayoutData((Object)fdRenameOutput);
            wRenameOutput.setSelection(definition.isRenamingOnOutput());
            wRenameOutput.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    definition.setRenamingOnOutput(!definition.isRenamingOnOutput());
                }
            });
        }
        FormData fdParametersComposite = new FormData();
        fdParametersComposite.left = new FormAttachment(0, 0);
        fdParametersComposite.top = new FormAttachment(0, 0);
        fdParametersComposite.right = new FormAttachment(100, 0);
        fdParametersComposite.bottom = new FormAttachment(100, 0);
        wInputComposite.setLayoutData((Object)fdParametersComposite);
        wInputComposite.layout();
        wTab.setControl((Control)wInputComposite);
        MappingDefinitionTab applyChanges = new MappingDefinitionTab(definition, wFieldMappings);
        this.changeList.add(applyChanges);
        this.wTabFolder.setSelection(wTab);
    }

    private void setMappingDefinitionTabNameAndToolTip(CTabItem wTab, String tabTitle, String tabTooltip, MappingIODefinition definition, boolean input) {
        String transformName = input ? definition.getInputTransformName() : definition.getOutputTransformName();
        String description = definition.getDescription();
        if (Utils.isEmpty((CharSequence)transformName)) {
            wTab.setText(tabTitle);
        } else {
            wTab.setText(tabTitle + " : " + transformName);
        }
        String tooltip = tabTooltip;
        if (!Utils.isEmpty((CharSequence)transformName)) {
            tooltip = tooltip + Const.CR + Const.CR + transformName;
        }
        if (!Utils.isEmpty((CharSequence)description)) {
            tooltip = tooltip + Const.CR + Const.CR + description;
        }
        wTab.setToolTipText(tooltip);
    }

    private void cancel() {
        this.transformName = null;
        this.mappingMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        try {
            this.loadPipeline();
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorLoadingSpecifiedPipeline.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SimpleMappingDialog.ErrorLoadingSpecifiedPipeline.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.mappingMeta.setFilename(this.wPath.getText());
        this.collectInformation();
        this.mappingMeta.setMappingParameters(this.mappingParameters);
        this.mappingMeta.setInputMapping(this.inputMapping);
        this.mappingMeta.setOutputMapping(this.outputMapping);
        this.mappingMeta.setChanged(true);
        this.dispose();
    }

    private void collectInformation() {
        for (ApplyChanges applyChanges : this.changeList) {
            applyChanges.applyChanges();
        }
    }

    private class MappingDefinitionTab
    implements ApplyChanges {
        private MappingIODefinition definition;
        private TableView wFieldMappings;

        public MappingDefinitionTab(MappingIODefinition definition, TableView fieldMappings) {
            this.definition = definition;
            this.wFieldMappings = fieldMappings;
        }

        @Override
        public void applyChanges() {
            int nrLines = this.wFieldMappings.nrNonEmpty();
            this.definition.getValueRenames().clear();
            for (int i = 0; i < nrLines; ++i) {
                TableItem item = this.wFieldMappings.getNonEmpty(i);
                this.definition.getValueRenames().add(new MappingValueRename(item.getText(1), item.getText(2)));
            }
        }
    }

    private class MappingParametersTab
    implements ApplyChanges {
        private TableView wMappingParameters;
        private MappingParameters parameters;
        private Button wInheritAll;

        public MappingParametersTab(TableView wMappingParameters, Button wInheritAll, MappingParameters parameters) {
            this.wMappingParameters = wMappingParameters;
            this.wInheritAll = wInheritAll;
            this.parameters = parameters;
        }

        @Override
        public void applyChanges() {
            int nrLines = this.wMappingParameters.nrNonEmpty();
            String[] variables = new String[nrLines];
            String[] inputFields = new String[nrLines];
            this.parameters.setVariable(variables);
            this.parameters.setInputField(inputFields);
            for (int i = 0; i < nrLines; ++i) {
                TableItem item = this.wMappingParameters.getNonEmpty(i);
                this.parameters.getVariable()[i] = item.getText(1);
                this.parameters.getInputField()[i] = item.getText(2);
            }
            this.parameters.setInheritingAllVariables(this.wInheritAll.getSelection());
        }
    }

    private static interface ApplyChanges {
        public void applyChanges();
    }
}

