/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.internal.StringUtils;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.internal.Utils;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.resource.AutoValue_Resource;

@Immutable
public abstract class Resource {
    static final int MAX_LENGTH = 255;
    private static final String OC_RESOURCE_TYPE_ENV = "OC_RESOURCE_TYPE";
    private static final String OC_RESOURCE_LABELS_ENV = "OC_RESOURCE_LABELS";
    private static final String LABEL_LIST_SPLITTER = ",";
    private static final String LABEL_KEY_VALUE_SPLITTER = "=";
    private static final String ERROR_MESSAGE_INVALID_CHARS = " should be a ASCII string with a length greater than 0 and not exceed 255 characters.";
    private static final String ERROR_MESSAGE_INVALID_VALUE = " should be a ASCII string with a length not exceed 255 characters.";
    @Nullable
    private static final String ENV_TYPE = Resource.parseResourceType(System.getenv("OC_RESOURCE_TYPE"));
    private static final Map<String, String> ENV_LABEL_MAP = Resource.parseResourceLabels(System.getenv("OC_RESOURCE_LABELS"));

    Resource() {
    }

    @Nullable
    public abstract String getType();

    public abstract Map<String, String> getLabels();

    public static Resource createFromEnvironmentVariables() {
        return Resource.createInternal(ENV_TYPE, ENV_LABEL_MAP);
    }

    public static Resource create(@Nullable String type, Map<String, String> labels) {
        return Resource.createInternal(type, Collections.unmodifiableMap(new LinkedHashMap<String, String>(Utils.checkNotNull(labels, "labels"))));
    }

    @Nullable
    public static Resource mergeResources(List<Resource> resources) {
        Resource currentResource = null;
        for (Resource resource : resources) {
            currentResource = Resource.merge(currentResource, resource);
        }
        return currentResource;
    }

    private static Resource createInternal(@Nullable String type, Map<String, String> labels) {
        return new AutoValue_Resource(type, labels);
    }

    @Nullable
    static String parseResourceType(@Nullable String rawEnvType) {
        if (rawEnvType != null && !rawEnvType.isEmpty()) {
            Utils.checkArgument(Resource.isValidAndNotEmpty(rawEnvType), "Type should be a ASCII string with a length greater than 0 and not exceed 255 characters.");
            return rawEnvType.trim();
        }
        return rawEnvType;
    }

    static Map<String, String> parseResourceLabels(@Nullable String rawEnvLabels) {
        String[] rawLabels;
        if (rawEnvLabels == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        for (String rawLabel : rawLabels = rawEnvLabels.split(LABEL_LIST_SPLITTER, -1)) {
            String[] keyValuePair = rawLabel.split(LABEL_KEY_VALUE_SPLITTER, -1);
            if (keyValuePair.length != 2) continue;
            String key = keyValuePair[0].trim();
            String value = keyValuePair[1].trim().replaceAll("^\"|\"$", "");
            Utils.checkArgument(Resource.isValidAndNotEmpty(key), "Label key should be a ASCII string with a length greater than 0 and not exceed 255 characters.");
            Utils.checkArgument(Resource.isValid(value), "Label value should be a ASCII string with a length not exceed 255 characters.");
            labels.put(key, value);
        }
        return Collections.unmodifiableMap(labels);
    }

    @Nullable
    private static Resource merge(@Nullable Resource resource, @Nullable Resource otherResource) {
        if (otherResource == null) {
            return resource;
        }
        if (resource == null) {
            return otherResource;
        }
        String mergedType = resource.getType() != null ? resource.getType() : otherResource.getType();
        LinkedHashMap<String, String> mergedLabelMap = new LinkedHashMap<String, String>(otherResource.getLabels());
        for (Map.Entry<String, String> entry : resource.getLabels().entrySet()) {
            mergedLabelMap.put(entry.getKey(), entry.getValue());
        }
        return Resource.createInternal(mergedType, Collections.unmodifiableMap(mergedLabelMap));
    }

    private static boolean isValid(String name) {
        return name.length() <= 255 && StringUtils.isPrintableString(name);
    }

    private static boolean isValidAndNotEmpty(String name) {
        return !name.isEmpty() && Resource.isValid(name);
    }
}

