/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.common;

import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.annotation.concurrent.Immutable;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.common.AutoValue_Timestamp;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.common.Duration;
import org.apache.beam.vendor.grpc.v1p36p0.io.opencensus.common.TimeUtils;

@Immutable
public abstract class Timestamp
implements Comparable<Timestamp> {
    Timestamp() {
    }

    public static Timestamp create(long seconds, int nanos) {
        if (seconds < -315576000000L) {
            throw new IllegalArgumentException("'seconds' is less than minimum (-315576000000): " + seconds);
        }
        if (seconds > 315576000000L) {
            throw new IllegalArgumentException("'seconds' is greater than maximum (315576000000): " + seconds);
        }
        if (nanos < 0) {
            throw new IllegalArgumentException("'nanos' is less than zero: " + nanos);
        }
        if (nanos > 999999999) {
            throw new IllegalArgumentException("'nanos' is greater than maximum (999999999): " + nanos);
        }
        return new AutoValue_Timestamp(seconds, nanos);
    }

    public static Timestamp fromMillis(long epochMilli) {
        long secs = Timestamp.floorDiv(epochMilli, 1000L);
        int mos = (int)Timestamp.floorMod(epochMilli, 1000L);
        return Timestamp.create(secs, (int)((long)mos * 1000000L));
    }

    public abstract long getSeconds();

    public abstract int getNanos();

    public Timestamp addNanos(long nanosToAdd) {
        return this.plus(0L, nanosToAdd);
    }

    public Timestamp addDuration(Duration duration) {
        return this.plus(duration.getSeconds(), duration.getNanos());
    }

    public Duration subtractTimestamp(Timestamp timestamp) {
        long durationSeconds = this.getSeconds() - timestamp.getSeconds();
        int durationNanos = this.getNanos() - timestamp.getNanos();
        if (durationSeconds < 0L && durationNanos > 0) {
            ++durationSeconds;
            durationNanos = (int)((long)durationNanos - 1000000000L);
        } else if (durationSeconds > 0L && durationNanos < 0) {
            --durationSeconds;
            durationNanos = (int)((long)durationNanos + 1000000000L);
        }
        return Duration.create(durationSeconds, durationNanos);
    }

    @Override
    public int compareTo(Timestamp otherTimestamp) {
        int cmp = TimeUtils.compareLongs(this.getSeconds(), otherTimestamp.getSeconds());
        if (cmp != 0) {
            return cmp;
        }
        return TimeUtils.compareLongs(this.getNanos(), otherTimestamp.getNanos());
    }

    private Timestamp plus(long secondsToAdd, long nanosToAdd) {
        if ((secondsToAdd | nanosToAdd) == 0L) {
            return this;
        }
        long epochSec = TimeUtils.checkedAdd(this.getSeconds(), secondsToAdd);
        epochSec = TimeUtils.checkedAdd(epochSec, nanosToAdd / 1000000000L);
        long nanoAdjustment = (long)this.getNanos() + (nanosToAdd %= 1000000000L);
        return Timestamp.ofEpochSecond(epochSec, nanoAdjustment);
    }

    private static Timestamp ofEpochSecond(long epochSecond, long nanoAdjustment) {
        long secs = TimeUtils.checkedAdd(epochSecond, Timestamp.floorDiv(nanoAdjustment, 1000000000L));
        int nos = (int)Timestamp.floorMod(nanoAdjustment, 1000000000L);
        return Timestamp.create(secs, nos);
    }

    private static long floorDiv(long x, long y) {
        return BigDecimal.valueOf(x).divide(BigDecimal.valueOf(y), 0, RoundingMode.FLOOR).longValue();
    }

    private static long floorMod(long x, long y) {
        return x - Timestamp.floorDiv(x, y) * y;
    }
}

