/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p36p0.io.grpc.internal.testing;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.ClientStreamTracer;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.Metadata;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.internal.testing.TestStreamTracer;

public class TestClientStreamTracer
extends ClientStreamTracer
implements TestStreamTracer {
    private final TestStreamTracer.TestBaseStreamTracer delegate = new TestStreamTracer.TestBaseStreamTracer();
    protected final CountDownLatch outboundHeadersLatch = new CountDownLatch(1);
    protected final AtomicReference<Throwable> outboundHeadersCalled = new AtomicReference();
    protected final AtomicReference<Throwable> inboundHeadersCalled = new AtomicReference();
    protected final AtomicReference<Metadata> inboundTrailers = new AtomicReference();

    @Override
    public void await() throws InterruptedException {
        this.delegate.await();
    }

    @Override
    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.await(timeout, timeUnit);
    }

    public boolean getInboundHeaders() {
        return this.inboundHeadersCalled.get() != null;
    }

    @Nullable
    public Metadata getInboundTrailers() {
        return this.inboundTrailers.get();
    }

    public boolean getOutboundHeaders() {
        return this.outboundHeadersCalled.get() != null;
    }

    public boolean awaitOutboundHeaders(int timeout, TimeUnit unit) throws Exception {
        return this.outboundHeadersLatch.await(timeout, unit);
    }

    @Override
    public Status getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    public long getInboundWireSize() {
        return this.delegate.getInboundWireSize();
    }

    @Override
    public long getInboundUncompressedSize() {
        return this.delegate.getInboundUncompressedSize();
    }

    @Override
    public long getOutboundWireSize() {
        return this.delegate.getOutboundWireSize();
    }

    @Override
    public long getOutboundUncompressedSize() {
        return this.delegate.getOutboundUncompressedSize();
    }

    @Override
    public void setFailDuplicateCallbacks(boolean fail) {
        this.delegate.setFailDuplicateCallbacks(fail);
    }

    @Override
    public String nextOutboundEvent() {
        return this.delegate.nextOutboundEvent();
    }

    @Override
    public String nextInboundEvent() {
        return this.delegate.nextInboundEvent();
    }

    @Override
    public void outboundWireSize(long bytes) {
        this.delegate.outboundWireSize(bytes);
    }

    @Override
    public void inboundWireSize(long bytes) {
        this.delegate.inboundWireSize(bytes);
    }

    @Override
    public void outboundUncompressedSize(long bytes) {
        this.delegate.outboundUncompressedSize(bytes);
    }

    @Override
    public void inboundUncompressedSize(long bytes) {
        this.delegate.inboundUncompressedSize(bytes);
    }

    @Override
    public void streamClosed(Status status) {
        this.delegate.streamClosed(status);
    }

    @Override
    public void inboundMessage(int seqNo) {
        this.delegate.inboundMessage(seqNo);
    }

    @Override
    public void outboundMessage(int seqNo) {
        this.delegate.outboundMessage(seqNo);
    }

    @Override
    public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        this.delegate.outboundMessageSent(seqNo, optionalWireSize, optionalUncompressedSize);
    }

    @Override
    public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        this.delegate.inboundMessageRead(seqNo, optionalWireSize, optionalUncompressedSize);
    }

    @Override
    public void outboundHeaders() {
        if (!this.outboundHeadersCalled.compareAndSet(null, new Exception("first stack")) && this.delegate.failDuplicateCallbacks.get()) {
            throw new AssertionError("outboundHeaders called more than once", new Exception("second stack", this.outboundHeadersCalled.get()));
        }
        this.outboundHeadersLatch.countDown();
    }

    @Override
    public void inboundHeaders() {
        if (!this.inboundHeadersCalled.compareAndSet(null, new Exception("first stack")) && this.delegate.failDuplicateCallbacks.get()) {
            throw new AssertionError("inboundHeaders called more than once", new Exception("second stack", this.inboundHeadersCalled.get()));
        }
    }

    @Override
    public void inboundTrailers(Metadata trailers) {
        if (this.delegate.getStatus() != null) {
            throw new AssertionError("stream has already been closed with " + this.delegate.getStatus(), this.delegate.streamClosedStack.get());
        }
        if (!this.inboundTrailers.compareAndSet(null, trailers) && this.delegate.failDuplicateCallbacks.get()) {
            throw new AssertionError((Object)"inboundTrailers called more than once");
        }
    }
}

