/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p36p0.io.grpc;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.ChannelCredentials;
import org.apache.beam.vendor.grpc.v1p36p0.io.grpc.ExperimentalApi;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7479")
public final class TlsChannelCredentials
extends ChannelCredentials {
    private final boolean fakeFeature;

    public static ChannelCredentials create() {
        return TlsChannelCredentials.newBuilder().build();
    }

    TlsChannelCredentials(Builder builder) {
        this.fakeFeature = builder.fakeFeature;
    }

    public Set<Feature> incomprehensible(Set<Feature> understoodFeatures) {
        EnumSet<Feature> incomprehensible = EnumSet.noneOf(Feature.class);
        if (this.fakeFeature) {
            TlsChannelCredentials.requiredFeature(understoodFeatures, incomprehensible, Feature.FAKE);
        }
        return Collections.unmodifiableSet(incomprehensible);
    }

    private static void requiredFeature(Set<Feature> understoodFeatures, Set<Feature> incomprehensible, Feature feature) {
        if (!understoodFeatures.contains((Object)feature)) {
            incomprehensible.add(feature);
        }
    }

    @Override
    public ChannelCredentials withoutBearerTokens() {
        return this;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7479")
    public static final class Builder {
        private boolean fakeFeature;

        private Builder() {
        }

        public Builder requireFakeFeature() {
            this.fakeFeature = true;
            return this;
        }

        public ChannelCredentials build() {
            return new TlsChannelCredentials(this);
        }
    }

    public static enum Feature {
        FAKE;

    }
}

