/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.util;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Comparator;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.common.math.IntMath;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.common.math.LongMath;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.Duration;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.util.Timestamps;

public final class Durations {
    static final long DURATION_SECONDS_MIN = -315576000000L;
    static final long DURATION_SECONDS_MAX = 315576000000L;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;
    public static final Duration MIN_VALUE = Duration.newBuilder().setSeconds(-315576000000L).setNanos(-999999999).build();
    public static final Duration MAX_VALUE = Duration.newBuilder().setSeconds(315576000000L).setNanos(999999999).build();
    public static final Duration ZERO = Duration.newBuilder().setSeconds(0L).setNanos(0).build();

    private Durations() {
    }

    public static Comparator<Duration> comparator() {
        return DurationComparator.INSTANCE;
    }

    public static int compare(Duration x, Duration y) {
        return DurationComparator.INSTANCE.compare(x, y);
    }

    public static boolean isValid(Duration duration) {
        return Durations.isValid(duration.getSeconds(), duration.getNanos());
    }

    public static boolean isValid(long seconds, int nanos) {
        if (seconds < -315576000000L || seconds > 315576000000L) {
            return false;
        }
        if ((long)nanos < -999999999L || (long)nanos >= 1000000000L) {
            return false;
        }
        return seconds >= 0L && nanos >= 0 || seconds <= 0L && nanos <= 0;
    }

    public static boolean isNegative(Duration duration) {
        Durations.checkValid(duration);
        return duration.getSeconds() == 0L ? duration.getNanos() < 0 : duration.getSeconds() < 0L;
    }

    @CanIgnoreReturnValue
    public static Duration checkNotNegative(Duration duration) {
        Durations.checkValid(duration);
        Preconditions.checkArgument(!Durations.isNegative(duration), "duration (%s) must not be negative", (Object)Durations.toString(duration));
        return duration;
    }

    @CanIgnoreReturnValue
    public static Duration checkPositive(Duration duration) {
        Durations.checkValid(duration);
        Preconditions.checkArgument(!Durations.isNegative(duration) && !duration.equals(ZERO), "duration (%s) must be positive", (Object)Durations.toString(duration));
        return duration;
    }

    @CanIgnoreReturnValue
    public static Duration checkValid(Duration duration) {
        int nanos;
        long seconds = duration.getSeconds();
        if (!Durations.isValid(seconds, nanos = duration.getNanos())) {
            throw new IllegalArgumentException(String.format("Duration is not valid. See proto definition for valid values. Seconds (%s) must be in range [-315,576,000,000, +315,576,000,000]. Nanos (%s) must be in range [-999,999,999, +999,999,999]. Nanos must have the same sign as seconds", seconds, nanos));
        }
        return duration;
    }

    public static Duration checkValid(Duration.Builder durationBuilder) {
        return Durations.checkValid(durationBuilder.build());
    }

    public static String toString(Duration duration) {
        Durations.checkValid(duration);
        long seconds = duration.getSeconds();
        int nanos = duration.getNanos();
        StringBuilder result = new StringBuilder();
        if (seconds < 0L || nanos < 0) {
            result.append("-");
            seconds = -seconds;
            nanos = -nanos;
        }
        result.append(seconds);
        if (nanos != 0) {
            result.append(".");
            result.append(Timestamps.formatNanos(nanos));
        }
        result.append("s");
        return result.toString();
    }

    public static Duration parse(String value) throws ParseException {
        int nanos;
        if (value.isEmpty() || value.charAt(value.length() - 1) != 's') {
            throw new ParseException("Invalid duration string: " + value, 0);
        }
        boolean negative = false;
        if (value.charAt(0) == '-') {
            negative = true;
            value = value.substring(1);
        }
        String secondValue = value.substring(0, value.length() - 1);
        String nanoValue = "";
        int pointPosition = secondValue.indexOf(46);
        if (pointPosition != -1) {
            nanoValue = secondValue.substring(pointPosition + 1);
            secondValue = secondValue.substring(0, pointPosition);
        }
        long seconds = Long.parseLong(secondValue);
        int n = nanos = nanoValue.isEmpty() ? 0 : Timestamps.parseNanos(nanoValue);
        if (seconds < 0L) {
            throw new ParseException("Invalid duration string: " + value, 0);
        }
        if (negative) {
            seconds = -seconds;
            nanos = -nanos;
        }
        try {
            return Durations.normalizedDuration(seconds, nanos);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException("Duration value is out of range.", 0);
        }
    }

    public static Duration fromDays(long days) {
        return Duration.newBuilder().setSeconds(LongMath.checkedMultiply(days, 86400L)).setNanos(0).build();
    }

    public static Duration fromHours(long hours) {
        return Duration.newBuilder().setSeconds(LongMath.checkedMultiply(hours, 3600L)).setNanos(0).build();
    }

    public static Duration fromMinutes(long minutes) {
        return Duration.newBuilder().setSeconds(LongMath.checkedMultiply(minutes, 60L)).setNanos(0).build();
    }

    public static Duration fromSeconds(long seconds) {
        return Durations.normalizedDuration(seconds, 0);
    }

    public static Duration fromMillis(long milliseconds) {
        return Durations.normalizedDuration(milliseconds / 1000L, (int)(milliseconds % 1000L * 1000000L));
    }

    public static Duration fromMicros(long microseconds) {
        return Durations.normalizedDuration(microseconds / 1000000L, (int)(microseconds % 1000000L * 1000L));
    }

    public static Duration fromNanos(long nanoseconds) {
        return Durations.normalizedDuration(nanoseconds / 1000000000L, (int)(nanoseconds % 1000000000L));
    }

    public static long toDays(Duration duration) {
        return Durations.checkValid(duration).getSeconds() / 86400L;
    }

    public static long toHours(Duration duration) {
        return Durations.checkValid(duration).getSeconds() / 3600L;
    }

    public static long toMinutes(Duration duration) {
        return Durations.checkValid(duration).getSeconds() / 60L;
    }

    public static long toSeconds(Duration duration) {
        return Durations.checkValid(duration).getSeconds();
    }

    public static double toSecondsAsDouble(Duration duration) {
        Durations.checkValid(duration);
        return (double)duration.getSeconds() + (double)duration.getNanos() / 1.0E9;
    }

    public static long toMillis(Duration duration) {
        Durations.checkValid(duration);
        return LongMath.checkedAdd(LongMath.checkedMultiply(duration.getSeconds(), 1000L), (long)duration.getNanos() / 1000000L);
    }

    public static long toMicros(Duration duration) {
        Durations.checkValid(duration);
        return LongMath.checkedAdd(LongMath.checkedMultiply(duration.getSeconds(), 1000000L), (long)duration.getNanos() / 1000L);
    }

    public static long toNanos(Duration duration) {
        Durations.checkValid(duration);
        return LongMath.checkedAdd(LongMath.checkedMultiply(duration.getSeconds(), 1000000000L), duration.getNanos());
    }

    public static Duration add(Duration d1, Duration d2) {
        Durations.checkValid(d1);
        Durations.checkValid(d2);
        return Durations.normalizedDuration(LongMath.checkedAdd(d1.getSeconds(), d2.getSeconds()), IntMath.checkedAdd(d1.getNanos(), d2.getNanos()));
    }

    public static Duration subtract(Duration d1, Duration d2) {
        Durations.checkValid(d1);
        Durations.checkValid(d2);
        return Durations.normalizedDuration(LongMath.checkedSubtract(d1.getSeconds(), d2.getSeconds()), IntMath.checkedSubtract(d1.getNanos(), d2.getNanos()));
    }

    static Duration normalizedDuration(long seconds, int nanos) {
        if ((long)nanos <= -1000000000L || (long)nanos >= 1000000000L) {
            seconds = LongMath.checkedAdd(seconds, (long)nanos / 1000000000L);
            nanos = (int)((long)nanos % 1000000000L);
        }
        if (seconds > 0L && nanos < 0) {
            nanos = (int)((long)nanos + 1000000000L);
            --seconds;
        }
        if (seconds < 0L && nanos > 0) {
            nanos = (int)((long)nanos - 1000000000L);
            ++seconds;
        }
        Duration duration = Duration.newBuilder().setSeconds(seconds).setNanos(nanos).build();
        return Durations.checkValid(duration);
    }

    private static enum DurationComparator implements Comparator<Duration>,
    Serializable
    {
        INSTANCE;


        @Override
        public int compare(Duration d1, Duration d2) {
            Durations.checkValid(d1);
            Durations.checkValid(d2);
            int secDiff = Long.compare(d1.getSeconds(), d2.getSeconds());
            return secDiff != 0 ? secDiff : Integer.compare(d1.getNanos(), d2.getNanos());
        }
    }
}

