/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.replacestring;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.replacestring.ReplaceString;
import org.apache.hop.pipeline.transforms.replacestring.ReplaceStringData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="ReplaceString.Injection.", groups={"FIELDS"})
@Transform(id="ReplaceString", image="replaceinstring.svg", name="i18n::BaseTransform.TypeLongDesc.ReplaceString", description="i18n::BaseTransform.TypeTooltipDesc.ReplaceString", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", documentationUrl="/pipeline/transforms/replacestring.html")
public class ReplaceStringMeta
extends BaseTransformMeta
implements ITransformMeta<ReplaceString, ReplaceStringData> {
    private static final Class<?> PKG = ReplaceStringMeta.class;
    @Injection(name="FIELD_IN_STREAM", group="FIELDS")
    private String[] fieldInStream;
    @Injection(name="FIELD_OUT_STREAM", group="FIELDS")
    private String[] fieldOutStream;
    @Injection(name="USE_REGEX", group="FIELDS")
    private int[] useRegEx;
    @Injection(name="REPLACE_STRING", group="FIELDS")
    private String[] replaceString;
    @Injection(name="REPLACE_BY", group="FIELDS")
    private String[] replaceByString;
    @Injection(name="EMPTY_STRING", group="FIELDS")
    private boolean[] setEmptyString;
    @Injection(name="REPLACE_WITH_FIELD", group="FIELDS")
    private String[] replaceFieldByString;
    @Injection(name="REPLACE_WHOLE_WORD", group="FIELDS")
    private int[] wholeWord;
    @Injection(name="CASE_SENSITIVE", group="FIELDS")
    private int[] caseSensitive;
    @Injection(name="IS_UNICODE", group="FIELDS")
    private int[] isUnicode;
    protected static final String[] caseSensitiveCode = new String[]{"no", "yes"};
    protected static final String[] isUnicodeCode = new String[]{"no", "yes"};
    protected static final String[] caseSensitiveDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    protected static final String[] isUnicodeDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final int CASE_SENSITIVE_NO = 0;
    public static final int CASE_SENSITIVE_YES = 1;
    public static final int IS_UNICODE_NO = 0;
    public static final int IS_UNICODE_YES = 1;
    protected static final String[] wholeWordDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    protected static final String[] wholeWordCode = new String[]{"no", "yes"};
    public static final int WHOLE_WORD_NO = 0;
    public static final int WHOLE_WORD_YES = 1;
    protected static final String[] useRegExDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    protected static final String[] useRegExCode = new String[]{"no", "yes"};
    public static final int USE_REGEX_NO = 0;
    public static final int USE_REGEX_YES = 1;

    public String[] getFieldInStream() {
        return this.fieldInStream;
    }

    public void setFieldInStream(String[] keyStream) {
        this.fieldInStream = keyStream;
    }

    public int[] getCaseSensitive() {
        return this.caseSensitive;
    }

    public int[] isUnicode() {
        return this.isUnicode;
    }

    public int[] getWholeWord() {
        return this.wholeWord;
    }

    public void setWholeWord(int[] wholeWord) {
        this.wholeWord = wholeWord;
    }

    public int[] getUseRegEx() {
        return this.useRegEx;
    }

    public void setUseRegEx(int[] useRegEx) {
        this.useRegEx = useRegEx;
    }

    public boolean[] isSetEmptyString() {
        return this.setEmptyString;
    }

    public void setEmptyString(boolean[] setEmptyString) {
        this.setEmptyString = setEmptyString;
    }

    public String[] getFieldOutStream() {
        return this.fieldOutStream;
    }

    public void setFieldOutStream(String[] keyStream) {
        this.fieldOutStream = keyStream;
    }

    public String[] getReplaceString() {
        return this.replaceString;
    }

    public void setReplaceString(String[] replaceString) {
        this.replaceString = replaceString;
    }

    public String[] getReplaceByString() {
        return this.replaceByString;
    }

    public void setReplaceByString(String[] replaceByString) {
        this.replaceByString = replaceByString;
    }

    public String[] getFieldReplaceByString() {
        return this.replaceFieldByString;
    }

    public void setFieldReplaceByString(String[] replaceFieldByString) {
        this.replaceFieldByString = replaceFieldByString;
    }

    public void setCaseSensitive(int[] caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setIsUnicode(int[] isUnicode) {
        this.isUnicode = isUnicode;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public void allocate(int nrkeys) {
        this.fieldInStream = new String[nrkeys];
        this.fieldOutStream = new String[nrkeys];
        this.useRegEx = new int[nrkeys];
        this.replaceString = new String[nrkeys];
        this.replaceByString = new String[nrkeys];
        this.setEmptyString = new boolean[nrkeys];
        this.replaceFieldByString = new String[nrkeys];
        this.wholeWord = new int[nrkeys];
        this.caseSensitive = new int[nrkeys];
        this.isUnicode = new int[nrkeys];
    }

    public Object clone() {
        ReplaceStringMeta retval = (ReplaceStringMeta)((Object)super.clone());
        int nrkeys = this.fieldInStream.length;
        retval.allocate(nrkeys);
        System.arraycopy(this.fieldInStream, 0, retval.fieldInStream, 0, nrkeys);
        System.arraycopy(this.fieldOutStream, 0, retval.fieldOutStream, 0, nrkeys);
        System.arraycopy(this.useRegEx, 0, retval.useRegEx, 0, nrkeys);
        System.arraycopy(this.replaceString, 0, retval.replaceString, 0, nrkeys);
        System.arraycopy(this.replaceByString, 0, retval.replaceByString, 0, nrkeys);
        System.arraycopy(this.setEmptyString, 0, retval.setEmptyString, 0, nrkeys);
        System.arraycopy(this.replaceFieldByString, 0, retval.replaceFieldByString, 0, nrkeys);
        System.arraycopy(this.wholeWord, 0, retval.wholeWord, 0, nrkeys);
        System.arraycopy(this.caseSensitive, 0, retval.caseSensitive, 0, nrkeys);
        System.arraycopy(this.isUnicode, 0, retval.isUnicode, 0, nrkeys);
        return retval;
    }

    public ITransform createTransform(TransformMeta transformMeta, ReplaceStringData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new ReplaceString(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            Node lookup = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrkeys = XmlHandler.countNodes((Node)lookup, (String)"field");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)lookup, (String)"field", (int)i);
                this.fieldInStream[i] = Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"in_stream_name"), (String)"");
                this.fieldOutStream[i] = Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"out_stream_name"), (String)"");
                this.useRegEx[i] = ReplaceStringMeta.getCaseSensitiveByCode(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"use_regex"), (String)""));
                this.replaceString[i] = Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"replace_string"), (String)"");
                this.replaceByString[i] = Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"replace_by_string"), (String)"");
                String emptyString = XmlHandler.getTagValue((Node)fnode, (String)"set_empty_string");
                this.setEmptyString[i] = !Utils.isEmpty((CharSequence)emptyString) && "Y".equalsIgnoreCase(emptyString);
                this.replaceFieldByString[i] = Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"replace_field_by_string"), (String)"");
                this.wholeWord[i] = ReplaceStringMeta.getWholeWordByCode(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"whole_word"), (String)""));
                this.caseSensitive[i] = ReplaceStringMeta.getCaseSensitiveByCode(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"case_sensitive"), (String)""));
                this.isUnicode[i] = ReplaceStringMeta.getIsUniCodeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)fnode, (String)"is_unicode"), (String)""));
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ReplaceStringMeta.Exception.UnableToReadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    private static int getIsUniCodeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < isUnicodeCode.length; ++i) {
            if (!isUnicodeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void setDefault() {
        this.fieldInStream = null;
        this.fieldOutStream = null;
        int nrkeys = 0;
        this.allocate(nrkeys);
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldInStream.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)"in_stream_name", (String)this.fieldInStream[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"out_stream_name", (String)this.fieldOutStream[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"use_regex", (String)ReplaceStringMeta.getUseRegExCode(this.useRegEx[i])));
            retval.append("        ").append(XmlHandler.addTagValue((String)"replace_string", (String)this.replaceString[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"replace_by_string", (String)this.replaceByString[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"set_empty_string", (boolean)this.setEmptyString[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"replace_field_by_string", (String)this.replaceFieldByString[i]));
            retval.append("        ").append(XmlHandler.addTagValue((String)"whole_word", (String)ReplaceStringMeta.getWholeWordCode(this.wholeWord[i])));
            retval.append("        ").append(XmlHandler.addTagValue((String)"case_sensitive", (String)ReplaceStringMeta.getCaseSensitiveCode(this.caseSensitive[i])));
            retval.append("        ").append(XmlHandler.addTagValue((String)"is_unicode", (String)ReplaceStringMeta.getIsUniCodeCode(this.isUnicode[i])));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    private static String getIsUniCodeCode(int i) {
        if (i < 0 || i >= isUnicodeCode.length) {
            return isUnicodeCode[0];
        }
        return isUnicodeCode[i];
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        int nrFields = this.fieldInStream == null ? 0 : this.fieldInStream.length;
        for (int i = 0; i < nrFields; ++i) {
            ValueMetaString valueMeta;
            String fieldName = variables.resolve(this.fieldOutStream[i]);
            if (!Utils.isEmpty((CharSequence)this.fieldOutStream[i])) {
                valueMeta = new ValueMetaString(fieldName);
                valueMeta.setOrigin(name);
                IValueMeta sourceField = inputRowMeta.searchValueMeta(this.fieldInStream[i]);
                if (sourceField != null) {
                    valueMeta.setStringEncoding(sourceField.getStringEncoding());
                }
                inputRowMeta.addValueMeta((IValueMeta)valueMeta);
                continue;
            }
            valueMeta = inputRowMeta.searchValueMeta(this.fieldInStream[i]);
            if (valueMeta == null) continue;
            valueMeta.setStorageType(0);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        StringBuilder errorMessage = new StringBuilder();
        boolean first = true;
        boolean errorFound = false;
        if (prev == null) {
            errorMessage.append(BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.NoInputReceived", (String[])new String[0])).append(Const.CR);
            CheckResult cr = new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            int idx;
            IValueMeta v;
            String field;
            int i;
            for (i = 0; i < this.fieldInStream.length; ++i) {
                field = this.fieldInStream[i];
                v = prev.searchValueMeta(field);
                if (v != null) continue;
                if (first) {
                    first = false;
                    errorMessage.append(BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.MissingInStreamFields", (String[])new String[0])).append(Const.CR);
                }
                errorFound = true;
                errorMessage.append("\t\t").append(field).append(Const.CR);
            }
            CheckResult cr = errorFound ? new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transforminfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.FoundInStreamFields", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
            first = true;
            errorFound = false;
            for (i = 0; i < this.fieldInStream.length; ++i) {
                field = this.fieldInStream[i];
                v = prev.searchValueMeta(field);
                if (v == null || v.getType() == 2) continue;
                if (first) {
                    first = false;
                    errorMessage.append(BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.OperationOnNonStringFields", (String[])new String[0])).append(Const.CR);
                }
                errorFound = true;
                errorMessage.append("\t\t").append(field).append(Const.CR);
            }
            cr = errorFound ? new CheckResult(4, errorMessage.toString(), (ICheckResultSource)transforminfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.AllOperationsOnStringFields", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
            if (this.fieldInStream.length > 0) {
                for (idx = 0; idx < this.fieldInStream.length; ++idx) {
                    if (!Utils.isEmpty((CharSequence)this.fieldInStream[idx])) continue;
                    cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.InStreamFieldMissing", (String[])new String[]{Integer.toString(idx + 1)}), (ICheckResultSource)transforminfo);
                    remarks.add((ICheckResult)cr);
                }
            }
            for (idx = 0; idx < this.fieldInStream.length; ++idx) {
                for (int jdx = 0; jdx < this.fieldInStream.length; ++jdx) {
                    if (!this.fieldInStream[idx].equals(this.fieldInStream[jdx]) || idx == jdx || idx >= jdx) continue;
                    String errMessage = BaseMessages.getString(PKG, (String)"ReplaceStringMeta.CheckResult.FieldInputError", (String[])new String[]{this.fieldInStream[idx]});
                    cr = new CheckResult(4, errMessage, (ICheckResultSource)transforminfo);
                    remarks.add((ICheckResult)cr);
                }
            }
        }
    }

    public ReplaceStringData getTransformData() {
        return new ReplaceStringData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    private static String getCaseSensitiveCode(int i) {
        if (i < 0 || i >= caseSensitiveCode.length) {
            return caseSensitiveCode[0];
        }
        return caseSensitiveCode[i];
    }

    private static String getWholeWordCode(int i) {
        if (i < 0 || i >= wholeWordCode.length) {
            return wholeWordCode[0];
        }
        return wholeWordCode[i];
    }

    private static String getUseRegExCode(int i) {
        if (i < 0 || i >= useRegExCode.length) {
            return useRegExCode[0];
        }
        return useRegExCode[i];
    }

    public static String getCaseSensitiveDesc(int i) {
        if (i < 0 || i >= caseSensitiveDesc.length) {
            return caseSensitiveDesc[0];
        }
        return caseSensitiveDesc[i];
    }

    public static String getIsUnicodeDesc(int i) {
        if (i < 0 || i >= isUnicodeDesc.length) {
            return isUnicodeDesc[0];
        }
        return isUnicodeDesc[i];
    }

    public static String getWholeWordDesc(int i) {
        if (i < 0 || i >= wholeWordDesc.length) {
            return wholeWordDesc[0];
        }
        return wholeWordDesc[i];
    }

    public static String getUseRegExDesc(int i) {
        if (i < 0 || i >= useRegExDesc.length) {
            return useRegExDesc[0];
        }
        return useRegExDesc[i];
    }

    private static int getCaseSensitiveByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < caseSensitiveCode.length; ++i) {
            if (!caseSensitiveCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getWholeWordByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < wholeWordCode.length; ++i) {
            if (!wholeWordCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getRegExByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < useRegExCode.length; ++i) {
            if (!useRegExCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static int getCaseSensitiveByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < caseSensitiveDesc.length; ++i) {
            if (!caseSensitiveDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ReplaceStringMeta.getCaseSensitiveByCode(tt);
    }

    public static int getIsUnicodeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < isUnicodeDesc.length; ++i) {
            if (!isUnicodeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ReplaceStringMeta.getIsUniCodeByCode(tt);
    }

    public static int getWholeWordByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < wholeWordDesc.length; ++i) {
            if (!wholeWordDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ReplaceStringMeta.getWholeWordByCode(tt);
    }

    public static int getUseRegExByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < useRegExDesc.length; ++i) {
            if (!useRegExDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ReplaceStringMeta.getRegExByCode(tt);
    }

    private void nullToEmpty(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] != null) continue;
            strings[i] = "";
        }
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        int nrFields;
        int n = nrFields = this.fieldInStream == null ? -1 : this.fieldInStream.length;
        if (nrFields <= 0) {
            return;
        }
        String[][] rtnStringArrays = Utils.normalizeArrays((int)nrFields, (String[][])new String[][]{this.fieldOutStream, this.replaceString, this.replaceByString, this.replaceFieldByString});
        this.fieldOutStream = rtnStringArrays[0];
        this.replaceString = rtnStringArrays[1];
        this.replaceByString = rtnStringArrays[2];
        this.replaceFieldByString = rtnStringArrays[3];
        this.nullToEmpty(this.fieldOutStream);
        this.nullToEmpty(this.replaceString);
        this.nullToEmpty(this.replaceByString);
        this.nullToEmpty(this.replaceFieldByString);
        int[][] rtnIntArrays = Utils.normalizeArrays((int)nrFields, (int[][])new int[][]{this.useRegEx, this.wholeWord, this.caseSensitive, this.isUnicode});
        this.useRegEx = rtnIntArrays[0];
        this.wholeWord = rtnIntArrays[1];
        this.caseSensitive = rtnIntArrays[2];
        this.isUnicode = rtnIntArrays[3];
        boolean[][] rtnBooleanArrays = Utils.normalizeArrays((int)nrFields, (boolean[][])new boolean[][]{this.setEmptyString});
        this.setEmptyString = rtnBooleanArrays[0];
    }
}

