/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.clickhouse;

import org.apache.commons.lang.Validate;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;

@DatabaseMetaPlugin(type="CLICKHOUSE", typeDescription="ClickHouse")
@GuiPlugin(id="GUI-ClickhouseDatabaseMeta")
public class ClickhouseDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 8123;
        }
        return -1;
    }

    public String getDriverClass() {
        return "cc.blynk.clickhouse.ClickHouseDriver";
    }

    public String getURL(String hostName, String port, String databaseName) {
        Validate.notEmpty((String)hostName, (String)"Host name is empty");
        String url = "jdbc:clickhouse://" + hostName.toLowerCase();
        if (!Utils.isEmpty((CharSequence)port)) {
            url = url + ":" + port;
        }
        boolean isFirstQueryParam = true;
        if (!Utils.isEmpty((CharSequence)databaseName)) {
            url = isFirstQueryParam ? url + "/" + databaseName : url + databaseName;
        }
        return url;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " DROP COLUMN " + v.getName() + Const.CR;
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " MODIFY COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String surrogateKey, String primaryKey, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        boolean isKeyField;
        String fieldDefinitionDdl = "";
        String newline = addCr ? Const.CR : "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        int type = v.getType();
        boolean bl = isKeyField = fieldname.equalsIgnoreCase(surrogateKey) || fieldname.equalsIgnoreCase(primaryKey);
        if (addFieldName) {
            fieldDefinitionDdl = fieldDefinitionDdl + fieldname + " ";
        }
        if (isKeyField) {
            Validate.isTrue((type == 1 || type == 5 || type == 6 ? 1 : 0) != 0);
            return this.ddlForPrimaryKey() + newline;
        }
        switch (type) {
            case 9: {
                fieldDefinitionDdl = fieldDefinitionDdl + "DATETIME";
                break;
            }
            case 3: {
                fieldDefinitionDdl = fieldDefinitionDdl + "DATE";
                break;
            }
            case 4: {
                fieldDefinitionDdl = fieldDefinitionDdl + "UINT8";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (precision == 0) {
                    fieldDefinitionDdl = fieldDefinitionDdl + this.ddlForIntegerValue(length);
                    break;
                }
                fieldDefinitionDdl = fieldDefinitionDdl + this.ddlForFloatValue(length, precision);
                break;
            }
            case 2: {
                fieldDefinitionDdl = fieldDefinitionDdl + "STRING";
                break;
            }
            case 8: {
                fieldDefinitionDdl = fieldDefinitionDdl + "UNSUPPORTED";
                break;
            }
            default: {
                fieldDefinitionDdl = fieldDefinitionDdl + " UNKNOWN";
            }
        }
        return fieldDefinitionDdl + newline;
    }

    private String ddlForIntegerValue(int length) {
        if (length > 9) {
            if (length < 19) {
                return "INT64";
            }
            return "INT128";
        }
        return "INT32";
    }

    private String ddlForFloatValue(int length, int precision) {
        if (length > 15) {
            return "DECIMAL(" + length + ", " + precision + ")";
        }
        return "FLOAT32";
    }

    private String ddlForPrimaryKey() {
        return "UUID NOT NULL PRIMARY KEY";
    }

    public String getLimitClause(int nrRows) {
        return " LIMIT " + nrRows;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " LIMIT 0";
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return this.getSqlQueryColumnFields(columnname, tableName);
    }

    public String getSqlQueryColumnFields(String columnname, String tableName) {
        return "SELECT " + columnname + " FROM " + tableName + " LIMIT 0";
    }

    public String getExtraOptionSeparator() {
        return "&";
    }

    public boolean isQuoteAllFields() {
        return false;
    }

    public String getExtraOptionIndicator() {
        return "&";
    }

    public boolean supportsSchemas() {
        return false;
    }

    public boolean supportsTransactions() {
        return false;
    }

    public boolean supportsViews() {
        return true;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsSynonyms() {
        return true;
    }

    public boolean supportsBooleanDataType() {
        return false;
    }

    public boolean supportsErrorHandlingOnBatchUpdates() {
        return true;
    }

    public String[] getReservedWords() {
        return new String[]{"ALL", "ALTER", "AND", "ANY", "AS", "ASC", "BETWEEN", "BY", "CASE", "CAST", "CHECK", "CLUSTER", "COLUMN", "CONNECT", "CREATE", "CROSS", "CURRENT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FALSE", "FOR", "FROM", "FULL", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "LATERAL", "LEFT", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODIFY", "NATURAL", "NOT", "NULL", "OF", "ON", "OPTION", "OR", "ORDER", "REGEXP", "RENAME", "REVOKE", "RIGHT", "RLIKE", "ROW", "ROWS", "SELECT", "SET", "SOME", "START", "TABLE", "THEN", "TO", "TRIGGER", "TRUE", "UNION", "UNIQUE", "UPDATE", "USING", "VALUES", "WHEN", "WHENEVER", "WHERE", "WITH"};
    }

    public String getExtraOptionsHelpText() {
        return "https://github.com/ClickHouse/clickhouse-jdbc";
    }

    public String getSqlInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + keyField + ", " + versionField + ") values (1, 1)";
    }

    public String quoteSqlString(String string) {
        string = string.replace("'", "\\\\'");
        string = string.replace("\\n", "\\\\n");
        string = string.replace("\\r", "\\\\r");
        return "'" + string + "'";
    }

    public boolean releaseSavepoint() {
        return false;
    }

    public boolean isRequiringTransactionsOnQueries() {
        return false;
    }

    public boolean useSchemaNameForTableList() {
        return false;
    }

    public boolean supportsTimeStampToDateConversion() {
        return false;
    }
}

