/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;

public interface DirectOptions
extends PipelineOptions,
ApplicationNameOptions {
    @Default.Boolean(value=true)
    @Description(value="If the pipeline should block awaiting completion of the pipeline. If set to true, a call to Pipeline#run() will block until all PTransforms are complete. Otherwise, the Pipeline will execute asynchronously. If set to false, use PipelineResult#waitUntilFinish() to block until the Pipeline is complete.")
    public boolean isBlockOnRun();

    public void setBlockOnRun(boolean var1);

    @Default.Boolean(value=true)
    @Description(value="Controls whether the DirectRunner should ensure that all of the elements of every PCollection are not mutated. PTransforms are not permitted to mutate input elements at any point, or output elements after they are output.")
    public boolean isEnforceImmutability();

    public void setEnforceImmutability(boolean var1);

    @Default.Boolean(value=true)
    @Description(value="Controls whether the DirectRunner should ensure that all of the elements of every PCollection can be encoded and decoded by that PCollection's Coder.")
    public boolean isEnforceEncodability();

    public void setEnforceEncodability(boolean var1);

    @Default.InstanceFactory(value=AvailableParallelismFactory.class)
    @Description(value="Controls the amount of target parallelism the DirectRunner will use. Defaults to the greater of the number of available processors and 3. Must be a value greater than zero.")
    public int getTargetParallelism();

    public void setTargetParallelism(int var1);

    public static class AvailableParallelismFactory
    implements DefaultValueFactory<Integer> {
        private static final int MIN_PARALLELISM = 3;

        @Override
        public Integer create(PipelineOptions options) {
            return Math.max(Runtime.getRuntime().availableProcessors(), 3);
        }
    }
}

