/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItem;
import org.apache.beam.repackaged.direct_java.runners.core.KeyedWorkItemCoder;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ForwardingPTransform;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

class DirectGroupByKey<K, V>
extends ForwardingPTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> {
    private final PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> original;
    static final String DIRECT_GBKO_URN = "beam:directrunner:transforms:gbko:v1";
    static final String DIRECT_GABW_URN = "beam:directrunner:transforms:gabw:v1";
    private final WindowingStrategy<?, ?> outputWindowingStrategy;

    DirectGroupByKey(PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> original, WindowingStrategy<?, ?> outputWindowingStrategy) {
        this.original = original;
        this.outputWindowingStrategy = outputWindowingStrategy;
    }

    @Override
    public PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<V>>>> delegate() {
        return this.original;
    }

    @Override
    public PCollection<KV<K, Iterable<V>>> expand(PCollection<KV<K, V>> input) {
        WindowingStrategy<?, ?> inputWindowingStrategy = input.getWindowingStrategy();
        return (PCollection)((PCollection)input.apply(new DirectGroupByKeyOnly())).apply("GroupAlsoByWindow", new DirectGroupAlsoByWindow(inputWindowingStrategy, this.outputWindowingStrategy));
    }

    static final class DirectGroupAlsoByWindow<K, V>
    extends PTransform<PCollection<KeyedWorkItem<K, V>>, PCollection<KV<K, Iterable<V>>>> {
        private final WindowingStrategy<?, ?> inputWindowingStrategy;
        private final WindowingStrategy<?, ?> outputWindowingStrategy;

        public DirectGroupAlsoByWindow(WindowingStrategy<?, ?> inputWindowingStrategy, WindowingStrategy<?, ?> outputWindowingStrategy) {
            this.inputWindowingStrategy = inputWindowingStrategy;
            this.outputWindowingStrategy = outputWindowingStrategy;
        }

        public WindowingStrategy<?, ?> getInputWindowingStrategy() {
            return this.inputWindowingStrategy;
        }

        private KeyedWorkItemCoder<K, V> getKeyedWorkItemCoder(Coder<KeyedWorkItem<K, V>> inputCoder) {
            Preconditions.checkArgument((boolean)(inputCoder instanceof KeyedWorkItemCoder), (String)"%s requires a %s<...> but got %s", (Object)this.getClass().getSimpleName(), (Object)KvCoder.class.getSimpleName(), inputCoder);
            KeyedWorkItemCoder kvCoder = (KeyedWorkItemCoder)inputCoder;
            return kvCoder;
        }

        public Coder<V> getValueCoder(Coder<KeyedWorkItem<K, V>> inputCoder) {
            return this.getKeyedWorkItemCoder(inputCoder).getElementCoder();
        }

        @Override
        public PCollection<KV<K, Iterable<V>>> expand(PCollection<KeyedWorkItem<K, V>> input) {
            KeyedWorkItemCoder<K, V> inputCoder = this.getKeyedWorkItemCoder(input.getCoder());
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), this.outputWindowingStrategy, input.isBounded(), KvCoder.of(inputCoder.getKeyCoder(), IterableCoder.of(inputCoder.getElementCoder())));
        }
    }

    static final class DirectGroupByKeyOnly<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KeyedWorkItem<K, V>>> {
        @Override
        public PCollection<KeyedWorkItem<K, V>> expand(PCollection<KV<K, V>> input) {
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), input.isBounded(), KeyedWorkItemCoder.of(GroupByKey.getKeyCoder(input.getCoder()), GroupByKey.getInputValueCoder(input.getCoder()), input.getWindowingStrategy().getWindowFn().windowCoder()));
        }

        DirectGroupByKeyOnly() {
        }
    }
}

