/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.fnexecution.wire;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;

@Internal
public class ByteStringCoder
extends AtomicCoder<ByteString> {
    private static final ByteStringCoder INSTANCE = new ByteStringCoder();
    private static final TypeDescriptor<ByteString> TYPE_DESCRIPTOR = new TypeDescriptor<ByteString>(){};

    public static ByteStringCoder of() {
        return INSTANCE;
    }

    private ByteStringCoder() {
    }

    @Override
    public void encode(ByteString value, OutputStream outStream) throws IOException, CoderException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(ByteString value, OutputStream outStream, Coder.Context context) throws IOException, CoderException {
        if (value == null) {
            throw new CoderException("cannot encode a null ByteString");
        }
        if (!context.isWholeStream) {
            VarInt.encode(value.size(), outStream);
        }
        value.writeTo(outStream);
    }

    @Override
    public ByteString decode(InputStream inStream) throws IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public ByteString decode(InputStream inStream, Coder.Context context) throws IOException {
        if (context.isWholeStream) {
            return ByteString.readFrom((InputStream)inStream);
        }
        int size = VarInt.decodeInt(inStream);
        return ByteString.readFrom((InputStream)ByteStreams.limit((InputStream)inStream, (long)size), (int)size);
    }

    @Override
    protected long getEncodedElementByteSize(ByteString value) throws Exception {
        int size = value.size();
        return (long)VarInt.getLength(size) + (long)size;
    }

    @Override
    public void verifyDeterministic() {
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(ByteString value) {
        return true;
    }

    @Override
    public TypeDescriptor<ByteString> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }
}

