/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.DirtyState;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.GaugeData;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.MetricCell;
import org.apache.beam.sdk.metrics.Gauge;
import org.apache.beam.sdk.metrics.MetricName;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GaugeCell
implements Gauge,
MetricCell<GaugeData> {
    private final DirtyState dirty = new DirtyState();
    private final AtomicReference<GaugeData> gaugeValue = new AtomicReference<GaugeData>(GaugeData.empty());
    private final MetricName name;

    public GaugeCell(MetricName name) {
        this.name = name;
    }

    @Override
    public void reset() {
        this.dirty.afterModification();
        this.gaugeValue.set(GaugeData.empty());
    }

    @Override
    public void set(long value) {
        this.update(GaugeData.create(value));
    }

    void update(GaugeData data) {
        GaugeData original;
        while (!this.gaugeValue.compareAndSet(original = this.gaugeValue.get(), original.combine(data))) {
        }
        this.dirty.afterModification();
    }

    @Override
    public DirtyState getDirty() {
        return this.dirty;
    }

    @Override
    public GaugeData getCumulative() {
        return this.gaugeValue.get();
    }

    @Override
    public MetricName getName() {
        return this.name;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof GaugeCell) {
            GaugeCell gaugeCell = (GaugeCell)object;
            return Objects.equals(this.dirty, gaugeCell.dirty) && Objects.equals(this.gaugeValue.get(), gaugeCell.gaugeValue.get()) && Objects.equals(this.name, gaugeCell.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.dirty, this.gaugeValue.get(), this.name);
    }
}

