/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction;

import java.io.IOException;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.repackaged.direct_java.runners.core.construction.ParDoTranslation;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RehydratedComponents;
import org.apache.beam.repackaged.direct_java.runners.core.construction.RunnerPCollectionView;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class PCollectionViewTranslation {
    public static PCollectionView<?> viewFromProto(RunnerApi.SideInput sideInput, String localName, PCollection<?> pCollection, RunnerApi.PTransform parDoTransform, RehydratedComponents components) throws IOException {
        Preconditions.checkArgument((localName != null ? 1 : 0) != 0, (String)"%s.viewFromProto: localName must not be null", (Object)ParDoTranslation.class.getSimpleName());
        TupleTag tag = new TupleTag(localName);
        WindowMappingFn<?> windowMappingFn = PCollectionViewTranslation.windowMappingFnFromProto(sideInput.getWindowMappingFn());
        ViewFn<?, ?> viewFn = PCollectionViewTranslation.viewFnFromProto(sideInput.getViewFn());
        WindowingStrategy<?, ?> windowingStrategy = pCollection.getWindowingStrategy().fixDefaults();
        RunnerPCollectionView view = new RunnerPCollectionView(pCollection, tag, viewFn, windowMappingFn, windowingStrategy, pCollection.getCoder());
        return view;
    }

    public static ViewFn<?, ?> viewFnFromProto(RunnerApi.FunctionSpec viewFn) throws InvalidProtocolBufferException {
        RunnerApi.FunctionSpec spec = viewFn;
        Preconditions.checkArgument((boolean)spec.getUrn().equals("beam:viewfn:javasdk:0.1"), (String)"Can't deserialize unknown %s type %s", (Object)ViewFn.class.getSimpleName(), (Object)spec.getUrn());
        return (ViewFn)SerializableUtils.deserializeFromByteArray(spec.getPayload().toByteArray(), "Custom ViewFn");
    }

    public static WindowMappingFn<?> windowMappingFnFromProto(RunnerApi.FunctionSpec windowMappingFn) throws InvalidProtocolBufferException {
        RunnerApi.FunctionSpec spec = windowMappingFn;
        Preconditions.checkArgument((boolean)spec.getUrn().equals("beam:windowmappingfn:javasdk:0.1"), (String)"Can't deserialize unknown %s type %s", (Object)WindowMappingFn.class.getSimpleName(), (Object)spec.getUrn());
        return (WindowMappingFn)SerializableUtils.deserializeFromByteArray(spec.getPayload().toByteArray(), "Custom WinodwMappingFn");
    }
}

