/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Throwables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;

public final class ValueAndCoderLazySerializable<T>
implements Serializable {
    private T value;
    private Object coderOrBytes;

    private ValueAndCoderLazySerializable(T value, Coder<T> currentCoder) {
        this.value = value;
        this.coderOrBytes = currentCoder;
    }

    ValueAndCoderLazySerializable() {
    }

    public static <T> ValueAndCoderLazySerializable<T> of(T value, Coder<T> coder) {
        return new ValueAndCoderLazySerializable<T>(value, coder);
    }

    public T getOrDecode(Coder<T> coder) {
        if (!(this.coderOrBytes instanceof Coder)) {
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])this.coderOrBytes);
            try {
                this.value = coder.decode((InputStream)bais);
            }
            catch (IOException e) {
                throw new IllegalStateException("Error decoding bytes for coder: " + coder, e);
            }
            this.coderOrBytes = coder;
        }
        return this.value;
    }

    void writeCommon(OutputStream out) throws IOException {
        if (!(this.coderOrBytes instanceof Coder)) {
            byte[] bytes = (byte[])this.coderOrBytes;
            VarInt.encode((int)bytes.length, (OutputStream)out);
            out.write(bytes);
        } else {
            Coder coder = (Coder)this.coderOrBytes;
            int bufferSize = 1024;
            if (coder.isRegisterByteSizeObserverCheap(this.value)) {
                try {
                    ByteSizeObserver observer = new ByteSizeObserver();
                    coder.registerByteSizeObserver(this.value, (ElementByteSizeObserver)observer);
                    bufferSize = (int)observer.observedSize;
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            }
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(bufferSize);
            try {
                coder.encode(this.value, (OutputStream)bytes);
                VarInt.encode((int)bytes.size(), (OutputStream)out);
                bytes.writeTo(out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    void readCommon(InputStream in) throws IOException {
        int length = VarInt.decodeInt((InputStream)in);
        byte[] bytes = new byte[length];
        ByteStreams.readFully((InputStream)in, (byte[])bytes);
        this.coderOrBytes = bytes;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeCommon(out);
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.readCommon(in);
    }

    private static class ByteSizeObserver
    extends ElementByteSizeObserver {
        private long observedSize = 0L;

        private ByteSizeObserver() {
        }

        protected void reportElementSize(long elementByteSize) {
            this.observedSize += elementByteSize;
        }
    }
}

