/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.rowgenerator;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformIOMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformIOMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.rowgenerator.GeneratorField;
import org.apache.hop.pipeline.transforms.rowgenerator.RowGenerator;
import org.apache.hop.pipeline.transforms.rowgenerator.RowGeneratorData;

@Transform(id="RowGenerator", image="rowgenerator.svg", name="i18n::BaseTransform.TypeLongDesc.GenerateRows", description="i18n::BaseTransform.TypeTooltipDesc.GenerateRows", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/rowgenerator.html")
public class RowGeneratorMeta
extends BaseTransformMeta
implements ITransformMeta<RowGenerator, RowGeneratorData> {
    private static final Class<?> PKG = RowGeneratorMeta.class;
    @HopMetadataProperty(key="never_ending", injectionKeyDescription="RowGeneratorMeta.Injection.NeverEnding")
    private boolean neverEnding;
    @HopMetadataProperty(key="interval_in_ms", injectionKeyDescription="RowGeneratorMeta.Injection.IntervalInMs")
    private String intervalInMs;
    @HopMetadataProperty(key="row_time_field", injectionKeyDescription="RowGeneratorMeta.Injection.RowTimeField")
    private String rowTimeField;
    @HopMetadataProperty(key="last_time_field", injectionKeyDescription="RowGeneratorMeta.Injection.LastTimeField")
    private String lastTimeField;
    @HopMetadataProperty(key="limit", injectionKeyDescription="RowGeneratorMeta.Injection.RowLimit")
    private String rowLimit;
    @HopMetadataProperty(groupKey="fields", key="field", injectionGroupDescription="RowGeneratorMeta.Injection.Fields", injectionKeyDescription="RowGeneratorMeta.Injection.Field")
    private List<GeneratorField> fields;

    public RowGeneratorMeta() {
        this.fields = new ArrayList<GeneratorField>();
        this.rowLimit = "10";
        this.neverEnding = false;
        this.intervalInMs = "5000";
        this.rowTimeField = "now";
        this.lastTimeField = "FiveSecondsAgo";
    }

    public RowGeneratorMeta(RowGeneratorMeta m) {
        this.neverEnding = m.neverEnding;
        this.intervalInMs = m.intervalInMs;
        this.rowTimeField = m.rowTimeField;
        this.lastTimeField = m.lastTimeField;
        this.rowLimit = m.rowLimit;
        this.fields = new ArrayList<GeneratorField>();
        for (GeneratorField field : m.fields) {
            this.fields.add(new GeneratorField(field));
        }
    }

    public RowGeneratorMeta clone() {
        return new RowGeneratorMeta(this);
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            ArrayList<ICheckResult> remarks = new ArrayList<ICheckResult>();
            RowMetaAndData rowMetaAndData = RowGenerator.buildRow(this, remarks, origin);
            if (!remarks.isEmpty()) {
                StringBuilder stringRemarks = new StringBuilder();
                for (ICheckResult remark : remarks) {
                    stringRemarks.append(remark.toString()).append(Const.CR);
                }
                throw new HopTransformException(stringRemarks.toString());
            }
            for (IValueMeta valueMeta : rowMetaAndData.getRowMeta().getValueMetaList()) {
                valueMeta.setOrigin(origin);
            }
            row.mergeRowMeta(rowMetaAndData.getRowMeta());
        }
        catch (Exception e) {
            throw new HopTransformException((Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RowGeneratorMeta.CheckResult.NoInputStreamsError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RowGeneratorMeta.CheckResult.NoInputStreamOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            String strLimit = variables.resolve(this.rowLimit);
            if (Const.toLong((String)strLimit, (long)-1L) <= 0L) {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"RowGeneratorMeta.CheckResult.WarnNoRows", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RowGeneratorMeta.CheckResult.WillReturnRows", (String[])new String[]{strLimit}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RowGeneratorMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RowGeneratorMeta.CheckResult.NoInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public RowGenerator createTransform(TransformMeta transformMeta, RowGeneratorData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new RowGenerator(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public RowGeneratorData getTransformData() {
        return new RowGeneratorData();
    }

    public ITransformIOMeta getTransformIOMeta() {
        return new TransformIOMeta(false, true, false, false, false, false);
    }

    public boolean isNeverEnding() {
        return this.neverEnding;
    }

    public void setNeverEnding(boolean neverEnding) {
        this.neverEnding = neverEnding;
    }

    public String getIntervalInMs() {
        return this.intervalInMs;
    }

    public void setIntervalInMs(String intervalInMs) {
        this.intervalInMs = intervalInMs;
    }

    public String getRowTimeField() {
        return this.rowTimeField;
    }

    public void setRowTimeField(String rowTimeField) {
        this.rowTimeField = rowTimeField;
    }

    public String getLastTimeField() {
        return this.lastTimeField;
    }

    public void setLastTimeField(String lastTimeField) {
        this.lastTimeField = lastTimeField;
    }

    public String getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    public List<GeneratorField> getFields() {
        return this.fields;
    }

    public void setFields(List<GeneratorField> fields) {
        this.fields = fields;
    }
}

