/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming;

import java.nio.ByteBuffer;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.translation.types.CoderTypeInformation;
import org.apache.beam.runners.flink.translation.wrappers.streaming.FlinkKeyUtils;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;

public class SdfByteBufferKeySelector<K, V>
implements KeySelector<WindowedValue<KV<KV<K, V>, Double>>, ByteBuffer>,
ResultTypeQueryable<ByteBuffer> {
    private final Coder<K> keyCoder;
    private final SerializablePipelineOptions pipelineOptions;

    public SdfByteBufferKeySelector(Coder<K> keyCoder, SerializablePipelineOptions pipelineOptions) {
        this.keyCoder = keyCoder;
        this.pipelineOptions = pipelineOptions;
    }

    public ByteBuffer getKey(WindowedValue<KV<KV<K, V>, Double>> value) {
        Object key = ((KV)((KV)value.getValue()).getKey()).getKey();
        return FlinkKeyUtils.encodeKey(key, this.keyCoder);
    }

    public TypeInformation<ByteBuffer> getProducedType() {
        return new CoderTypeInformation<ByteBuffer>((Coder<ByteBuffer>)FlinkKeyUtils.ByteBufferCoder.of(), this.pipelineOptions.get());
    }
}

