/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.construction.TransformInputs;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;

public class LookupPipelineVisitor
extends Pipeline.PipelineVisitor.Defaults {
    private final Map<PTransform<?, ?>, AppliedPTransform<?, ?, ?>> lookupTable = new HashMap();

    public Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform(TransformHierarchy.Node node) {
        if (node.getTransform() != null) {
            AppliedPTransform applied = node.toAppliedPTransform(this.getPipeline());
            this.lookupTable.put(applied.getTransform(), applied);
        }
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    public void visitPrimitiveTransform(TransformHierarchy.Node node) {
        AppliedPTransform applied = node.toAppliedPTransform(this.getPipeline());
        this.lookupTable.put(applied.getTransform(), applied);
    }

    private <InputT extends PInput, OutputT extends POutput> AppliedPTransform<InputT, OutputT, PTransform<InputT, OutputT>> applied(PTransform<InputT, OutputT> transform) {
        AppliedPTransform<?, ?, ?> applied = this.lookupTable.get(transform);
        if (applied == null) {
            throw new IllegalArgumentException(String.format("AppliedPTransform for %s does not exist.", transform));
        }
        return applied;
    }

    public Map<TupleTag<?>, PCollection<?>> getInputs(PTransform<?, ?> transform) {
        return this.applied(transform).getInputs();
    }

    public <T extends PValue> T getInput(PTransform<T, ?> transform) {
        return (T)((PValue)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(this.applied(transform))));
    }

    public Map<TupleTag<?>, PCollection<?>> getOutputs(PTransform<?, ?> transform) {
        return this.applied(transform).getOutputs();
    }

    public <T extends PValue> T getOutput(PTransform<?, T> transform) {
        return (T)((PValue)Iterables.getOnlyElement(this.applied(transform).getOutputs().values()));
    }

    public Map<TupleTag<?>, Coder<?>> getOutputCoders(PTransform<?, ?> transform) {
        return this.getOutputs(transform).entrySet().stream().filter(e -> e.getValue() instanceof PCollection).collect(Collectors.toMap(Map.Entry::getKey, e -> ((PCollection)e.getValue()).getCoder()));
    }
}

