/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.types;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.translation.wrappers.DataInputViewWrapper;
import org.apache.beam.runners.flink.translation.wrappers.DataOutputViewWrapper;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CoderTypeSerializer<T>
extends TypeSerializer<T> {
    private final Coder<T> coder;
    private final SerializablePipelineOptions pipelineOptions;
    private final boolean fasterCopy;

    public CoderTypeSerializer(Coder<T> coder, SerializablePipelineOptions pipelineOptions) {
        Preconditions.checkNotNull(coder);
        Preconditions.checkNotNull((Object)pipelineOptions);
        this.coder = coder;
        this.pipelineOptions = pipelineOptions;
        FlinkPipelineOptions options = (FlinkPipelineOptions)pipelineOptions.get().as(FlinkPipelineOptions.class);
        this.fasterCopy = options.getFasterCopy();
    }

    public boolean isImmutableType() {
        return false;
    }

    public CoderTypeSerializer<T> duplicate() {
        return new CoderTypeSerializer<T>(this.coder, this.pipelineOptions);
    }

    public T createInstance() {
        return null;
    }

    public T copy(T t) {
        if (this.fasterCopy) {
            return t;
        }
        try {
            return (T)CoderUtils.clone(this.coder, t);
        }
        catch (CoderException e) {
            throw new RuntimeException("Could not clone.", e);
        }
    }

    public T copy(T t, T reuse) {
        return this.copy(t);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T t, DataOutputView dataOutputView) throws IOException {
        DataOutputViewWrapper outputWrapper = new DataOutputViewWrapper(dataOutputView);
        this.coder.encode(t, (OutputStream)outputWrapper);
    }

    public T deserialize(DataInputView dataInputView) throws IOException {
        try {
            DataInputViewWrapper inputWrapper = new DataInputViewWrapper(dataInputView);
            return (T)this.coder.decode((InputStream)inputWrapper);
        }
        catch (CoderException e) {
            Throwable cause = e.getCause();
            if (cause instanceof EOFException) {
                throw (EOFException)cause;
            }
            throw e;
        }
    }

    public T deserialize(T t, DataInputView dataInputView) throws IOException {
        return this.deserialize(dataInputView);
    }

    public void copy(DataInputView dataInputView, DataOutputView dataOutputView) throws IOException {
        this.serialize(this.deserialize(dataInputView), dataOutputView);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CoderTypeSerializer that = (CoderTypeSerializer)((Object)o);
        return this.coder.equals(that.coder);
    }

    public int hashCode() {
        return this.coder.hashCode();
    }

    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new LegacySnapshot(this);
    }

    public String toString() {
        return "CoderTypeSerializer{coder=" + this.coder + '}';
    }

    public static class LegacySnapshot<T>
    extends TypeSerializerConfigSnapshot<T> {
        public LegacySnapshot() {
        }

        public LegacySnapshot(CoderTypeSerializer<T> serializer) {
            this.setPriorSerializer(serializer);
        }

        public int getVersion() {
            return 1;
        }

        public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

