/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.metrics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.flink.metrics.MetricsAccumulator;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkMetricContainer {
    public static final String ACCUMULATOR_NAME = "__metricscontainers";
    private static final Logger LOG = LoggerFactory.getLogger(FlinkMetricContainer.class);
    private static final String METRIC_KEY_SEPARATOR = GlobalConfiguration.loadConfiguration().getString(MetricOptions.SCOPE_DELIMITER);
    private final MetricsContainerStepMap metricsContainers;
    private final RuntimeContext runtimeContext;
    private final Map<String, Counter> flinkCounterCache;
    private final Map<String, FlinkDistributionGauge> flinkDistributionGaugeCache;
    private final Map<String, FlinkGauge> flinkGaugeCache;

    public FlinkMetricContainer(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
        this.flinkCounterCache = new HashMap<String, Counter>();
        this.flinkDistributionGaugeCache = new HashMap<String, FlinkDistributionGauge>();
        this.flinkGaugeCache = new HashMap<String, FlinkGauge>();
        this.metricsContainers = new MetricsContainerStepMap();
    }

    public MetricsContainerImpl getMetricsContainer(String stepName) {
        return this.metricsContainers.getContainer(stepName);
    }

    public void registerMetricsForPipelineResult() {
        Object metricsAccumulator = this.runtimeContext.getAccumulator(ACCUMULATOR_NAME);
        if (metricsAccumulator == null) {
            metricsAccumulator = new MetricsAccumulator();
            try {
                this.runtimeContext.addAccumulator(ACCUMULATOR_NAME, metricsAccumulator);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (Exception e) {
                LOG.error("Failed to create metrics accumulator.", (Throwable)e);
            }
        }
        metricsAccumulator.add((Object)this.metricsContainers);
    }

    public void updateMetrics(String stepName, List<MetricsApi.MonitoringInfo> monitoringInfos) {
        this.getMetricsContainer(stepName).update(monitoringInfos);
        this.updateMetrics(stepName);
    }

    void updateMetrics(String stepName) {
        MetricResults metricResults = MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)this.metricsContainers);
        MetricQueryResults metricQueryResults = metricResults.queryMetrics(MetricsFilter.builder().addStep(stepName).build());
        this.updateCounters(metricQueryResults.getCounters());
        this.updateDistributions(metricQueryResults.getDistributions());
        this.updateGauge(metricQueryResults.getGauges());
    }

    private void updateCounters(Iterable<MetricResult<Long>> counters) {
        for (MetricResult<Long> metricResult : counters) {
            String flinkMetricName = FlinkMetricContainer.getFlinkMetricNameString(metricResult.getKey());
            Long update = (Long)metricResult.getAttempted();
            Counter counter = this.flinkCounterCache.computeIfAbsent(flinkMetricName, n -> this.runtimeContext.getMetricGroup().counter(n));
            counter.inc(update - counter.getCount());
        }
    }

    private void updateDistributions(Iterable<MetricResult<DistributionResult>> distributions) {
        for (MetricResult<DistributionResult> metricResult : distributions) {
            String flinkMetricName = FlinkMetricContainer.getFlinkMetricNameString(metricResult.getKey());
            DistributionResult update = (DistributionResult)metricResult.getAttempted();
            FlinkDistributionGauge gauge = this.flinkDistributionGaugeCache.get(flinkMetricName);
            if (gauge == null) {
                gauge = (FlinkDistributionGauge)this.runtimeContext.getMetricGroup().gauge(flinkMetricName, (Gauge)new FlinkDistributionGauge(update));
                this.flinkDistributionGaugeCache.put(flinkMetricName, gauge);
                continue;
            }
            gauge.update(update);
        }
    }

    private void updateGauge(Iterable<MetricResult<GaugeResult>> gauges) {
        for (MetricResult<GaugeResult> metricResult : gauges) {
            String flinkMetricName = FlinkMetricContainer.getFlinkMetricNameString(metricResult.getKey());
            GaugeResult update = (GaugeResult)metricResult.getAttempted();
            FlinkGauge gauge = this.flinkGaugeCache.get(flinkMetricName);
            if (gauge == null) {
                gauge = (FlinkGauge)this.runtimeContext.getMetricGroup().gauge(flinkMetricName, (Gauge)new FlinkGauge(update));
                this.flinkGaugeCache.put(flinkMetricName, gauge);
                continue;
            }
            gauge.update(update);
        }
    }

    @VisibleForTesting
    static String getFlinkMetricNameString(MetricKey metricKey) {
        MetricName metricName = metricKey.metricName();
        return metricName.getNamespace() + METRIC_KEY_SEPARATOR + metricName.getName();
    }

    public static class FlinkGauge
    implements Gauge<Long> {
        GaugeResult data;

        FlinkGauge(GaugeResult data) {
            this.data = data;
        }

        void update(GaugeResult update) {
            this.data = update;
        }

        public Long getValue() {
            return this.data.getValue();
        }
    }

    public static class FlinkDistributionGauge
    implements Gauge<DistributionResult> {
        DistributionResult data;

        FlinkDistributionGauge(DistributionResult data) {
            this.data = data;
        }

        void update(DistributionResult data) {
            this.data = data;
        }

        public DistributionResult getValue() {
            return this.data;
        }
    }
}

