/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getfilesrowcount;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.getfilesrowcount.GetFilesRowsCount;
import org.apache.hop.pipeline.transforms.getfilesrowcount.GetFilesRowsCountData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.w3c.dom.Node;

@Transform(id="GetFilesRowsCount", image="getfilesrowcount.svg", name="i18n::BaseTransform.TypeLongDesc.GetFilesRowsCount", description="i18n::BaseTransform.TypeTooltipDesc.GetFilesRowsCount", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/getfilesrowcount.html")
public class GetFilesRowsCountMeta
extends BaseTransformMeta
implements ITransformMeta<GetFilesRowsCount, GetFilesRowsCountData> {
    private static final Class<?> PKG = GetFilesRowsCountMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private static final String NO = "N";
    private static final String YES = "Y";
    public static final String DEFAULT_ROWSCOUNT_FIELDNAME = "rowscount";
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private boolean includeFilesCount;
    private String filesCountFieldName;
    private String rowsCountFieldName;
    private String RowSeparatorFormat;
    private String RowSeparator;
    private boolean filefield;
    private boolean isaddresult;
    private String outputFilenameField;
    private String[] fileRequired;
    private String[] includeSubFolders;
    private boolean smartCount;

    public String getRowSeparator() {
        return this.RowSeparator;
    }

    public void setRowSeparator(String RowSeparatorin) {
        this.RowSeparator = RowSeparatorin;
    }

    public String getRowSeparatorFormat() {
        return this.RowSeparatorFormat;
    }

    public void setAddResultFile(boolean isaddresult) {
        this.isaddresult = isaddresult;
    }

    public void setSmartCount(boolean smartCount) {
        this.smartCount = smartCount;
    }

    public String[] getExcludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public boolean isAddResultFile() {
        return this.isaddresult;
    }

    public boolean isSmartCount() {
        return this.smartCount;
    }

    public String getOutputFilenameField() {
        return this.outputFilenameField;
    }

    public void setOutputFilenameField(String outputFilenameField) {
        this.outputFilenameField = outputFilenameField;
    }

    public boolean isFileField() {
        return this.filefield;
    }

    public void setFileField(boolean filefield) {
        this.filefield = filefield;
    }

    public void setRowSeparatorFormat(String RowSeparatorFormatin) {
        this.RowSeparatorFormat = RowSeparatorFormatin;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileRequired(String[] fileRequiredin) {
        for (int i = 0; i < fileRequiredin.length; ++i) {
            this.fileRequired[i] = this.getRequiredFilesCode(fileRequiredin[i]);
        }
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public boolean includeCountFiles() {
        return this.includeFilesCount;
    }

    public void setIncludeCountFiles(boolean includeFilesCount) {
        this.includeFilesCount = includeFilesCount;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public String getFilesCountFieldName() {
        return this.filesCountFieldName;
    }

    public String getRowsCountFieldName() {
        return this.rowsCountFieldName;
    }

    public void setFilesCountFieldName(String filesCountFieldName) {
        this.filesCountFieldName = filesCountFieldName;
    }

    public void setRowsCountFieldName(String rowsCountFieldName) {
        this.rowsCountFieldName = rowsCountFieldName;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        GetFilesRowsCountMeta retval = (GetFilesRowsCountMeta)((Object)super.clone());
        int nrFiles = this.fileName.length;
        retval.allocate(nrFiles);
        System.arraycopy(this.fileName, 0, retval.fileName, 0, nrFiles);
        System.arraycopy(this.fileMask, 0, retval.fileMask, 0, nrFiles);
        System.arraycopy(this.excludeFileMask, 0, retval.excludeFileMask, 0, nrFiles);
        System.arraycopy(this.fileRequired, 0, retval.fileRequired, 0, nrFiles);
        System.arraycopy(this.includeSubFolders, 0, retval.includeSubFolders, 0, nrFiles);
        return retval;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(300);
        retval.append("    ").append(XmlHandler.addTagValue((String)"files_count", (boolean)this.includeFilesCount));
        retval.append("    ").append(XmlHandler.addTagValue((String)"files_count_fieldname", (String)this.filesCountFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rows_count_fieldname", (String)this.rowsCountFieldName));
        retval.append("    ").append(XmlHandler.addTagValue((String)"rowseparator_format", (String)this.RowSeparatorFormat));
        retval.append("    ").append(XmlHandler.addTagValue((String)"row_separator", (String)this.RowSeparator));
        retval.append("    ").append(XmlHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append("    ").append(XmlHandler.addTagValue((String)"filefield", (boolean)this.filefield));
        retval.append("    ").append(XmlHandler.addTagValue((String)"filename_Field", (String)this.outputFilenameField));
        retval.append("    ").append(XmlHandler.addTagValue((String)"smartCount", (boolean)this.smartCount));
        retval.append("    <file>").append(Const.CR);
        for (int i = 0; i < this.fileName.length; ++i) {
            retval.append("      ").append(XmlHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      ").append(XmlHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        return retval.toString();
    }

    private String scrubOldRowSeparator(String original) {
        if (original != null) {
            if (original.equalsIgnoreCase("CR")) {
                return "LINEFEED";
            }
            if (original.equalsIgnoreCase("LF")) {
                return "CARRIAGERETURN";
            }
        }
        return original;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.includeFilesCount = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"files_count"));
            this.filesCountFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"files_count_fieldname");
            this.rowsCountFieldName = XmlHandler.getTagValue((Node)transformNode, (String)"rows_count_fieldname");
            this.RowSeparatorFormat = this.scrubOldRowSeparator(XmlHandler.getTagValue((Node)transformNode, (String)"rowseparator_format"));
            this.RowSeparator = XmlHandler.getTagValue((Node)transformNode, (String)"row_separator");
            this.smartCount = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"smartCount"));
            String addresult = XmlHandler.getTagValue((Node)transformNode, (String)"isaddresult");
            this.isaddresult = Utils.isEmpty((CharSequence)addresult) ? true : YES.equalsIgnoreCase(addresult);
            this.filefield = YES.equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"filefield"));
            this.outputFilenameField = XmlHandler.getTagValue((Node)transformNode, (String)"filename_Field");
            Node filenode = XmlHandler.getSubNode((Node)transformNode, (String)"file");
            int nrFiles = XmlHandler.countNodes((Node)filenode, (String)"name");
            this.allocate(nrFiles);
            for (int i = 0; i < nrFiles; ++i) {
                Node filenamenode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XmlHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XmlHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XmlHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XmlHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XmlHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XmlHandler.getNodeValue((Node)includeSubFoldersnode);
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrfiles) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
    }

    public void setDefault() {
        this.smartCount = false;
        this.outputFilenameField = "";
        this.filefield = false;
        this.isaddresult = true;
        this.includeFilesCount = false;
        this.filesCountFieldName = "";
        this.rowsCountFieldName = DEFAULT_ROWSCOUNT_FIELDNAME;
        this.RowSeparatorFormat = "CR";
        this.RowSeparator = "";
        int nrFiles = 0;
        this.allocate(nrFiles);
        for (int i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = RequiredFilesCode[0];
            this.includeSubFolders[i] = RequiredFilesCode[0];
        }
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaInteger v = new ValueMetaInteger(variables.resolve(this.rowsCountFieldName));
        v.setLength(10, 0);
        v.setOrigin(name);
        r.addValueMeta((IValueMeta)v);
        if (this.includeFilesCount) {
            v = new ValueMetaInteger(variables.resolve(this.filesCountFieldName));
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    public FileInputList getFiles(IVariables variables) {
        return FileInputList.createFileList((IVariables)variables, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        FileInputList fileInputList = this.getFiles(variables);
        if (fileInputList == null || fileInputList.getFiles().size() == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.NoFiles", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.RowSeparatorFormat.equals("CUSTOM") && this.RowSeparator == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.NoSeparator", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GetFilesRowsCountMeta.CheckResult.SeparatorOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public GetFilesRowsCount createTransform(TransformMeta transformMeta, GetFilesRowsCountData data, int cnr, PipelineMeta tr, Pipeline pipeline) {
        return new GetFilesRowsCount(transformMeta, this, data, cnr, tr, pipeline);
    }

    public GetFilesRowsCountData getTransformData() {
        return new GetFilesRowsCountData();
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.filefield) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.fileName[i]));
                    this.fileName[i] = iResourceNaming.nameResource(fileObject, variables, Utils.isEmpty((CharSequence)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }
}

