/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getfilesrowcount;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.getfilesrowcount.GetFilesRowsCountMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class GetFilesRowsCountDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = GetFilesRowsCountMeta.class;
    private Label wlExcludeFilemask;
    private TextVar wExcludeFilemask;
    private Label wlFilename;
    private Button wbbFilename;
    private Button wbdFilename;
    private Button wbeFilename;
    private Button wbaFilename;
    private TextVar wFilename;
    private Label wlFilenameList;
    private TableView wFilenameList;
    private Label wlFilemask;
    private TextVar wFilemask;
    private Button wbShowFiles;
    private Button wInclFilesCount;
    private Label wlInclFilesCountField;
    private TextVar wInclFilesCountField;
    private TextVar wRowsCountField;
    private Label wlRowSeparator;
    private TextVar wRowSeparator;
    private CCombo wRowSeparatorFormat;
    private GetFilesRowsCountMeta input;
    private Button wFileField;
    private Button wAddResult;
    private Button wSmartCount;
    private Label wlFilenameField;
    private CCombo wFilenameField;

    public GetFilesRowsCountDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (GetFilesRowsCountMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.Button.PreviewRows", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wFileTab = new CTabItem(wTabFolder, 0);
        wFileTab.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.File.Tab", (String[])new String[0]));
        Composite wFileComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wFileComp.setLayout((Layout)fileLayout);
        Group wOriginFiles = new Group(wFileComp, 32);
        this.props.setLook((Control)wOriginFiles);
        wOriginFiles.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.wOriginFiles.Label", (String[])new String[0]));
        FormLayout OriginFilesgroupLayout = new FormLayout();
        OriginFilesgroupLayout.marginWidth = 10;
        OriginFilesgroupLayout.marginHeight = 10;
        wOriginFiles.setLayout((Layout)OriginFilesgroupLayout);
        Label wlFileField = new Label((Composite)wOriginFiles, 131072);
        wlFileField.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.FileField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFileField);
        FormData fdlFileField = new FormData();
        fdlFileField.left = new FormAttachment(0, -margin);
        fdlFileField.top = new FormAttachment(0, margin);
        fdlFileField.right = new FormAttachment(middle, -2 * margin);
        wlFileField.setLayoutData((Object)fdlFileField);
        this.wFileField = new Button((Composite)wOriginFiles, 32);
        this.props.setLook((Control)this.wFileField);
        this.wFileField.setToolTipText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.FileField.Tooltip", (String[])new String[0]));
        FormData fdFileField = new FormData();
        fdFileField.left = new FormAttachment(middle, -margin);
        fdFileField.top = new FormAttachment((Control)wlFileField, 0, 0x1000000);
        this.wFileField.setLayoutData((Object)fdFileField);
        SelectionAdapter lsFileField = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetFilesRowsCountDialog.this.activateFileField();
                GetFilesRowsCountDialog.this.input.setChanged();
            }
        };
        this.wFileField.addSelectionListener((SelectionListener)lsFileField);
        this.wlFilenameField = new Label((Composite)wOriginFiles, 131072);
        this.wlFilenameField.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.FilenameField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilenameField);
        FormData fdlFilenameField = new FormData();
        fdlFilenameField.left = new FormAttachment(0, -margin);
        fdlFilenameField.top = new FormAttachment((Control)this.wFileField, margin);
        fdlFilenameField.right = new FormAttachment(middle, -2 * margin);
        this.wlFilenameField.setLayoutData((Object)fdlFilenameField);
        this.wFilenameField = new CCombo((Composite)wOriginFiles, 2056);
        this.wFilenameField.setEditable(true);
        this.props.setLook((Control)this.wFilenameField);
        this.wFilenameField.addModifyListener(lsMod);
        FormData fdFilenameField = new FormData();
        fdFilenameField.left = new FormAttachment(middle, -margin);
        fdFilenameField.top = new FormAttachment((Control)this.wFileField, margin);
        fdFilenameField.right = new FormAttachment(100, -margin);
        this.wFilenameField.setLayoutData((Object)fdFilenameField);
        this.wFilenameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)GetFilesRowsCountDialog.this.shell.getDisplay(), 1);
                GetFilesRowsCountDialog.this.shell.setCursor(busy);
                GetFilesRowsCountDialog.this.setFileField();
                GetFilesRowsCountDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        FormData fdOriginFiles = new FormData();
        fdOriginFiles.left = new FormAttachment(0, margin);
        fdOriginFiles.top = new FormAttachment((Control)this.wFilenameList, margin);
        fdOriginFiles.right = new FormAttachment(100, -margin);
        wOriginFiles.setLayoutData((Object)fdOriginFiles);
        this.wlFilename = new Label(wFileComp, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)wOriginFiles, margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wbbFilename = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.FilenameBrowse.Button", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)wOriginFiles, margin);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wbaFilename = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbaFilename);
        this.wbaFilename.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.FilenameAdd.Button", (String[])new String[0]));
        this.wbaFilename.setToolTipText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.FilenameAdd.Tooltip", (String[])new String[0]));
        FormData fdbaFilename = new FormData();
        fdbaFilename.right = new FormAttachment((Control)this.wbbFilename, -margin);
        fdbaFilename.top = new FormAttachment((Control)wOriginFiles, margin);
        this.wbaFilename.setLayoutData((Object)fdbaFilename);
        this.wFilename = new TextVar(this.variables, wFileComp, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.right = new FormAttachment((Control)this.wbaFilename, -margin);
        fdFilename.top = new FormAttachment((Control)wOriginFiles, margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wlFilemask = new Label(wFileComp, 131072);
        this.wlFilemask.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RegExp.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilemask);
        FormData fdlFilemask = new FormData();
        fdlFilemask.left = new FormAttachment(0, 0);
        fdlFilemask.top = new FormAttachment((Control)this.wFilename, margin);
        fdlFilemask.right = new FormAttachment(middle, -margin);
        this.wlFilemask.setLayoutData((Object)fdlFilemask);
        this.wFilemask = new TextVar(this.variables, wFileComp, 18436);
        this.props.setLook((Control)this.wFilemask);
        this.wFilemask.addModifyListener(lsMod);
        FormData fdFilemask = new FormData();
        fdFilemask.left = new FormAttachment(middle, 0);
        fdFilemask.top = new FormAttachment((Control)this.wFilename, margin);
        fdFilemask.right = new FormAttachment((Control)this.wFilename, 0, 131072);
        this.wFilemask.setLayoutData((Object)fdFilemask);
        this.wlExcludeFilemask = new Label(wFileComp, 131072);
        this.wlExcludeFilemask.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsDialog.ExcludeFilemask.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlExcludeFilemask);
        FormData fdlExcludeFilemask = new FormData();
        fdlExcludeFilemask.left = new FormAttachment(0, 0);
        fdlExcludeFilemask.top = new FormAttachment((Control)this.wFilemask, margin);
        fdlExcludeFilemask.right = new FormAttachment(middle, -margin);
        this.wlExcludeFilemask.setLayoutData((Object)fdlExcludeFilemask);
        this.wExcludeFilemask = new TextVar(this.variables, wFileComp, 18436);
        this.props.setLook((Control)this.wExcludeFilemask);
        this.wExcludeFilemask.addModifyListener(lsMod);
        FormData fdExcludeFilemask = new FormData();
        fdExcludeFilemask.left = new FormAttachment(middle, 0);
        fdExcludeFilemask.top = new FormAttachment((Control)this.wFilemask, margin);
        fdExcludeFilemask.right = new FormAttachment((Control)this.wFilename, 0, 131072);
        this.wExcludeFilemask.setLayoutData((Object)fdExcludeFilemask);
        this.wlFilenameList = new Label(wFileComp, 131072);
        this.wlFilenameList.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.FilenameList.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilenameList);
        FormData fdlFilenameList = new FormData();
        fdlFilenameList.left = new FormAttachment(0, 0);
        fdlFilenameList.top = new FormAttachment((Control)this.wExcludeFilemask, margin);
        fdlFilenameList.right = new FormAttachment(middle, -margin);
        this.wlFilenameList.setLayoutData((Object)fdlFilenameList);
        this.wbdFilename = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbdFilename);
        this.wbdFilename.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.FilenameRemove.Button", (String[])new String[0]));
        this.wbdFilename.setToolTipText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.FilenameRemove.Tooltip", (String[])new String[0]));
        FormData fdbdFilename = new FormData();
        fdbdFilename.right = new FormAttachment(100, 0);
        fdbdFilename.top = new FormAttachment((Control)this.wlFilenameList, 0, 128);
        this.wbdFilename.setLayoutData((Object)fdbdFilename);
        this.wbeFilename = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbeFilename);
        this.wbeFilename.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.FilenameEdit.Button", (String[])new String[0]));
        this.wbeFilename.setToolTipText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.FilenameEdit.Tooltip", (String[])new String[0]));
        FormData fdbeFilename = new FormData();
        fdbeFilename.right = new FormAttachment(100, 0);
        fdbeFilename.left = new FormAttachment((Control)this.wbdFilename, 0, 16384);
        fdbeFilename.top = new FormAttachment((Control)this.wbdFilename, margin);
        this.wbeFilename.setLayoutData((Object)fdbeFilename);
        this.wbShowFiles = new Button(wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.ShowFiles.Button", (String[])new String[0]));
        FormData fdbShowFiles = new FormData();
        fdbShowFiles.left = new FormAttachment(middle, 0);
        fdbShowFiles.bottom = new FormAttachment(100, 0);
        this.wbShowFiles.setLayoutData((Object)fdbShowFiles);
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.Files.Filename.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.Files.Wildcard.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFilesRowsDialog.Files.ExcludeWildcard.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.Required.Column", (String[])new String[0]), 2, GetFilesRowsCountMeta.RequiredFilesDesc), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.IncludeSubDirs.Column", (String[])new String[0]), 2, GetFilesRowsCountMeta.RequiredFilesDesc)};
        colinfo[0].setUsingVariables(true);
        colinfo[1].setUsingVariables(true);
        colinfo[1].setToolTip(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.Files.Wildcard.Tooltip", (String[])new String[0]));
        colinfo[2].setUsingVariables(true);
        colinfo[2].setToolTip(BaseMessages.getString(PKG, (String)"GetFilesRowsDialog.Files.ExcludeWildcard.Tooltip", (String[])new String[0]));
        this.wFilenameList = new TableView(this.variables, wFileComp, 67588, colinfo, 2, lsMod, this.props);
        this.props.setLook((Control)this.wFilenameList);
        FormData fdFilenameList = new FormData();
        fdFilenameList.left = new FormAttachment(middle, 0);
        fdFilenameList.right = new FormAttachment((Control)this.wbdFilename, -margin);
        fdFilenameList.top = new FormAttachment((Control)this.wExcludeFilemask, margin);
        fdFilenameList.bottom = new FormAttachment((Control)this.wbShowFiles, -margin);
        this.wFilenameList.setLayoutData((Object)fdFilenameList);
        FormData fdFileComp = new FormData();
        fdFileComp.left = new FormAttachment(0, 0);
        fdFileComp.top = new FormAttachment(0, 0);
        fdFileComp.right = new FormAttachment(100, 0);
        fdFileComp.bottom = new FormAttachment(100, 0);
        wFileComp.setLayoutData((Object)fdFileComp);
        wFileComp.layout();
        wFileTab.setControl((Control)wFileComp);
        CTabItem wContentTab = new CTabItem(wTabFolder, 0);
        wContentTab.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.Content.Tab", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        Composite wContentComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wContentComp);
        wContentComp.setLayout((Layout)contentLayout);
        Group wFilesCountFieldGroup = new Group(wContentComp, 32);
        this.props.setLook((Control)wFilesCountFieldGroup);
        wFilesCountFieldGroup.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.Group.CountFilesFieldGroup.Label", (String[])new String[0]));
        FormLayout countfilesfieldgroupLayout = new FormLayout();
        countfilesfieldgroupLayout.marginWidth = 10;
        countfilesfieldgroupLayout.marginHeight = 10;
        wFilesCountFieldGroup.setLayout((Layout)countfilesfieldgroupLayout);
        Label wlRowsCountField = new Label((Composite)wFilesCountFieldGroup, 131072);
        wlRowsCountField.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowsCountField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRowsCountField);
        FormData fdlRowsCountField = new FormData();
        fdlRowsCountField.left = new FormAttachment((Control)this.wInclFilesCount, margin);
        fdlRowsCountField.top = new FormAttachment(0, margin);
        wlRowsCountField.setLayoutData((Object)fdlRowsCountField);
        this.wRowsCountField = new TextVar(this.variables, (Composite)wFilesCountFieldGroup, 18436);
        this.props.setLook((Control)this.wRowsCountField);
        this.wRowsCountField.setToolTipText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowsCountField.Tooltip", (String[])new String[0]));
        this.wRowsCountField.addModifyListener(lsMod);
        FormData fdRowsCountField = new FormData();
        fdRowsCountField.left = new FormAttachment((Control)wlRowsCountField, margin);
        fdRowsCountField.top = new FormAttachment(0, margin);
        fdRowsCountField.right = new FormAttachment(100, 0);
        this.wRowsCountField.setLayoutData((Object)fdRowsCountField);
        FormData fdFilesCountFieldGroup = new FormData();
        fdFilesCountFieldGroup.left = new FormAttachment(0, margin);
        fdFilesCountFieldGroup.top = new FormAttachment(0, margin);
        fdFilesCountFieldGroup.right = new FormAttachment(100, -margin);
        wFilesCountFieldGroup.setLayoutData((Object)fdFilesCountFieldGroup);
        Group wRowSeparatorGroup = new Group(wContentComp, 32);
        this.props.setLook((Control)wRowSeparatorGroup);
        wRowSeparatorGroup.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.Group.RowSeparator.Label", (String[])new String[0]));
        FormLayout rowseparatorgroupLayout = new FormLayout();
        rowseparatorgroupLayout.marginWidth = 10;
        rowseparatorgroupLayout.marginHeight = 10;
        wRowSeparatorGroup.setLayout((Layout)rowseparatorgroupLayout);
        Label wlRowSeparatorFormat = new Label((Composite)wRowSeparatorGroup, 131072);
        wlRowSeparatorFormat.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowSeparatorFormat.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRowSeparatorFormat);
        FormData fdlRowSeparatorFormat = new FormData();
        fdlRowSeparatorFormat.left = new FormAttachment(0, 0);
        fdlRowSeparatorFormat.top = new FormAttachment((Control)wFilesCountFieldGroup, margin);
        fdlRowSeparatorFormat.right = new FormAttachment(middle, -margin);
        wlRowSeparatorFormat.setLayoutData((Object)fdlRowSeparatorFormat);
        this.wRowSeparatorFormat = new CCombo((Composite)wRowSeparatorGroup, 2056);
        this.props.setLook((Control)this.wRowSeparatorFormat);
        this.wRowSeparatorFormat.add(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowSeparatorFormat.CR.Label", (String[])new String[0]));
        this.wRowSeparatorFormat.add(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowSeparatorFormat.LF.Label", (String[])new String[0]));
        this.wRowSeparatorFormat.add(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowSeparatorFormat.CRLF.Label", (String[])new String[0]));
        this.wRowSeparatorFormat.add(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowSeparatorFormat.TAB.Label", (String[])new String[0]));
        this.wRowSeparatorFormat.add(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowSeparatorFormat.CUSTOM.Label", (String[])new String[0]));
        this.wRowSeparatorFormat.select(0);
        this.wRowSeparatorFormat.addModifyListener(lsMod);
        FormData fdRowSeparatorFormat = new FormData();
        fdRowSeparatorFormat.left = new FormAttachment(middle, 0);
        fdRowSeparatorFormat.top = new FormAttachment((Control)wFilesCountFieldGroup, margin);
        fdRowSeparatorFormat.right = new FormAttachment(100, 0);
        this.wRowSeparatorFormat.setLayoutData((Object)fdRowSeparatorFormat);
        this.wRowSeparatorFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetFilesRowsCountDialog.this.activeRowSeparator();
            }
        });
        this.wlRowSeparator = new Label((Composite)wRowSeparatorGroup, 131072);
        this.wlRowSeparator.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowSeparator.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlRowSeparator);
        FormData fdlRowSeparator = new FormData();
        fdlRowSeparator.left = new FormAttachment((Control)this.wInclFilesCount, margin);
        fdlRowSeparator.top = new FormAttachment((Control)this.wRowSeparatorFormat, margin);
        this.wlRowSeparator.setLayoutData((Object)fdlRowSeparator);
        this.wRowSeparator = new TextVar(this.variables, (Composite)wRowSeparatorGroup, 18436);
        this.props.setLook((Control)this.wRowSeparator);
        this.wRowSeparator.setToolTipText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.RowSeparator.Tooltip", (String[])new String[0]));
        this.wRowSeparator.addModifyListener(lsMod);
        FormData fdRowSeparator = new FormData();
        fdRowSeparator.left = new FormAttachment((Control)this.wlRowSeparator, margin);
        fdRowSeparator.top = new FormAttachment((Control)this.wRowSeparatorFormat, margin);
        fdRowSeparator.right = new FormAttachment(100, 0);
        this.wRowSeparator.setLayoutData((Object)fdRowSeparator);
        Label wlSmartCount = new Label((Composite)wRowSeparatorGroup, 131072);
        wlSmartCount.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.SmartCount.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSmartCount);
        FormData fdlSmartCount = new FormData();
        fdlSmartCount.left = new FormAttachment(0, 0);
        fdlSmartCount.top = new FormAttachment((Control)this.wRowSeparator, margin);
        fdlSmartCount.right = new FormAttachment(middle, -margin);
        wlSmartCount.setLayoutData((Object)fdlSmartCount);
        this.wSmartCount = new Button((Composite)wRowSeparatorGroup, 32);
        this.props.setLook((Control)this.wSmartCount);
        this.wSmartCount.setToolTipText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.SmartCount.Tooltip", (String[])new String[0]));
        FormData fdSmartCount = new FormData();
        fdSmartCount.left = new FormAttachment(middle, 0);
        fdSmartCount.top = new FormAttachment((Control)wlSmartCount, 0, 0x1000000);
        this.wSmartCount.setLayoutData((Object)fdSmartCount);
        this.wSmartCount.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GetFilesRowsCountDialog.this.input.setChanged();
            }
        });
        FormData fdRowSeparatorGroup = new FormData();
        fdRowSeparatorGroup.left = new FormAttachment(0, margin);
        fdRowSeparatorGroup.top = new FormAttachment((Control)wFilesCountFieldGroup, margin);
        fdRowSeparatorGroup.right = new FormAttachment(100, -margin);
        wRowSeparatorGroup.setLayoutData((Object)fdRowSeparatorGroup);
        Group wAdditionalGroup = new Group(wContentComp, 32);
        this.props.setLook((Control)wAdditionalGroup);
        wAdditionalGroup.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.Group.AdditionalGroup.Label", (String[])new String[0]));
        FormLayout additionalgroupLayout = new FormLayout();
        additionalgroupLayout.marginWidth = 10;
        additionalgroupLayout.marginHeight = 10;
        wAdditionalGroup.setLayout((Layout)additionalgroupLayout);
        Label wlInclFilesCount = new Label((Composite)wAdditionalGroup, 131072);
        wlInclFilesCount.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.InclCountFiles.Label", (String[])new String[0]));
        this.props.setLook((Control)wlInclFilesCount);
        FormData fdlInclFilesCount = new FormData();
        fdlInclFilesCount.left = new FormAttachment(0, 0);
        fdlInclFilesCount.top = new FormAttachment((Control)wRowSeparatorGroup, margin);
        fdlInclFilesCount.right = new FormAttachment(middle, -margin);
        wlInclFilesCount.setLayoutData((Object)fdlInclFilesCount);
        this.wInclFilesCount = new Button((Composite)wAdditionalGroup, 32);
        this.props.setLook((Control)this.wInclFilesCount);
        this.wInclFilesCount.setToolTipText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.InclCountFiles.Tooltip", (String[])new String[0]));
        FormData fdFilesCount = new FormData();
        fdFilesCount.left = new FormAttachment(middle, 0);
        fdFilesCount.top = new FormAttachment((Control)wRowSeparatorGroup, margin);
        this.wInclFilesCount.setLayoutData((Object)fdFilesCount);
        this.wlInclFilesCountField = new Label((Composite)wAdditionalGroup, 131072);
        this.wlInclFilesCountField.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.InclCountFilesField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclFilesCountField);
        FormData fdlInclFilesCountField = new FormData();
        fdlInclFilesCountField.left = new FormAttachment((Control)this.wInclFilesCount, margin);
        fdlInclFilesCountField.top = new FormAttachment((Control)wRowSeparatorGroup, margin);
        this.wlInclFilesCountField.setLayoutData((Object)fdlInclFilesCountField);
        this.wInclFilesCountField = new TextVar(this.variables, (Composite)wAdditionalGroup, 18436);
        this.props.setLook((Control)this.wInclFilesCountField);
        this.wInclFilesCountField.addModifyListener(lsMod);
        FormData fdInclFilesCountField = new FormData();
        fdInclFilesCountField.left = new FormAttachment((Control)this.wlInclFilesCountField, margin);
        fdInclFilesCountField.top = new FormAttachment((Control)this.wlInclFilesCountField, 0, 0x1000000);
        fdInclFilesCountField.right = new FormAttachment(100, 0);
        this.wInclFilesCountField.setLayoutData((Object)fdInclFilesCountField);
        FormData fdAdditionalGroup = new FormData();
        fdAdditionalGroup.left = new FormAttachment(0, margin);
        fdAdditionalGroup.top = new FormAttachment((Control)wRowSeparatorGroup, margin);
        fdAdditionalGroup.right = new FormAttachment(100, -margin);
        wAdditionalGroup.setLayoutData((Object)fdAdditionalGroup);
        Group wAddFileResult = new Group(wContentComp, 32);
        this.props.setLook((Control)wAddFileResult);
        wAddFileResult.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.wAddFileResult.Label", (String[])new String[0]));
        FormLayout AddFileResultgroupLayout = new FormLayout();
        AddFileResultgroupLayout.marginWidth = 10;
        AddFileResultgroupLayout.marginHeight = 10;
        wAddFileResult.setLayout((Layout)AddFileResultgroupLayout);
        Label wlAddResult = new Label((Composite)wAddFileResult, 131072);
        wlAddResult.setText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.AddResult.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddResult);
        FormData fdlAddResult = new FormData();
        fdlAddResult.left = new FormAttachment(0, 0);
        fdlAddResult.top = new FormAttachment((Control)wAdditionalGroup, margin);
        fdlAddResult.right = new FormAttachment(middle, -margin);
        wlAddResult.setLayoutData((Object)fdlAddResult);
        this.wAddResult = new Button((Composite)wAddFileResult, 32);
        this.props.setLook((Control)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.AddResult.Tooltip", (String[])new String[0]));
        FormData fdAddResult = new FormData();
        fdAddResult.left = new FormAttachment(middle, 0);
        fdAddResult.top = new FormAttachment((Control)wlAddResult, 0, 0x1000000);
        this.wAddResult.setLayoutData((Object)fdAddResult);
        this.wAddResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GetFilesRowsCountDialog.this.input.setChanged();
            }
        });
        FormData fdAddFileResult = new FormData();
        fdAddFileResult.left = new FormAttachment(0, margin);
        fdAddFileResult.top = new FormAttachment((Control)wAdditionalGroup, margin);
        fdAddFileResult.right = new FormAttachment(100, -margin);
        wAddFileResult.setLayoutData((Object)fdAddFileResult);
        FormData fdContentComp = new FormData();
        fdContentComp.left = new FormAttachment(0, 0);
        fdContentComp.top = new FormAttachment(0, 0);
        fdContentComp.right = new FormAttachment(100, 0);
        fdContentComp.bottom = new FormAttachment(100, 0);
        wContentComp.setLayoutData((Object)fdContentComp);
        wContentComp.layout();
        wContentTab.setControl((Control)wContentComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        SelectionAdapter selA = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetFilesRowsCountDialog.this.wFilenameList.add(new String[]{GetFilesRowsCountDialog.this.wFilename.getText(), GetFilesRowsCountDialog.this.wFilemask.getText(), GetFilesRowsCountDialog.this.wExcludeFilemask.getText(), GetFilesRowsCountMeta.RequiredFilesCode[0], GetFilesRowsCountMeta.RequiredFilesCode[0]});
                GetFilesRowsCountDialog.this.wFilename.setText("");
                GetFilesRowsCountDialog.this.wFilemask.setText("");
                GetFilesRowsCountDialog.this.wExcludeFilemask.setText("");
                GetFilesRowsCountDialog.this.wFilenameList.removeEmptyRows();
                GetFilesRowsCountDialog.this.wFilenameList.setRowNums();
                GetFilesRowsCountDialog.this.wFilenameList.optWidth(true);
            }
        };
        this.wbaFilename.addSelectionListener((SelectionListener)selA);
        this.wFilename.addSelectionListener(selA);
        this.wbdFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = GetFilesRowsCountDialog.this.wFilenameList.getSelectionIndices();
                GetFilesRowsCountDialog.this.wFilenameList.remove(idx);
                GetFilesRowsCountDialog.this.wFilenameList.removeEmptyRows();
                GetFilesRowsCountDialog.this.wFilenameList.setRowNums();
                GetFilesRowsCountDialog.this.input.setChanged();
            }
        });
        this.wbeFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int idx = GetFilesRowsCountDialog.this.wFilenameList.getSelectionIndex();
                if (idx >= 0) {
                    String[] string = GetFilesRowsCountDialog.this.wFilenameList.getItem(idx);
                    GetFilesRowsCountDialog.this.wFilename.setText(string[0]);
                    GetFilesRowsCountDialog.this.wFilemask.setText(string[1]);
                    GetFilesRowsCountDialog.this.wExcludeFilemask.setText(string[2]);
                    GetFilesRowsCountDialog.this.wFilenameList.remove(idx);
                }
                GetFilesRowsCountDialog.this.wFilenameList.removeEmptyRows();
                GetFilesRowsCountDialog.this.wFilenameList.setRowNums();
                GetFilesRowsCountDialog.this.input.setChanged();
            }
        });
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    GetFilesRowsCountMeta tfii = new GetFilesRowsCountMeta();
                    GetFilesRowsCountDialog.this.getInfo(tfii);
                    FileInputList fileInputList = tfii.getFiles(GetFilesRowsCountDialog.this.variables);
                    String[] files = fileInputList.getFileStrings();
                    if (files.length > 0) {
                        EnterSelectionDialog esd = new EnterSelectionDialog(GetFilesRowsCountDialog.this.shell, files, BaseMessages.getString((Class)PKG, (String)"GetFilesRowsCountDialog.FilesReadSelection.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"GetFilesRowsCountDialog.FilesReadSelection.DialogMessage", (String[])new String[0]));
                        esd.setViewOnly();
                        esd.open();
                    } else {
                        MessageBox mb = new MessageBox(GetFilesRowsCountDialog.this.shell, 33);
                        mb.setMessage(BaseMessages.getString((Class)PKG, (String)"GetFilesRowsCountDialog.NoFileFound.DialogMessage", (String[])new String[0]));
                        mb.setText(BaseMessages.getString((Class)PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                        mb.open();
                    }
                }
                catch (HopException ex) {
                    new ErrorDialog(GetFilesRowsCountDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"GetFilesRowsCountDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"GetFilesRowsCountDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), (Exception)((Object)ex));
                }
            }
        });
        this.wInclFilesCount.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetFilesRowsCountDialog.this.setIncludeRownum();
                GetFilesRowsCountDialog.this.input.setChanged();
            }
        });
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(""));
        this.wbbFilename.addListener(13, e -> {
            if (!Utils.isEmpty((CharSequence)this.wFilemask.getText()) || !Utils.isEmpty((CharSequence)this.wExcludeFilemask.getText())) {
                BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wFilemask, (IVariables)this.variables);
            } else {
                BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true);
            }
        });
        wTabFolder.setSelection(0);
        this.getData(this.input);
        this.activateFileField();
        this.activeRowSeparator();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void activeRowSeparator() {
        this.wRowSeparator.setEnabled(this.wRowSeparatorFormat.getSelectionIndex() == 3);
        this.wlRowSeparator.setEnabled(this.wRowSeparatorFormat.getSelectionIndex() == 3);
    }

    public void setIncludeRownum() {
        this.wlInclFilesCountField.setEnabled(this.wInclFilesCount.getSelection());
        this.wInclFilesCountField.setEnabled(this.wInclFilesCount.getSelection());
    }

    private void activateFileField() {
        this.wlFilenameField.setEnabled(this.wFileField.getSelection());
        this.wFilenameField.setEnabled(this.wFileField.getSelection());
        this.wlFilename.setEnabled(!this.wFileField.getSelection());
        this.wbbFilename.setEnabled(!this.wFileField.getSelection());
        this.wbaFilename.setEnabled(!this.wFileField.getSelection());
        this.wFilename.setEnabled(!this.wFileField.getSelection());
        this.wlFilemask.setEnabled(!this.wFileField.getSelection());
        this.wFilemask.setEnabled(!this.wFileField.getSelection());
        this.wlExcludeFilemask.setEnabled(!this.wFileField.getSelection());
        this.wExcludeFilemask.setEnabled(!this.wFileField.getSelection());
        this.wlFilenameList.setEnabled(!this.wFileField.getSelection());
        this.wbdFilename.setEnabled(!this.wFileField.getSelection());
        this.wbeFilename.setEnabled(!this.wFileField.getSelection());
        this.wbShowFiles.setEnabled(!this.wFileField.getSelection());
        this.wlFilenameList.setEnabled(!this.wFileField.getSelection());
        this.wFilenameList.setEnabled(!this.wFileField.getSelection());
        this.wPreview.setEnabled(!this.wFileField.getSelection());
    }

    private void setFileField() {
        try {
            this.wFilenameField.removeAll();
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                r.getFieldNames();
                for (int i = 0; i < r.getFieldNames().length; ++i) {
                    this.wFilenameField.add(r.getFieldNames()[i]);
                }
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void getData(GetFilesRowsCountMeta in) {
        if (in.getFileName() != null) {
            this.wFilenameList.removeAll();
            for (int i = 0; i < in.getFileName().length; ++i) {
                this.wFilenameList.add(new String[]{in.getFileName()[i], in.getFileMask()[i], in.getExcludeFileMask()[i], in.getRequiredFilesDesc(in.getFileRequired()[i]), in.getRequiredFilesDesc(in.getIncludeSubFolders()[i])});
            }
            this.wFilenameList.removeEmptyRows();
            this.wFilenameList.setRowNums();
            this.wFilenameList.optWidth(true);
        }
        this.wInclFilesCount.setSelection(in.includeCountFiles());
        this.wSmartCount.setSelection(in.isSmartCount());
        if (in.getFilesCountFieldName() != null) {
            this.wInclFilesCountField.setText(in.getFilesCountFieldName());
        } else {
            this.wInclFilesCountField.setText("filescount");
        }
        if (in.getRowsCountFieldName() != null) {
            this.wRowsCountField.setText(in.getRowsCountFieldName());
        } else {
            this.wRowsCountField.setText("rowscount");
        }
        if (in.getRowSeparatorFormat() != null) {
            if (in.getRowSeparatorFormat().equals("CARRIAGERETURN") || in.getRowSeparatorFormat().equals("CR")) {
                this.wRowSeparatorFormat.select(0);
            } else if (in.getRowSeparatorFormat().equals("LINEFEED") || in.getRowSeparatorFormat().equals("LF")) {
                this.wRowSeparatorFormat.select(1);
            } else if (in.getRowSeparatorFormat().equals("CRLF")) {
                this.wRowSeparatorFormat.select(2);
            } else if (in.getRowSeparatorFormat().equals("TAB")) {
                this.wRowSeparatorFormat.select(3);
            } else {
                this.wRowSeparatorFormat.select(4);
            }
        } else {
            this.wRowSeparatorFormat.select(0);
        }
        if (in.getRowSeparator() != null) {
            this.wRowSeparator.setText(in.getRowSeparator());
        }
        this.wAddResult.setSelection(in.isAddResultFile());
        this.wFileField.setSelection(in.isFileField());
        if (in.getOutputFilenameField() != null) {
            this.wFilenameField.setText(in.getOutputFilenameField());
        }
        this.logDebug(BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        this.setIncludeRownum();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        try {
            this.getInfo(this.input);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    private void getInfo(GetFilesRowsCountMeta in) throws HopException {
        this.transformName = this.wTransformName.getText();
        in.setIncludeCountFiles(this.wInclFilesCount.getSelection());
        in.setFilesCountFieldName(this.wInclFilesCountField.getText());
        in.setRowsCountFieldName(this.wRowsCountField.getText());
        if (this.wRowSeparatorFormat.getSelectionIndex() == 0) {
            in.setRowSeparatorFormat("CARRIAGERETURN");
        } else if (this.wRowSeparatorFormat.getSelectionIndex() == 1) {
            in.setRowSeparatorFormat("LINEFEED");
        } else if (this.wRowSeparatorFormat.getSelectionIndex() == 2) {
            in.setRowSeparatorFormat("CRLF");
        } else if (this.wRowSeparatorFormat.getSelectionIndex() == 3) {
            in.setRowSeparatorFormat("TAB");
        } else {
            in.setRowSeparatorFormat("CUSTOM");
        }
        int nrFiles = this.wFilenameList.getItemCount();
        in.allocate(nrFiles);
        in.setFileName(this.wFilenameList.getItems(0));
        in.setFileMask(this.wFilenameList.getItems(1));
        in.setExcludeFileMask(this.wFilenameList.getItems(2));
        in.setFileRequired(this.wFilenameList.getItems(3));
        in.setIncludeSubFolders(this.wFilenameList.getItems(4));
        if (this.wRowSeparator.getText().length() > 1) {
            if (this.wRowSeparator.getText().substring(0, 1).equals("\\")) {
                this.wRowSeparator.setText(this.wRowSeparator.getText().substring(0, 2));
            } else {
                this.wRowSeparator.setText(this.wRowSeparator.getText().substring(0, 1));
            }
        }
        in.setRowSeparator(this.wRowSeparator.getText());
        in.setSmartCount(this.wSmartCount.getSelection());
        in.setAddResultFile(this.wAddResult.getSelection());
        in.setFileField(this.wFileField.getSelection());
        in.setOutputFilenameField(this.wFilenameField.getText());
    }

    private void preview() {
        try {
            GetFilesRowsCountMeta oneMeta = new GetFilesRowsCountMeta();
            this.getInfo(oneMeta);
            PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.NumberRows.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    Pipeline pipeline = progressDialog.getPipeline();
                    String loggingText = progressDialog.getLoggingText();
                    if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                        etd.setReadOnly();
                        etd.open();
                    }
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                    prd.open();
                }
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetFilesRowsCountDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }
}

