/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.reservoirsampling;

import java.util.List;
import java.util.Objects;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.reservoirsampling.ReservoirSampling;
import org.apache.hop.pipeline.transforms.reservoirsampling.ReservoirSamplingData;
import org.w3c.dom.Node;

@Transform(id="ReservoirSampling", image="reservoirsampling.svg", name="i18n::BaseTransform.TypeLongDesc.ReservoirSampling", description="i18n::BaseTransform.TypeTooltipDesc.ReservoirSampling", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Statistics", documentationUrl="/pipeline/transforms/reservoirsampling.html")
public class ReservoirSamplingMeta
extends BaseTransformMeta
implements ITransformMeta<ReservoirSampling, ReservoirSamplingData> {
    public static final String XML_TAG = "reservoir_sampling";
    protected String m_sampleSize = "100";
    protected String m_randomSeed = "1";

    public String getSampleSize() {
        return this.m_sampleSize;
    }

    public void setSampleSize(String sampleS) {
        this.m_sampleSize = sampleS;
    }

    public String getSeed() {
        return this.m_randomSeed;
    }

    public void setSeed(String seed) {
        this.m_randomSeed = seed;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(100);
        retval.append(XmlHandler.openTag((String)XML_TAG)).append(Const.CR);
        retval.append(XmlHandler.addTagValue((String)"sample_size", (String)this.m_sampleSize));
        retval.append(XmlHandler.addTagValue((String)"seed", (String)this.m_randomSeed));
        retval.append(XmlHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return retval.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(((Object)((Object)this)).getClass())) {
            ReservoirSamplingMeta m = (ReservoirSamplingMeta)((Object)obj);
            return this.getXml() == m.getXml();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.m_sampleSize, this.m_randomSeed);
    }

    public void setDefault() {
        this.m_sampleSize = "100";
        this.m_randomSeed = "1";
    }

    public Object clone() {
        ReservoirSamplingMeta retval = (ReservoirSamplingMeta)((Object)super.clone());
        return retval;
    }

    public ITransform createTransform(TransformMeta transformMeta, ReservoirSamplingData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new ReservoirSampling(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        int nrTransforms = XmlHandler.countNodes((Node)transformNode, (String)XML_TAG);
        if (nrTransforms > 0) {
            Node reservoirnode = XmlHandler.getSubNodeByNr((Node)transformNode, (String)XML_TAG, (int)0);
            this.m_sampleSize = XmlHandler.getTagValue((Node)reservoirnode, (String)"sample_size");
            this.m_randomSeed = XmlHandler.getTagValue((Node)reservoirnode, (String)"seed");
        }
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, "Not receiving any fields from previous transforms!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, "Transform is connected to previous one, receiving " + prev.size() + " fields", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Transform is receiving info from other transforms.", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, "No input received from other transforms!", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public ReservoirSamplingData getTransformData() {
        return new ReservoirSamplingData();
    }
}

