/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.reservoirsampling;

import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transforms.reservoirsampling.ReservoirSamplingMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ReservoirSamplingDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ReservoirSamplingMeta.class;
    private Text mWTransformName;
    private TextVar mWSampleSize;
    private TextVar mWSeed;
    private final ReservoirSamplingMeta mCurrentMeta;
    private final ReservoirSamplingMeta mOriginalMeta;

    public ReservoirSamplingDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.mCurrentMeta = (ReservoirSamplingMeta)((Object)in);
        this.mOriginalMeta = (ReservoirSamplingMeta)((Object)this.mCurrentMeta.clone());
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.mCurrentMeta);
        ModifyListener lsMod = e -> this.mCurrentMeta.setChanged();
        this.changed = this.mCurrentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ReservoirSamplingDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        Label mWlTransformName = new Label((Composite)this.shell, 131072);
        mWlTransformName.setText(BaseMessages.getString(PKG, (String)"ReservoirSamplingDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)mWlTransformName);
        FormData mFdlTransformName = new FormData();
        mFdlTransformName.left = new FormAttachment(0, 0);
        mFdlTransformName.right = new FormAttachment(middle, -margin);
        mFdlTransformName.top = new FormAttachment(0, margin);
        mWlTransformName.setLayoutData((Object)mFdlTransformName);
        this.mWTransformName = new Text((Composite)this.shell, 18436);
        this.mWTransformName.setText(this.transformName);
        this.props.setLook((Control)this.mWTransformName);
        this.mWTransformName.addModifyListener(lsMod);
        FormData mFdTransformName = new FormData();
        mFdTransformName.left = new FormAttachment(middle, 0);
        mFdTransformName.top = new FormAttachment(0, margin);
        mFdTransformName.right = new FormAttachment(100, 0);
        this.mWTransformName.setLayoutData((Object)mFdTransformName);
        Label mWlSampleSize = new Label((Composite)this.shell, 131072);
        mWlSampleSize.setText(BaseMessages.getString(PKG, (String)"ReservoirSamplingDialog.SampleSize.Label", (String[])new String[0]));
        this.props.setLook((Control)mWlSampleSize);
        FormData mFdlSampleSize = new FormData();
        mFdlSampleSize.left = new FormAttachment(0, 0);
        mFdlSampleSize.right = new FormAttachment(middle, -margin);
        mFdlSampleSize.top = new FormAttachment((Control)this.mWTransformName, margin);
        mWlSampleSize.setLayoutData((Object)mFdlSampleSize);
        this.mWSampleSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.mWSampleSize);
        this.mWSampleSize.addModifyListener(lsMod);
        this.mWSampleSize.setText("" + this.mOriginalMeta.getSampleSize());
        FormData mFdSampleSize = new FormData();
        mFdSampleSize.left = new FormAttachment((Control)mWlSampleSize, margin);
        mFdSampleSize.right = new FormAttachment(100, -margin);
        mFdSampleSize.top = new FormAttachment((Control)this.mWTransformName, margin);
        this.mWSampleSize.setLayoutData((Object)mFdSampleSize);
        Label mWlSeed = new Label((Composite)this.shell, 131072);
        mWlSeed.setText(BaseMessages.getString(PKG, (String)"ReservoirSamplingDialog.Seed.Label", (String[])new String[0]));
        this.props.setLook((Control)mWlSeed);
        FormData mFdlSeed = new FormData();
        mFdlSeed.left = new FormAttachment(0, 0);
        mFdlSeed.right = new FormAttachment(middle, -margin);
        mFdlSeed.top = new FormAttachment((Control)this.mWSampleSize, margin);
        mWlSeed.setLayoutData((Object)mFdlSeed);
        this.mWSeed = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.mWSeed);
        this.mWSeed.addModifyListener(lsMod);
        this.mWSeed.setText("" + this.mOriginalMeta.getSeed());
        FormData mFdSeed = new FormData();
        mFdSeed.left = new FormAttachment((Control)mWlSeed, margin);
        mFdSeed.right = new FormAttachment(100, -margin);
        mFdSeed.top = new FormAttachment((Control)this.mWSampleSize, margin);
        this.mWSeed.setLayoutData((Object)mFdSeed);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.mWSeed);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.mWSampleSize.addModifyListener(e -> this.mWSampleSize.setToolTipText(this.variables.resolve(this.mWSampleSize.getText())));
        this.mWSeed.addModifyListener(e -> this.mWSeed.setToolTipText(this.variables.resolve(this.mWSeed.getText())));
        this.mCurrentMeta.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void cancel() {
        this.transformName = null;
        this.mCurrentMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.mWTransformName.getText())) {
            return;
        }
        this.transformName = this.mWTransformName.getText();
        this.mCurrentMeta.setSampleSize(this.mWSampleSize.getText());
        this.mCurrentMeta.setSeed(this.mWSeed.getText());
        if (!this.mOriginalMeta.equals((Object)this.mCurrentMeta)) {
            this.mCurrentMeta.setChanged();
            this.changed = this.mCurrentMeta.hasChanged();
        }
        this.dispose();
    }
}

