/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.coalesce;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.coalesce.CoalesceData;
import org.apache.hop.pipeline.transforms.coalesce.CoalesceField;
import org.apache.hop.pipeline.transforms.coalesce.CoalesceMeta;

public class CoalesceTransform
extends BaseTransform<CoalesceMeta, CoalesceData>
implements ITransform<CoalesceMeta, CoalesceData> {
    private static final Class<?> PKG = CoalesceMeta.class;

    public CoalesceTransform(TransformMeta transformMeta, CoalesceMeta meta, CoalesceData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"CoalesceTransform.Log.StartedProcessing", (String[])new String[0]));
            }
            this.first = false;
            ((CoalesceData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((CoalesceMeta)this.meta).getFields(((CoalesceData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            for (CoalesceField coalesce : ((CoalesceMeta)this.meta).getFields()) {
                String name = this.resolve(coalesce.getName());
                if (!Utils.isEmpty((CharSequence)name)) continue;
                throw new HopException(BaseMessages.getString(PKG, (String)"CoalesceTransform.Log.MissingFieldName", (String[])new String[0]));
            }
            this.checkInputFieldsExist((CoalesceMeta)this.meta);
        }
        IRowMeta inputRowMeta = this.getInputRowMeta();
        Object[] outputRowValues = new Object[((CoalesceData)this.data).outputRowMeta.size()];
        int outputIndex = 0;
        for (int inputIndex = 0; inputIndex < inputRowMeta.size(); ++inputIndex) {
            IValueMeta vm = inputRowMeta.getValueMeta(inputIndex);
            if (((CoalesceData)this.data).outputRowMeta.indexOfValue(vm.getName()) == -1) continue;
            outputRowValues[outputIndex++] = row[inputIndex];
        }
        for (CoalesceField coalesce : ((CoalesceMeta)this.meta).getFields()) {
            int inputIndex = this.getFirstNonNullValueIndex(inputRowMeta, row, coalesce.getInputFieldNames(), ((CoalesceMeta)this.meta).isTreatEmptyStringsAsNulls());
            String name = this.resolve(coalesce.getName());
            outputIndex = ((CoalesceData)this.data).outputRowMeta.indexOfValue(name);
            IValueMeta vm = ((CoalesceData)this.data).outputRowMeta.getValueMeta(outputIndex);
            try {
                Object result = null;
                if (inputIndex >= 0) {
                    result = vm.convertData(inputRowMeta.getValueMeta(inputIndex), row[inputIndex]);
                }
                outputRowValues[outputIndex++] = result;
            }
            catch (HopValueException e) {
                this.logError(BaseMessages.getString(PKG, (String)"CoalesceTransform.Log.DataIncompatibleError", (String[])new String[]{row[inputIndex].toString(), inputRowMeta.getValueMeta(inputIndex).toString(), vm.toString()}));
                throw e;
            }
        }
        this.putRow(((CoalesceData)this.data).outputRowMeta, outputRowValues);
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"CoalesceTransform.Log.WroteRowToNextTransform", (Object[])outputRowValues));
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Line nr " + this.getLinesRead());
        }
        return true;
    }

    private void checkInputFieldsExist(CoalesceMeta meta) throws HopException {
        IRowMeta prev = this.getInputRowMeta();
        for (CoalesceField coalesce : meta.getFields()) {
            ArrayList<String> missingFields = new ArrayList<String>();
            for (String field : coalesce.getInputFieldNames()) {
                IValueMeta vmi;
                if (Utils.isEmpty((CharSequence)field) || (vmi = prev.searchValueMeta(field)) != null) continue;
                missingFields.add(field);
            }
            if (missingFields.isEmpty()) continue;
            String errorText = BaseMessages.getString(PKG, (String)"CoalesceTransform.Log.MissingInputFields", (String[])new String[]{StringUtils.join(missingFields, (char)',')});
            throw new HopException(errorText);
        }
    }

    private int getFirstNonNullValueIndex(IRowMeta inputRowMeta, Object[] row, List<String> fields, boolean isTreatEmptyStringsAsNulls) {
        for (String fieldName : fields) {
            int index = inputRowMeta.indexOfValue(fieldName);
            if (index < 0) continue;
            if (!isTreatEmptyStringsAsNulls && row[index] != null) {
                return index;
            }
            if (!isTreatEmptyStringsAsNulls || row[index] == null || Utils.isEmpty((CharSequence)row[index].toString())) continue;
            return index;
        }
        return -1;
    }
}

