/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.coalesce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.coalesce.CoalesceData;
import org.apache.hop.pipeline.transforms.coalesce.CoalesceField;
import org.apache.hop.pipeline.transforms.coalesce.CoalesceTransform;

@Transform(id="Coalesce", name="i18n::Coalesce.Name", description="i18n::Coalesce.Description", image="coalesce.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", documentationUrl="/pipeline/transforms/coalesce.html")
public class CoalesceMeta
extends BaseTransformMeta
implements ITransformMeta<CoalesceTransform, CoalesceData> {
    private static final Class<?> PKG = CoalesceMeta.class;
    @HopMetadataProperty(key="field", groupKey="fields", injectionGroupDescription="CoalesceMeta.Injection.Fields", injectionKeyDescription="CoalesceMeta.Injection.Field")
    private List<CoalesceField> fields = new ArrayList<CoalesceField>();
    @HopMetadataProperty(key="empty_is_null", injectionKey="EMPTY_STRING_AS_NULLS", injectionKeyDescription="CoalesceMeta.Injection.EmptyStringAsNulls")
    private boolean treatEmptyStringsAsNulls;

    public CoalesceMeta() {
        this.fields = new ArrayList<CoalesceField>();
    }

    public CoalesceMeta(CoalesceMeta c) {
        this.treatEmptyStringsAsNulls = c.treatEmptyStringsAsNulls;
        for (CoalesceField field : c.getFields()) {
            this.fields.add(new CoalesceField(field));
        }
    }

    public CoalesceTransform createTransform(TransformMeta transformMeta, CoalesceData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new CoalesceTransform(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public CoalesceData getTransformData() {
        return new CoalesceData();
    }

    public void setDefault() {
        this.fields = new ArrayList<CoalesceField>();
        this.treatEmptyStringsAsNulls = false;
    }

    public boolean isTreatEmptyStringsAsNulls() {
        return this.treatEmptyStringsAsNulls;
    }

    public void setTreatEmptyStringsAsNulls(boolean value) {
        this.treatEmptyStringsAsNulls = value;
    }

    public Object clone() {
        return new CoalesceMeta(this);
    }

    public void getFields(IRowMeta rowMeta, String transformName, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        try {
            IRowMeta unalteredInputRowMeta = rowMeta.clone();
            for (CoalesceField coalesce : this.getFields()) {
                if (!coalesce.isRemoveFields()) continue;
                String name = variables.resolve(coalesce.getName());
                for (String fieldName : coalesce.getInputFieldNames()) {
                    if (rowMeta.indexOfValue(name) != -1 && name.equals(fieldName) || rowMeta.indexOfValue(fieldName) == -1) continue;
                    rowMeta.removeValueMeta(fieldName);
                }
            }
            for (CoalesceField coalesce : this.getFields()) {
                int type = ValueMetaFactory.getIdForValueMeta((String)coalesce.getType());
                if (type == 0) {
                    type = this.findDefaultValueType(unalteredInputRowMeta, coalesce);
                }
                String name = variables.resolve(coalesce.getName());
                IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)name, (int)type);
                valueMeta.setOrigin(transformName);
                int index = rowMeta.indexOfValue(name);
                if (index >= 0) {
                    rowMeta.setValueMeta(index, valueMeta);
                    continue;
                }
                rowMeta.addValueMeta(valueMeta);
            }
        }
        catch (Exception e) {
            throw new HopTransformException((Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (prev == null || prev.size() == 0) {
            remarks.add((ICheckResult)new CheckResult(3, BaseMessages.getString(PKG, (String)"CoalesceMeta.CheckResult.NotReceivingFieldsFromPreviousTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"CoalesceMeta.CheckResult.ReceivingFieldsFromPreviousTransforms", (Object[])new Object[]{prev.size()}), (ICheckResultSource)transformMeta));
        }
        if (input.length > 0) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"CoalesceMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"CoalesceMeta.CheckResult.NotReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
        boolean missing = false;
        for (CoalesceField coalesce : this.getFields()) {
            String message;
            HashSet<String> fields = new HashSet<String>();
            ArrayList<String> missingFields = new ArrayList<String>();
            ArrayList<String> duplicateFields = new ArrayList<String>();
            for (String fieldName : coalesce.getInputFieldNames()) {
                IValueMeta vmi;
                if (fields.contains(fieldName)) {
                    duplicateFields.add(fieldName);
                } else {
                    fields.add(fieldName);
                }
                if ((vmi = prev.searchValueMeta(fieldName)) != null) continue;
                missingFields.add(fieldName);
            }
            if (!missingFields.isEmpty()) {
                message = BaseMessages.getString(PKG, (String)"CoalesceMeta.CheckResult.MissingInputFields", (String[])new String[]{coalesce.getName(), StringUtils.join(missingFields, (char)',')});
                remarks.add((ICheckResult)new CheckResult(4, message, (ICheckResultSource)transformMeta));
                missing = true;
                continue;
            }
            if (!duplicateFields.isEmpty()) {
                message = BaseMessages.getString(PKG, (String)"CoalesceMeta.CheckResult.DuplicateInputFields", (String[])new String[]{coalesce.getName(), StringUtils.join(duplicateFields, (char)',')});
                remarks.add((ICheckResult)new CheckResult(4, message, (ICheckResultSource)transformMeta));
                missing = true;
                continue;
            }
            if (fields.isEmpty()) {
                message = BaseMessages.getString(PKG, (String)"CoalesceMeta.CheckResult.EmptyInputFields", (String[])new String[]{coalesce.getName()});
                remarks.add((ICheckResult)new CheckResult(4, message, (ICheckResultSource)transformMeta));
                missing = true;
                continue;
            }
            if (fields.size() >= 2) continue;
            message = BaseMessages.getString(PKG, (String)"CoalesceMeta.CheckResult.NotEnoughInputFields", (String[])new String[]{coalesce.getName()});
            remarks.add((ICheckResult)new CheckResult(3, message, (ICheckResultSource)transformMeta));
        }
        if (this.getFields().isEmpty()) {
            remarks.add((ICheckResult)new CheckResult(3, BaseMessages.getString(PKG, (String)"CoalesceMeta.CheckResult.NothingToCoalesce", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else if (!missing) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"CoalesceMeta.CheckResult.FoundAllInputFields", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
    }

    private int findDefaultValueType(IRowMeta inputRowMeta, CoalesceField coalesce) {
        int type = 0;
        boolean first = true;
        for (String field : coalesce.getInputFieldNames()) {
            if (first) {
                type = this.getInputFieldValueType(inputRowMeta, field);
                first = false;
                continue;
            }
            int otherType = this.getInputFieldValueType(inputRowMeta, field);
            if (type == otherType) continue;
            switch (type) {
                case 2: {
                    break;
                }
                case 5: {
                    if (otherType == 1) {
                        type = 1;
                        break;
                    }
                    if (otherType == 6) {
                        type = 6;
                        break;
                    }
                    type = 2;
                    break;
                }
                case 1: {
                    if (otherType == 5) break;
                    if (otherType == 6) {
                        type = 6;
                        break;
                    }
                    type = 2;
                    break;
                }
                case 3: {
                    if (otherType == 9) {
                        type = 9;
                        break;
                    }
                    type = 2;
                    break;
                }
                case 9: {
                    if (otherType == 3) break;
                    type = 2;
                    break;
                }
                case 6: {
                    if (otherType == 5 || otherType == 1) break;
                    type = 2;
                    break;
                }
                default: {
                    return 2;
                }
            }
        }
        if (type == 0) {
            type = 2;
        }
        return type;
    }

    private int getInputFieldValueType(IRowMeta inputRowMeta, String field) {
        int index = inputRowMeta.indexOfValue(field);
        if (index >= 0) {
            return inputRowMeta.getValueMeta(index).getType();
        }
        return 0;
    }

    public List<CoalesceField> getFields() {
        return this.fields;
    }

    public void setFields(List<CoalesceField> fields) {
        this.fields = fields == null ? Collections.emptyList() : fields;
    }
}

