/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.grpc.GrpcInterceptorProvider;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.auth.Credentials;
import com.google.cloud.NoCredentials;
import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.spi.v1.SpannerInterceptorProvider;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

public class SpannerAccessor
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SpannerAccessor.class);
    private static final String USER_AGENT_PREFIX = "Apache_Beam_Java";
    private static final ConcurrentHashMap<SpannerConfig, SpannerAccessor> spannerAccessors = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SpannerConfig, AtomicInteger> refcounts = new ConcurrentHashMap();
    private final Spanner spanner;
    private final DatabaseClient databaseClient;
    private final BatchClient batchClient;
    private final DatabaseAdminClient databaseAdminClient;
    private final SpannerConfig spannerConfig;
    private static final int MAX_MESSAGE_SIZE = 0x6400000;
    private static final int MAX_METADATA_SIZE = 32768;
    private static final int NUM_CHANNELS = 4;
    public static final Duration GRPC_KEEP_ALIVE_SECONDS = Duration.ofSeconds((long)120L);

    private SpannerAccessor(Spanner spanner, DatabaseClient databaseClient, DatabaseAdminClient databaseAdminClient, BatchClient batchClient, SpannerConfig spannerConfig) {
        this.spanner = spanner;
        this.databaseClient = databaseClient;
        this.databaseAdminClient = databaseAdminClient;
        this.batchClient = batchClient;
        this.spannerConfig = spannerConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpannerAccessor getOrCreate(SpannerConfig spannerConfig) {
        SpannerAccessor self = spannerAccessors.get(spannerConfig);
        if (self == null) {
            ConcurrentHashMap<SpannerConfig, SpannerAccessor> concurrentHashMap = spannerAccessors;
            synchronized (concurrentHashMap) {
                self = spannerAccessors.get(spannerConfig);
                if (self == null) {
                    LOG.info("Connecting to {}", (Object)spannerConfig);
                    self = SpannerAccessor.createAndConnect(spannerConfig);
                    spannerAccessors.put(spannerConfig, self);
                    refcounts.putIfAbsent(spannerConfig, new AtomicInteger(0));
                }
            }
        }
        int refcount = refcounts.get(spannerConfig).incrementAndGet();
        LOG.debug("getOrCreate(): refcount={} for {}", (Object)refcount, (Object)spannerConfig);
        return self;
    }

    private static SpannerAccessor createAndConnect(SpannerConfig spannerConfig) {
        ValueProvider<String> emulatorHost;
        ValueProvider<String> host;
        ServiceFactory<Spanner, SpannerOptions> serviceFactory;
        SpannerOptions.Builder builder = SpannerOptions.newBuilder();
        ValueProvider<org.joda.time.Duration> commitDeadline = spannerConfig.getCommitDeadline();
        if (commitDeadline != null && ((org.joda.time.Duration)commitDeadline.get()).getMillis() > 0L) {
            UnaryCallSettings.Builder commitSettings = builder.getSpannerStubSettingsBuilder().commitSettings();
            RetrySettings.Builder commitRetrySettings = commitSettings.getRetrySettings().toBuilder();
            commitSettings.setRetrySettings(commitRetrySettings.setTotalTimeout(Duration.ofMillis((long)((org.joda.time.Duration)commitDeadline.get()).getMillis())).setMaxRpcTimeout(Duration.ofMillis((long)((org.joda.time.Duration)commitDeadline.get()).getMillis())).setInitialRpcTimeout(Duration.ofMillis((long)((org.joda.time.Duration)commitDeadline.get()).getMillis())).build());
        }
        ServerStreamingCallSettings.Builder executeStreamingSqlSettings = builder.getSpannerStubSettingsBuilder().executeStreamingSqlSettings();
        RetrySettings.Builder executeSqlStreamingRetrySettings = executeStreamingSqlSettings.getRetrySettings().toBuilder();
        executeStreamingSqlSettings.setRetrySettings(executeSqlStreamingRetrySettings.setInitialRpcTimeout(Duration.ofMinutes((long)120L)).setMaxRpcTimeout(Duration.ofMinutes((long)120L)).setTotalTimeout(Duration.ofMinutes((long)120L)).build());
        ManagedInstantiatingExecutorProvider executorProvider = new ManagedInstantiatingExecutorProvider(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Cloud-Spanner-TransportChannel-%d").build());
        InstantiatingGrpcChannelProvider.Builder instantiatingGrpcChannelProvider = InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(0x6400000)).setMaxInboundMetadataSize(Integer.valueOf(32768)).setPoolSize(4).setExecutorProvider((ExecutorProvider)executorProvider).setKeepAliveTime(GRPC_KEEP_ALIVE_SECONDS).setInterceptorProvider((GrpcInterceptorProvider)SpannerInterceptorProvider.createDefault()).setAttemptDirectPath(true);
        ValueProvider<String> projectId = spannerConfig.getProjectId();
        if (projectId != null) {
            builder.setProjectId((String)projectId.get());
        }
        if ((serviceFactory = spannerConfig.getServiceFactory()) != null) {
            builder.setServiceFactory(serviceFactory);
        }
        if ((host = spannerConfig.getHost()) != null) {
            builder.setHost((String)host.get());
            instantiatingGrpcChannelProvider.setEndpoint(SpannerAccessor.getEndpoint((String)host.get()));
        }
        if ((emulatorHost = spannerConfig.getEmulatorHost()) != null) {
            builder.setEmulatorHost((String)emulatorHost.get());
            builder.setCredentials((Credentials)NoCredentials.getInstance());
        } else {
            final String userAgentString = "Apache_Beam_Java/" + ReleaseInfo.getReleaseInfo().getVersion();
            instantiatingGrpcChannelProvider.setHeaderProvider(new HeaderProvider(){

                public Map<String, String> getHeaders() {
                    HashMap<String, String> headers = new HashMap<String, String>();
                    headers.put("user-agent", userAgentString);
                    return headers;
                }
            });
            builder.setChannelProvider((TransportChannelProvider)instantiatingGrpcChannelProvider.build());
        }
        SpannerOptions options = builder.build();
        Spanner spanner = (Spanner)options.getService();
        String instanceId = (String)spannerConfig.getInstanceId().get();
        String databaseId = (String)spannerConfig.getDatabaseId().get();
        DatabaseClient databaseClient = spanner.getDatabaseClient(DatabaseId.of((String)options.getProjectId(), (String)instanceId, (String)databaseId));
        BatchClient batchClient = spanner.getBatchClient(DatabaseId.of((String)options.getProjectId(), (String)instanceId, (String)databaseId));
        DatabaseAdminClient databaseAdminClient = spanner.getDatabaseAdminClient();
        return new SpannerAccessor(spanner, databaseClient, databaseAdminClient, batchClient, spannerConfig);
    }

    private static String getEndpoint(String host) {
        URL url;
        try {
            url = new URL(host);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid host: " + host, e);
        }
        return String.format("%s:%s", url.getHost(), url.getPort() < 0 ? url.getDefaultPort() : url.getPort());
    }

    public DatabaseClient getDatabaseClient() {
        return this.databaseClient;
    }

    public BatchClient getBatchClient() {
        return this.batchClient;
    }

    public DatabaseAdminClient getDatabaseAdminClient() {
        return this.databaseAdminClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        int refcount = refcounts.getOrDefault(this.spannerConfig, new AtomicInteger(0)).decrementAndGet();
        LOG.debug("close(): refcount={} for {}", (Object)refcount, (Object)this.spannerConfig);
        if (refcount == 0) {
            ConcurrentHashMap<SpannerConfig, SpannerAccessor> concurrentHashMap = spannerAccessors;
            synchronized (concurrentHashMap) {
                if (refcounts.get(this.spannerConfig).get() <= 0) {
                    spannerAccessors.remove(this.spannerConfig);
                    refcounts.remove(this.spannerConfig);
                    LOG.info("Closing {} ", (Object)this.spannerConfig);
                    this.spanner.close();
                }
            }
        }
    }

    private static final class ManagedInstantiatingExecutorProvider
    implements ExecutorProvider {
        private static final int DEFAULT_MIN_THREAD_COUNT = 16;
        private final List<ScheduledExecutorService> executors = new ArrayList<ScheduledExecutorService>();
        private final ThreadFactory threadFactory;

        private ManagedInstantiatingExecutorProvider(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        public boolean shouldAutoClose() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ScheduledExecutorService getExecutor() {
            int numCpus = Runtime.getRuntime().availableProcessors();
            int numThreads = Math.max(16, numCpus);
            ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(numThreads, this.threadFactory);
            ManagedInstantiatingExecutorProvider managedInstantiatingExecutorProvider = this;
            synchronized (managedInstantiatingExecutorProvider) {
                this.executors.add(executor);
            }
            return executor;
        }
    }

    private static class CommitDeadlineSettingInterceptor
    implements ClientInterceptor {
        private final long commitDeadlineMilliseconds;

        private CommitDeadlineSettingInterceptor(org.joda.time.Duration commitDeadline) {
            this.commitDeadlineMilliseconds = commitDeadline.getMillis();
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            if (method.getFullMethodName().equals("google.spanner.v1.Spanner/Commit")) {
                callOptions = callOptions.withDeadlineAfter(this.commitDeadlineMilliseconds, TimeUnit.MILLISECONDS);
            }
            return next.newCall(method, callOptions);
        }
    }
}

