/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.io.Serializable;
import org.apache.beam.sdk.schemas.transforms.DropFields;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithTimestamps;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AddTimestampAttribute
extends PTransform<PCollection<Row>, PCollection<Row>> {
    private static final Logger LOG = LoggerFactory.getLogger(AddTimestampAttribute.class);
    private final boolean useTimestampAttribute;

    AddTimestampAttribute(boolean useTimestampAttribute) {
        this.useTimestampAttribute = useTimestampAttribute;
    }

    public PCollection<Row> expand(PCollection<Row> input) {
        PCollection rows;
        PCollection withTimestamp;
        PCollection pCollection = withTimestamp = this.useTimestampAttribute ? (PCollection)input.apply((PTransform)WithTimestamps.of((SerializableFunction & Serializable)row -> row.getDateTime("event_timestamp").toInstant())) : input;
        if (withTimestamp.getSchema().hasField("event_timestamp")) {
            if (!this.useTimestampAttribute) {
                LOG.warn(String.format("Dropping output field '%s' before writing to PubSub because this is a read-only column. To preserve this information you must configure a timestamp attribute.", "event_timestamp"));
            }
            rows = (PCollection)withTimestamp.apply((PTransform)DropFields.fields((String[])new String[]{"event_timestamp"}));
        } else {
            rows = withTimestamp;
        }
        return rows;
    }
}

