/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.Cell;
import com.google.bigtable.v2.Row;
import java.util.Comparator;
import java.util.List;
import org.apache.beam.sdk.io.gcp.bigtable.CellValueParser;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SimpleFunction;

class BigtableRowToBeamRowFn
extends SimpleFunction<Row, org.apache.beam.sdk.values.Row> {
    protected final Schema schema;
    private final CellValueParser valueParser = new CellValueParser();

    public BigtableRowToBeamRowFn(Schema schema) {
        this.schema = schema;
    }

    protected Cell getLastCell(List<Cell> cells) {
        return cells.stream().max(Comparator.comparingLong(Cell::getTimestampMicros)).orElseThrow(() -> new RuntimeException("Couldn't retrieve the most recent cell value"));
    }

    protected Object getCellValue(Cell cell, Schema.TypeName typeName) {
        return this.valueParser.getCellValue(cell, typeName);
    }
}

