/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.EncryptionConfiguration;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestinationCoderV2;
import org.apache.beam.sdk.io.gcp.bigquery.WriteTables;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.ShardedKey;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteTables<DestinationT>
extends PTransform<PCollection<KV<ShardedKey<DestinationT>, List<String>>>, PCollection<KV<TableDestination, String>>> {
    private static final Logger LOG = LoggerFactory.getLogger(WriteTables.class);
    private final boolean tempTable;
    private final BigQueryServices bqServices;
    private final PCollectionView<String> loadJobIdPrefixView;
    private final BigQueryIO.Write.WriteDisposition firstPaneWriteDisposition;
    private final BigQueryIO.Write.CreateDisposition firstPaneCreateDisposition;
    private final Set<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions;
    private final DynamicDestinations<?, DestinationT> dynamicDestinations;
    private final List<PCollectionView<?>> sideInputs;
    private final TupleTag<KV<TableDestination, String>> mainOutputTag;
    private final TupleTag<String> temporaryFilesTag;
    private final ValueProvider<String> loadJobProjectId;
    private final int maxRetryJobs;
    private final boolean ignoreUnknownValues;
    private final @Nullable String kmsKey;
    private final String sourceFormat;
    private final boolean useAvroLogicalTypes;
    private @Nullable BigQueryServices.DatasetService datasetService;
    private @Nullable BigQueryServices.JobService jobService;

    public WriteTables(boolean tempTable, BigQueryServices bqServices, PCollectionView<String> loadJobIdPrefixView, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, List<PCollectionView<?>> sideInputs, DynamicDestinations<?, DestinationT> dynamicDestinations, @Nullable ValueProvider<String> loadJobProjectId, int maxRetryJobs, boolean ignoreUnknownValues, String kmsKey, String sourceFormat, boolean useAvroLogicalTypes, Set<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions) {
        this.tempTable = tempTable;
        this.bqServices = bqServices;
        this.loadJobIdPrefixView = loadJobIdPrefixView;
        this.firstPaneWriteDisposition = writeDisposition;
        this.firstPaneCreateDisposition = createDisposition;
        this.sideInputs = sideInputs;
        this.dynamicDestinations = dynamicDestinations;
        this.mainOutputTag = new TupleTag("WriteTablesMainOutput");
        this.temporaryFilesTag = new TupleTag("TemporaryFiles");
        this.loadJobProjectId = loadJobProjectId;
        this.maxRetryJobs = maxRetryJobs;
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.kmsKey = kmsKey;
        this.sourceFormat = sourceFormat;
        this.useAvroLogicalTypes = useAvroLogicalTypes;
        this.schemaUpdateOptions = schemaUpdateOptions;
    }

    public PCollection<KV<TableDestination, String>> expand(PCollection<KV<ShardedKey<DestinationT>, List<String>>> input) {
        PCollectionTuple writeTablesOutputs = (PCollectionTuple)input.apply((PTransform)ParDo.of((DoFn)new WriteTablesDoFn()).withSideInputs(this.sideInputs).withOutputTags(this.mainOutputTag, TupleTagList.of(this.temporaryFilesTag)));
        ((PCollection)((PCollection)((PCollection)((PCollection)writeTablesOutputs.get(this.temporaryFilesTag).setCoder((Coder)StringUtf8Coder.of()).apply((PTransform)WithKeys.of((Object)null))).setCoder((Coder)KvCoder.of((Coder)VoidCoder.of(), (Coder)StringUtf8Coder.of())).apply((PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterPane.elementCountAtLeast((int)1))).discardingFiredPanes())).apply((PTransform)GroupByKey.create())).apply((PTransform)Values.create())).apply((PTransform)ParDo.of((DoFn)new GarbageCollectTemporaryFiles()));
        return writeTablesOutputs.get(this.mainOutputTag);
    }

    private BigQueryHelpers.PendingJob startLoad(BigQueryServices.JobService jobService, BigQueryServices.DatasetService datasetService, String jobIdPrefix, TableReference ref, TimePartitioning timePartitioning, Clustering clustering, @Nullable TableSchema schema, List<String> gcsUris, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, Set<BigQueryIO.Write.SchemaUpdateOption> schemaUpdateOptions) {
        JobConfigurationLoad loadConfig = new JobConfigurationLoad().setDestinationTable(ref).setSchema(schema).setSourceUris(gcsUris).setWriteDisposition(writeDisposition.name()).setCreateDisposition(createDisposition.name()).setSourceFormat(this.sourceFormat).setIgnoreUnknownValues(Boolean.valueOf(this.ignoreUnknownValues)).setUseAvroLogicalTypes(Boolean.valueOf(this.useAvroLogicalTypes));
        if (schemaUpdateOptions != null) {
            List options = schemaUpdateOptions.stream().map(Enum::name).collect(Collectors.toList());
            loadConfig.setSchemaUpdateOptions(options);
        }
        if (timePartitioning != null) {
            loadConfig.setTimePartitioning(timePartitioning);
            if (clustering != null) {
                loadConfig.setClustering(clustering);
            }
        }
        if (this.kmsKey != null) {
            loadConfig.setDestinationEncryptionConfiguration(new EncryptionConfiguration().setKmsKeyName(this.kmsKey));
        }
        String projectId = this.loadJobProjectId == null ? ref.getProjectId() : (String)this.loadJobProjectId.get();
        String bqLocation = BigQueryHelpers.getDatasetLocation(datasetService, ref.getProjectId(), ref.getDatasetId());
        BigQueryHelpers.PendingJob retryJob = new BigQueryHelpers.PendingJob((SerializableFunction<BigQueryHelpers.RetryJobId, Void>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            LOG.info("Loading {} files into {} using job {}, job id iteration {}", new Object[]{gcsUris.size(), ref, jobRef, jobId.getRetryIndex()});
            try {
                jobService.startLoadJob(jobRef, loadConfig);
            }
            catch (IOException | InterruptedException e) {
                LOG.warn("Load job {} failed with {}", (Object)jobRef, (Object)e.toString());
                throw new RuntimeException(e);
            }
            return null;
        }, (SerializableFunction<BigQueryHelpers.RetryJobId, Job>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            try {
                return jobService.pollJob(jobRef, Integer.MAX_VALUE);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, (SerializableFunction<BigQueryHelpers.RetryJobId, Job>)(SerializableFunction & Serializable)jobId -> {
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId.getJobId()).setLocation(bqLocation);
            try {
                return jobService.getJob(jobRef);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, this.maxRetryJobs, jobIdPrefix);
        return retryJob;
    }

    static void removeTemporaryFiles(Iterable<String> files) throws IOException {
        ImmutableList.Builder fileResources = ImmutableList.builder();
        for (String file : files) {
            fileResources.add((Object)FileSystems.matchNewResource((String)file, (boolean)false));
        }
        FileSystems.delete((Collection)fileResources.build(), (MoveOptions[])new MoveOptions[0]);
    }

    private static class GarbageCollectTemporaryFiles
    extends DoFn<Iterable<String>, Void> {
        private GarbageCollectTemporaryFiles() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            WriteTables.removeTemporaryFiles((Iterable)c.element());
        }
    }

    private class WriteTablesDoFn
    extends DoFn<KV<ShardedKey<DestinationT>, List<String>>, KV<TableDestination, String>> {
        private Map<DestinationT, String> jsonSchemas = Maps.newHashMap();
        private List<org.apache.beam.sdk.io.gcp.bigquery.WriteTables$WriteTablesDoFn.PendingJobData> pendingJobs = Lists.newArrayList();

        private WriteTablesDoFn() {
        }

        @DoFn.StartBundle
        public void startBundle(DoFn.StartBundleContext c) {
            this.jsonSchemas.clear();
            this.pendingJobs.clear();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, BoundedWindow window) throws Exception {
            TableSchema tableSchema;
            WriteTables.this.dynamicDestinations.setSideInputAccessorFromProcessContext(c);
            Object destination = ((ShardedKey)((KV)c.element()).getKey()).getKey();
            if (WriteTables.this.firstPaneCreateDisposition == BigQueryIO.Write.CreateDisposition.CREATE_NEVER) {
                tableSchema = null;
            } else if (this.jsonSchemas.containsKey(destination)) {
                tableSchema = BigQueryHelpers.fromJsonString(this.jsonSchemas.get(destination), TableSchema.class);
            } else {
                tableSchema = WriteTables.this.dynamicDestinations.getSchema(destination);
                Preconditions.checkArgument((tableSchema != null ? 1 : 0) != 0, (String)"Unless create disposition is %s, a schema must be specified, i.e. DynamicDestinations.getSchema() may not return null. However, create disposition is %s, and %s returned null for destination %s", (Object)((Object)BigQueryIO.Write.CreateDisposition.CREATE_NEVER), (Object)((Object)WriteTables.this.firstPaneCreateDisposition), (Object)WriteTables.this.dynamicDestinations, (Object)destination);
                this.jsonSchemas.put(destination, BigQueryHelpers.toJsonString(tableSchema));
            }
            TableDestination tableDestination = WriteTables.this.dynamicDestinations.getTable(destination);
            Preconditions.checkArgument((tableDestination != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may not return null, but %s returned null for destination %s", (Object)WriteTables.this.dynamicDestinations, (Object)destination);
            boolean destinationCoderSupportsClustering = !(WriteTables.this.dynamicDestinations.getDestinationCoder() instanceof TableDestinationCoderV2);
            Preconditions.checkArgument((tableDestination.getClustering() == null || destinationCoderSupportsClustering ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may only return destinations with clustering configured if a destination coder is supplied that supports clustering, but %s is configured to use TableDestinationCoderV2. Set withClustering() on BigQueryIO.write() and,  if you provided a custom DynamicDestinations instance, override getDestinationCoder() to return TableDestinationCoderV3.", (Object)WriteTables.this.dynamicDestinations);
            TableReference tableReference = tableDestination.getTableReference();
            if (Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
                BigQueryOptions options = (BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class);
                tableReference.setProjectId(options.getBigQueryProject() == null ? options.getProject() : options.getBigQueryProject());
                tableDestination = tableDestination.withTableReference(tableReference);
            }
            Integer partition = ((ShardedKey)((KV)c.element()).getKey()).getShardNumber();
            ArrayList partitionFiles = Lists.newArrayList((Iterable)((Iterable)((KV)c.element()).getValue()));
            String jobIdPrefix = BigQueryResourceNaming.createJobIdWithDestination((String)c.sideInput(WriteTables.this.loadJobIdPrefixView), tableDestination, partition, c.pane().getIndex());
            if (WriteTables.this.tempTable) {
                tableReference.setTableId(jobIdPrefix);
            }
            BigQueryIO.Write.WriteDisposition writeDisposition = WriteTables.this.firstPaneWriteDisposition;
            BigQueryIO.Write.CreateDisposition createDisposition = WriteTables.this.firstPaneCreateDisposition;
            if (c.pane().getIndex() > 0L && !WriteTables.this.tempTable) {
                writeDisposition = BigQueryIO.Write.WriteDisposition.WRITE_APPEND;
                createDisposition = BigQueryIO.Write.CreateDisposition.CREATE_NEVER;
            } else if (WriteTables.this.tempTable) {
                writeDisposition = BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE;
                createDisposition = BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED;
            }
            BigQueryHelpers.PendingJob retryJob = WriteTables.this.startLoad(this.getJobService(c.getPipelineOptions().as(BigQueryOptions.class)), this.getDatasetService(c.getPipelineOptions().as(BigQueryOptions.class)), jobIdPrefix, tableReference, tableDestination.getTimePartitioning(), tableDestination.getClustering(), tableSchema, partitionFiles, writeDisposition, createDisposition, WriteTables.this.schemaUpdateOptions);
            this.pendingJobs.add((org.apache.beam.sdk.io.gcp.bigquery.WriteTables$WriteTablesDoFn.PendingJobData)new PendingJobData(window, retryJob, partitionFiles, tableDestination, tableReference));
        }

        @DoFn.Teardown
        public void onTeardown() {
            try {
                if (WriteTables.this.datasetService != null) {
                    WriteTables.this.datasetService.close();
                    WriteTables.this.datasetService = null;
                }
                if (WriteTables.this.jobService != null) {
                    WriteTables.this.jobService.close();
                    WriteTables.this.jobService = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private BigQueryServices.DatasetService getDatasetService(PipelineOptions pipelineOptions) throws IOException {
            if (WriteTables.this.datasetService == null) {
                WriteTables.this.datasetService = WriteTables.this.bqServices.getDatasetService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
            }
            return WriteTables.this.datasetService;
        }

        private BigQueryServices.JobService getJobService(PipelineOptions pipelineOptions) throws IOException {
            if (WriteTables.this.jobService == null) {
                WriteTables.this.jobService = WriteTables.this.bqServices.getJobService((BigQueryOptions)pipelineOptions.as(BigQueryOptions.class));
            }
            return WriteTables.this.jobService;
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)"launchesBigQueryJobs", (Boolean)true).withLabel("This transform launches BigQuery jobs to read/write elements."));
        }

        @DoFn.FinishBundle
        public void finishBundle(DoFn.FinishBundleContext c) throws Exception {
            BigQueryServices.DatasetService datasetService = WriteTables.this.bqServices.getDatasetService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class));
            BigQueryHelpers.PendingJobManager jobManager = new BigQueryHelpers.PendingJobManager();
            for (PendingJobData pendingJobData : this.pendingJobs) {
                jobManager = jobManager.addPendingJob(pendingJobData.retryJob, (SerializableFunction<BigQueryHelpers.PendingJob, Exception>)(SerializableFunction & Serializable)j -> {
                    try {
                        if (pendingJob.tableDestination.getTableDescription() != null) {
                            TableReference ref = pendingJob.tableReference;
                            datasetService.patchTableDescription(ref.clone().setTableId(BigQueryHelpers.stripPartitionDecorator(ref.getTableId())), pendingJob.tableDestination.getTableDescription());
                        }
                        c.output(WriteTables.this.mainOutputTag, (Object)KV.of((Object)pendingJob.tableDestination, (Object)BigQueryHelpers.toJsonString(pendingJob.tableReference)), pendingJob.window.maxTimestamp(), pendingJob.window);
                        for (String file : pendingJob.partitionFiles) {
                            c.output(WriteTables.this.temporaryFilesTag, (Object)file, pendingJob.window.maxTimestamp(), pendingJob.window);
                        }
                        return null;
                    }
                    catch (IOException | InterruptedException e) {
                        return e;
                    }
                });
            }
            jobManager.waitForDone();
        }

        private class PendingJobData {
            final BoundedWindow window;
            final BigQueryHelpers.PendingJob retryJob;
            final List<String> partitionFiles;
            final TableDestination tableDestination;
            final TableReference tableReference;

            public PendingJobData(BoundedWindow window, BigQueryHelpers.PendingJob retryJob, List<String> partitionFiles, TableDestination tableDestination, TableReference tableReference) {
                this.window = window;
                this.retryJob = retryJob;
                this.partitionFiles = partitionFiles;
                this.tableDestination = tableDestination;
                this.tableReference = tableReference;
            }
        }
    }
}

